/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridCoords;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class GridCoordsPanel
extends JPanel {
    private JSpinner rowSpinner = this.makeSpinner();
    private JSpinner colSpinner = this.makeSpinner();
    private ChangeListener spinnerListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            GridCoordsPanel.this.valueChanged();
        }
    };

    public GridCoordsPanel() {
        super(new GridLayout(1, 2, 5, 5));
        this.add(this.rowSpinner);
        this.add(this.colSpinner);
    }

    public void setValue(GridCoords value) {
        this.setSpinner(this.rowSpinner, value == null ? 0 : value.getRow());
        this.setSpinner(this.colSpinner, value == null ? 0 : value.getCol());
    }

    public GridCoords getValue() {
        GridCoords result = new GridCoords((Integer)this.rowSpinner.getValue(), (Integer)this.colSpinner.getValue());
        return result;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.rowSpinner.setEnabled(enabled);
        this.colSpinner.setEnabled(enabled);
    }

    protected abstract void valueChanged();

    protected int getRangeMin() {
        return 0;
    }

    protected int getRangeMax() {
        return 2;
    }

    private JSpinner makeSpinner() {
        JSpinner result = new JSpinner(new SpinnerNumberModel(this.getRangeMin(), this.getRangeMin(), this.getRangeMax(), 1));
        ((JSpinner.DefaultEditor)result.getEditor()).getTextField().setColumns(4);
        result.addChangeListener(this.spinnerListener);
        return result;
    }

    private void setSpinner(JSpinner spinner, int value) {
        spinner.removeChangeListener(this.spinnerListener);
        spinner.setValue(value);
        spinner.addChangeListener(this.spinnerListener);
    }
}

