/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AddChildPanel
extends LabeledRowPanel {
    private final JTextField idField = new JTextField(20);
    private final Map<JRadioButton, Class<? extends ProjectComponent>> radioButtonMap = new HashMap<JRadioButton, Class<? extends ProjectComponent>>();

    public AddChildPanel(ProjectComponent parent) {
        Map<Class<? extends ProjectComponent>, Icon> childTypes = parent.getAddableChildTypes();
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("id: ", (Component)this.idField));
        ButtonGroup buttonGroup = new ButtonGroup();
        int i = 0;
        Class<? extends ProjectComponent> defaultType = null;
        for (Map.Entry<Class<? extends ProjectComponent>, Icon> entry : childTypes.entrySet()) {
            JRadioButton button = new JRadioButton();
            Class<? extends ProjectComponent> type = entry.getKey();
            this.radioButtonMap.put(button, type);
            buttonGroup.add(button);
            if (i == 0) {
                button.setSelected(true);
                defaultType = type;
            }
            rows.add(new LabeledRowPanel.LabeledRow(button, (Component)new JLabel(type.getSimpleName(), entry.getValue(), 2)));
            ++i;
        }
        String desiredID = defaultType == null ? "child" : defaultType.getSimpleName().toLowerCase();
        this.idField.setText(parent.newUniqueChildID(desiredID));
        this.setRows(rows);
    }

    public String getID() {
        return this.idField.getText().trim();
    }

    public Class<? extends ProjectComponent> getChildType() {
        for (Map.Entry<JRadioButton, Class<? extends ProjectComponent>> entry : this.radioButtonMap.entrySet()) {
            JRadioButton button = entry.getKey();
            if (!button.isSelected()) continue;
            return entry.getValue();
        }
        return null;
    }
}

