/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scanimport;

import com.sodiumarc.patchwork.app.scanimport.ImagePanel;
import com.sodiumarc.patchwork.sketch.SketchAsset;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.ColorComponent;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;

public class ScanImportPanel
extends JTabbedPane {
    private final ImagePanel rawImagePanel;
    private final ImagePanel processedImagePanel;
    private final JButton updateButton;
    private final JSpinner cleanBiasSpinner;
    private final JCheckBox cleanCheckbox;
    private final JCheckBox showFillCheckbox;
    private final JSpinner alphaScaleSpinner;
    private boolean fitScanToFill;
    private BufferedImage rawScanImage;
    private BufferedImage processedImage;
    private BufferedImage fillImage;
    private BufferedImage fillImageScaled;
    private final List<Point> chosenPoints = new ArrayList<Point>();
    private int lastPointIndex = -1;
    private int maxPoints = 2;
    private static final int REPLACE_RADIUS = 10;

    public ScanImportPanel() {
        this.rawImagePanel = new ImagePanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (this.getImage() != null) {
                    g.setColor(Color.RED);
                    for (Point point : ScanImportPanel.this.chosenPoints) {
                        ScanImportPanel.this.drawCross(g, point, 6);
                    }
                }
            }
        };
        this.rawImagePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ScanImportPanel.this.onClick(e.getPoint());
            }
        });
        this.processedImagePanel = new ImagePanel();
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ScanImportPanel.this.onKeyTyped(e.getKeyCode());
            }
        });
        this.showFillCheckbox = new JCheckBox("Show Fill");
        this.showFillCheckbox.setSelected(true);
        this.showFillCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScanImportPanel.this.updateProcessedImageDisplay();
                ScanImportPanel.this.updateEnabling();
            }
        });
        this.cleanCheckbox = new JCheckBox("Clean");
        this.cleanBiasSpinner = new JSpinner(new SpinnerNumberModel(5, 0, 100, 1));
        this.alphaScaleSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 10.0, 0.1));
        this.updateButton = new JButton("Update");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScanImportPanel.this.updateProcessedImage();
            }
        });
        JPanel controlPanel = new JPanel(new FlowLayout(2));
        controlPanel.add(new JLabel("Alpha Scale:"));
        controlPanel.add(this.alphaScaleSpinner);
        controlPanel.add(this.showFillCheckbox);
        controlPanel.add(this.cleanCheckbox);
        controlPanel.add(this.cleanBiasSpinner);
        controlPanel.add(this.updateButton);
        JPanel processedImageTabPanel = new JPanel(new BorderLayout(0, 5));
        processedImageTabPanel.add((Component)new JScrollPane(this.processedImagePanel), "Center");
        processedImageTabPanel.add((Component)controlPanel, "South");
        this.addTab("Original", new JScrollPane(this.rawImagePanel));
        this.addTab("Processed", processedImageTabPanel);
        this.updateEnabling();
    }

    public List<Point> getChosenPoints() {
        return this.chosenPoints;
    }

    public void setRawScanImage(BufferedImage image) {
        this.chosenPoints.clear();
        this.lastPointIndex = -1;
        this.rawScanImage = image;
        this.rawImagePanel.setImage(image);
    }

    public void setFillImage(BufferedImage fillImage) {
        this.fillImage = fillImage;
        this.updateEnabling();
    }

    public BufferedImage getProcessedImage() {
        if (this.processedImage == null) {
            this.updateProcessedImage();
        }
        return this.processedImage;
    }

    public void setFitScanToFill(boolean fitScanToFill) {
        this.fitScanToFill = fitScanToFill;
    }

    protected Rectangle4d getAutoCropRegion() {
        return new Rectangle4d(0.0, 0.0, 1.0, 1.0);
    }

    private BufferedImage getAutoCropImage(BufferedImage image, Rectangle4d regionProportional) {
        Point rightPoint;
        Point leftPoint;
        List<Point> points = this.getChosenPoints();
        if (points.size() < 2) {
            return image;
        }
        if (points.get((int)0).x > points.get((int)1).x) {
            leftPoint = points.get(1);
            rightPoint = points.get(0);
        } else {
            leftPoint = points.get(0);
            rightPoint = points.get(1);
        }
        double deltaX = rightPoint.x - leftPoint.x;
        double deltaY = rightPoint.y - leftPoint.y;
        double correctionAngle = -Math.atan(deltaY / deltaX);
        AffineTransform at = new AffineTransform();
        at.rotate(correctionAngle, leftPoint.getX(), leftPoint.getY());
        AffineTransformOp imageOp = new AffineTransformOp(at, 3);
        BufferedImage rotatedImage = imageOp.filter(image, null);
        Point2D leftRotated = at.transform(leftPoint, null);
        Point2D rightRotated = at.transform(rightPoint, null);
        leftPoint = new Point((int)leftRotated.getX(), (int)leftRotated.getY());
        rightPoint = new Point((int)rightRotated.getX(), (int)rightRotated.getY());
        int cropSize = rightPoint.x - leftPoint.x;
        Rectangle4d cropRegion = new Rectangle4d(leftPoint.x, leftPoint.y, cropSize, cropSize);
        Rectangle4d adjustedRegion = cropRegion.fromProportional(regionProportional);
        BufferedImage result = rotatedImage.getSubimage((int)adjustedRegion.getX(), (int)adjustedRegion.getY(), (int)adjustedRegion.getWidth(), (int)adjustedRegion.getHeight());
        return result;
    }

    private void scaleAlpha(BufferedImage image, float scale) {
        if (scale == 1.0f) {
            return;
        }
        int n = image.getWidth();
        for (int x = 0; x < n; ++x) {
            int m = image.getHeight();
            for (int y = 0; y < m; ++y) {
                int color = image.getRGB(x, y);
                int alpha = ColorUtils.getComponent(color, ColorComponent.ALPHA);
                alpha = Math.min((int)(scale * (float)alpha), 255);
                color = ColorUtils.setComponent(color, ColorComponent.ALPHA, alpha);
                image.setRGB(x, y, color);
            }
        }
    }

    private void updateProcessedImage() {
        float alphaScale;
        this.processedImage = this.rawScanImage;
        if (this.processedImage == null) {
            return;
        }
        this.processedImage = this.getAutoCropImage(this.processedImage, this.getAutoCropRegion());
        this.fillImageScaled = null;
        if (this.fillImage != null) {
            if (this.fitScanToFill) {
                this.fillImageScaled = this.fillImage;
                this.processedImage = ImageUtils.scale(this.processedImage, this.fillImage.getWidth(), this.fillImage.getHeight());
            } else {
                this.fillImageScaled = ImageUtils.scale(this.fillImage, this.processedImage.getWidth(), this.processedImage.getHeight());
            }
        }
        SketchAsset asset = new SketchAsset("dummy", this.processedImage, 1.0f, 1.0f);
        this.processedImage = asset.makeSplotchImage(Color.BLACK, true);
        if (this.cleanCheckbox.isSelected() && this.fillImageScaled != null) {
            int bias = (Integer)this.cleanBiasSpinner.getValue();
            this.processedImage = ImageUtils.mask(this.processedImage, this.fillImageScaled, bias);
        }
        if ((double)(alphaScale = ((Double)this.alphaScaleSpinner.getValue()).floatValue()) != 1.0) {
            this.scaleAlpha(this.processedImage, alphaScale);
        }
        this.updateProcessedImageDisplay();
    }

    private void updateProcessedImageDisplay() {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        if (this.showFillCheckbox.isSelected()) {
            CollectionUtils.addIfNotNull(images, this.fillImageScaled);
        }
        CollectionUtils.addIfNotNull(images, this.processedImage);
        this.processedImagePanel.setImages(images);
    }

    private void updateEnabling() {
        this.cleanCheckbox.setEnabled(this.rawScanImage != null && this.fillImage != null && this.showFillCheckbox.isSelected());
    }

    private void onClick(Point point) {
        if (this.rawScanImage != null) {
            this.requestFocusInWindow();
            int replaceIndex = -1;
            for (int i = 0; i < this.chosenPoints.size(); ++i) {
                if (!(this.chosenPoints.get(i).distance(point) < 10.0)) continue;
                replaceIndex = i;
                break;
            }
            if (replaceIndex != -1) {
                this.chosenPoints.set(replaceIndex, point);
                this.lastPointIndex = replaceIndex;
            } else {
                this.chosenPoints.add(point);
                if (this.chosenPoints.size() > this.maxPoints) {
                    this.chosenPoints.remove(0);
                }
                this.lastPointIndex = this.chosenPoints.size() - 1;
            }
            this.repaint();
            this.updateEnabling();
        }
    }

    private void onKeyTyped(int keyCode) {
        if (this.lastPointIndex == -1) {
            return;
        }
        int dx = 0;
        int dy = 0;
        switch (keyCode) {
            case 87: {
                dy = -1;
                break;
            }
            case 83: {
                dy = 1;
                break;
            }
            case 65: {
                dx = -1;
                break;
            }
            case 68: {
                dx = 1;
            }
        }
        Point old = this.chosenPoints.get(this.lastPointIndex);
        this.chosenPoints.set(this.lastPointIndex, new Point(old.x + dx, old.y + dy));
        this.repaint();
    }

    private void drawCross(Graphics graphics, Point center, int radius) {
        graphics.drawLine(center.x - radius, center.y, center.x + radius, center.y);
        graphics.drawLine(center.x, center.y - radius, center.x, center.y + radius);
    }
}

