/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scanimport;

import com.sodiumarc.patchwork.app.scanimport.OffsetImage;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private final List<ImagePanelLayer> layers = new ArrayList<ImagePanelLayer>();
    private Dimension frameSize;
    private boolean fillBackground = true;
    private boolean drawCheckerBoard;
    private boolean drawBorder = true;
    private Color compositeBackgroundColor;
    private OffsetImage compositeCache;
    private boolean autoRedraw = true;
    private boolean redrawNeeded = true;
    private static final Color VERY_LIGHT_GRAY = new Color(245, 245, 245);
    private static final Color CLEAR = new Color(0, 0, 0, 0);

    public ImagePanel() {
        this.setOpaque(true);
    }

    public BufferedImage getImage() {
        if (this.layers.isEmpty()) {
            return null;
        }
        return this.layers.get(0).getImage();
    }

    public Point getOrigin() {
        if (this.layers.isEmpty()) {
            return new Point(0, 0);
        }
        Dimension size = this.frameSize != null ? this.frameSize : this.getCombinedImageSize(false);
        int x = (this.getWidth() - size.width) / 2;
        x = Math.max(x, 0);
        int y = (this.getHeight() - size.height) / 2;
        y = Math.max(y, 0);
        return new Point(x, y);
    }

    public void setImage(BufferedImage image) {
        this.setImages(Collections.singletonList(image));
    }

    public void setImages(BufferedImage ... images) {
        this.setImages(Arrays.asList(images));
    }

    public void setImages(Iterable<BufferedImage> images) {
        this.layers.clear();
        for (BufferedImage image : images) {
            this.layers.add(new ImagePanelLayer(image, 0, 0, AlphaComposite.SrcOver));
        }
        this.compositeCache = null;
        this.setRedrawNeeded();
        this.revalidate();
    }

    public void addImage(BufferedImage image, int xOffset, int yOffset, boolean repaint) {
        this.layers.add(new ImagePanelLayer(image, xOffset, yOffset, AlphaComposite.SrcOver));
        this.compositeCache = null;
        if (repaint) {
            this.setRedrawNeeded();
        }
    }

    public void addImage(BufferedImage image, int xOffset, int yOffset, AlphaComposite alphaComposite, boolean repaint) {
        this.layers.add(new ImagePanelLayer(image, xOffset, yOffset, alphaComposite));
        this.compositeCache = null;
        if (repaint) {
            this.setRedrawNeeded();
        }
    }

    public void setLayers(List<ImagePanelLayer> layers) {
        this.layers.clear();
        this.layers.addAll(layers);
        this.compositeCache = null;
        this.setRedrawNeeded();
    }

    public void clear() {
        this.layers.clear();
        this.compositeCache = null;
        this.setRedrawNeeded();
        this.revalidate();
    }

    public void setFrameSize(Dimension frameSize) {
        this.frameSize = frameSize;
        this.setRedrawNeeded();
        this.revalidate();
    }

    public boolean isDrawCheckerBoard() {
        return this.drawCheckerBoard;
    }

    public void setDrawCheckerBoard(boolean showCheckerBoard) {
        this.drawCheckerBoard = showCheckerBoard;
    }

    public boolean isFillBackground() {
        return this.fillBackground;
    }

    public void setFillBackground(boolean fillBackground) {
        this.fillBackground = fillBackground;
        this.compositeCache = null;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
    }

    public Color getCompositeBackgroundColor() {
        return this.compositeBackgroundColor;
    }

    public void setCompositeBackgroundColor(Color compositeBackgroundColor) {
        this.compositeBackgroundColor = compositeBackgroundColor;
        this.compositeCache = null;
    }

    public BufferedImage paintToImage(boolean imagesOnly, boolean includeBackground) {
        Dimension size = this.getCombinedImageSize(true);
        if (size.height == 0 && size.width == 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        Graphics2D g = image.createGraphics();
        if (imagesOnly) {
            this.paintImages(g, includeBackground);
        } else {
            this.paint(g);
        }
        g.dispose();
        return image;
    }

    public boolean isAutoRedraw() {
        return this.autoRedraw;
    }

    public void setAutoRedraw(boolean autoRedraw) {
        this.autoRedraw = autoRedraw;
    }

    public boolean isRedrawNeeded() {
        return this.redrawNeeded;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getCombinedImageSize(true);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.fillBackground) {
            g.setColor(CLEAR);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else if (this.drawCheckerBoard) {
            ImageUtils.paintCheckerboard(g, new Rectangle(0, 0, this.getWidth(), this.getHeight()), 16, 16, Color.WHITE, VERY_LIGHT_GRAY);
        } else {
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.paintImages((Graphics2D)g, true);
        this.clearRedrawNeeded();
    }

    private void redraw() {
        this.repaint();
        this.clearRedrawNeeded();
    }

    private void setRedrawNeeded() {
        if (this.isAutoRedraw()) {
            this.redraw();
        } else {
            this.redrawNeeded = true;
        }
    }

    private void clearRedrawNeeded() {
        this.redrawNeeded = false;
    }

    private void paintImages(Graphics2D g, boolean includeBackground) {
        Point origin = this.getOrigin();
        OffsetImage composite = this.getCompositeImage(includeBackground);
        if (composite != null) {
            g.drawImage((Image)composite.getImage(), origin.x + composite.getXOffset(), origin.y + composite.getYOffset(), null);
        }
        Dimension borderSize = this.getCombinedImageSize(false);
        if (this.drawBorder && borderSize.width > 0 && borderSize.height > 0) {
            g.setColor(Color.BLUE);
            if (this.frameSize != null) {
                g.drawRect(origin.x - 1, origin.y - 1, this.frameSize.width + 2, this.frameSize.height + 2);
            } else {
                g.drawRect(origin.x - 1, origin.y - 1, borderSize.width + 2, borderSize.height + 2);
            }
        }
    }

    private OffsetImage getCompositeImage(boolean includeBackground) {
        if (includeBackground && this.compositeCache != null) {
            return this.compositeCache;
        }
        Rectangle totalBounds = OffsetImage.getCombinedBounds(this.layers);
        if (totalBounds == null || totalBounds.width == 0 || totalBounds.height == 0) {
            return null;
        }
        BufferedImage resultImage = new BufferedImage(totalBounds.width, totalBounds.height, 2);
        Graphics2D g = resultImage.createGraphics();
        if (includeBackground && this.compositeBackgroundColor != null) {
            g.setColor(this.compositeBackgroundColor);
            g.fillRect(0, 0, resultImage.getWidth(), resultImage.getHeight());
        }
        for (ImagePanelLayer layer : this.layers) {
            BufferedImage image = layer.getImage();
            if (image == null) continue;
            g.setComposite(layer.getAlphaComposite());
            int xOffset = layer.getXOffset() - totalBounds.x;
            int yOffset = layer.getYOffset() - totalBounds.y;
            g.drawImage((Image)layer.getImage(), xOffset, yOffset, null);
        }
        g.dispose();
        this.compositeCache = new OffsetImage(resultImage, totalBounds.x, totalBounds.y);
        return this.compositeCache;
    }

    private Dimension getCombinedImageSize(boolean includeOffset) {
        int maxWidth = 0;
        int maxHeight = 0;
        for (ImagePanelLayer layer : this.layers) {
            BufferedImage image = layer.getImage();
            if (image == null) continue;
            int adjustedWidth = image.getWidth();
            int adjustedHeight = image.getHeight();
            if (includeOffset) {
                adjustedWidth += Math.abs(layer.getXOffset());
                adjustedHeight += Math.abs(layer.getYOffset());
            }
            maxWidth = Math.max(maxWidth, adjustedWidth);
            maxHeight = Math.max(maxHeight, adjustedHeight);
        }
        return new Dimension(maxWidth, maxHeight);
    }

    public static class ImagePanelLayer
    extends OffsetImage {
        private final AlphaComposite alphaComposite;

        public ImagePanelLayer(BufferedImage image, int xOffset, int yOffset, AlphaComposite alphaComposite) {
            super(image, xOffset, yOffset);
            this.alphaComposite = alphaComposite;
        }

        AlphaComposite getAlphaComposite() {
            return this.alphaComposite;
        }
    }
}

