/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scanimport;

import com.sodiumarc.patchwork.app.scanimport.ImagePanel;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class AlignmentImagePanel
extends ImagePanel {
    private BufferedImage overlayImage;
    private BufferedImage overlayScaledImage;

    public BufferedImage getOverLayImage() {
        return this.overlayImage;
    }

    public void setOverLayImage(BufferedImage overLayImage) {
        this.overlayImage = overLayImage;
        this.updateOverlay();
        this.repaint();
    }

    @Override
    public void setImage(BufferedImage image) {
        super.setImage(image);
        this.updateOverlay();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.overlayScaledImage != null) {
            g.drawImage(this.overlayScaledImage, 0, 0, null);
        }
    }

    private void updateOverlay() {
        if (this.overlayImage == null) {
            return;
        }
        BufferedImage image = this.getImage();
        if (image == null) {
            return;
        }
        this.overlayScaledImage = ImageUtils.scale(this.overlayImage, image.getWidth(), image.getHeight());
    }
}

