/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.pipeline;

import com.sodiumarc.patchwork.generate.Card;
import com.sodiumarc.patchwork.render.control.RenderControl;
import com.sodiumarc.patchwork.render.control.RenderImage;
import com.sodiumarc.patchwork.util.ColorComponent;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LayerImagePrintable
implements Printable {
    public static float CELL_MARGIN = 0.02f;
    public static float TRACE_ALPHA = 0.3f;
    private final List<List<Object>> pages;
    private final RenderControl renderControl = RenderControl.getInstance();
    private final int imagesPerPage;
    private final Map<Object, RenderImage> lineImageCache;

    public LayerImagePrintable(List<Object> imageIDs, int imagesPerPage) {
        this.pages = new ArrayList<List<Object>>();
        this.imagesPerPage = imagesPerPage;
        this.lineImageCache = new HashMap<Object, RenderImage>();
        ArrayList<Object> page = new ArrayList<Object>();
        int i = 0;
        for (Object imageID : imageIDs) {
            if (i % imagesPerPage == 0 && !page.isEmpty()) {
                this.pages.add(page);
                page = new ArrayList();
            }
            page.add(imageID);
            ++i;
        }
        if (!page.isEmpty()) {
            this.pages.add(page);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.pages.size()) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Dimension pageDimension = new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        Dimension cellDimension = new Dimension(pageDimension.width / 2, pageDimension.height / this.imagesPerPage);
        int margin = (int)(CELL_MARGIN * (float)cellDimension.height);
        List<Object> page = this.pages.get(pageIndex);
        int row = 0;
        for (Object imageID : page) {
            RenderImage layerRenderImage = null;
            RenderImage fullRenderImage = null;
            int rowY = cellDimension.height * row;
            Rectangle leftCellRect = new Rectangle(margin, rowY + margin, cellDimension.width - margin * 2, cellDimension.height - margin * 2);
            int imageSize = Math.min(leftCellRect.width, leftCellRect.height);
            try {
                layerRenderImage = this.renderControl.getRenderImage(imageID, RenderControl.RenderCondition.NEVER);
                fullRenderImage = this.renderControl.getRenderImage(imageID, RenderControl.RenderCondition.NEVER);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (layerRenderImage != null && fullRenderImage != null) {
                BufferedImage layerImage = layerRenderImage.getBaseImage();
                BufferedImage fullImage = fullRenderImage.getBaseImage();
                boolean isDoubleSize = this.isDoubleSize(layerImage);
                if (layerImage != null && fullImage != null) {
                    if (!isDoubleSize) {
                        int reducedSize = (int)((double)imageSize * 0.9);
                        fullImage = ImageUtils.scale(fullImage, reducedSize, reducedSize);
                        graphics.drawImage(fullImage, leftCellRect.x, leftCellRect.y, null);
                        graphics.setColor(Color.GRAY);
                        graphics.drawRect(leftCellRect.x - 2, leftCellRect.y - 2, reducedSize + 4, reducedSize + 4);
                        graphics.setColor(Color.BLUE);
                        graphics.drawString(imageID.toString(), leftCellRect.x + 3, leftCellRect.y + leftCellRect.height - 3);
                    }
                    this.fade(layerImage, TRACE_ALPHA);
                    if (isDoubleSize) {
                        layerImage = ImageUtils.scale(layerImage, imageSize * 2, imageSize * 2);
                        graphics.drawImage(layerImage, leftCellRect.x, leftCellRect.y, null);
                        this.drawCross(graphics, new Point(leftCellRect.x + imageSize * 2, leftCellRect.y + imageSize), 5);
                        this.drawCross(graphics, new Point(leftCellRect.x + imageSize, leftCellRect.y + imageSize * 2), 5);
                        this.drawCross(graphics, new Point(leftCellRect.x + imageSize * 2, leftCellRect.y + imageSize * 2), 5);
                    } else {
                        Rectangle rightCellRect = new Rectangle(leftCellRect.x + cellDimension.width, leftCellRect.y, leftCellRect.width, leftCellRect.height);
                        layerImage = ImageUtils.scale(layerImage, imageSize, imageSize);
                        graphics.drawImage(layerImage, rightCellRect.x, rightCellRect.y, null);
                        Point topLeft = new Point(cellDimension.width, rowY);
                        Point bottomLeft = new Point(cellDimension.width, rowY + cellDimension.height);
                        this.drawCross(graphics, topLeft, 5);
                        this.drawCross(graphics, bottomLeft, 5);
                    }
                    graphics.setColor(Color.BLUE);
                }
            }
            ++row;
        }
        return 0;
    }

    private boolean isDoubleSize(BufferedImage image) {
        return image.getWidth() == 2 * Card.CARD_SIZE && image.getHeight() == 2 * Card.CARD_SIZE;
    }

    private void drawCross(Graphics graphics, Point center, int radius) {
        graphics.drawLine(center.x - radius, center.y, center.x + radius, center.y);
        graphics.drawLine(center.x, center.y - radius, center.x, center.y + radius);
    }

    private void fade(BufferedImage image, float mult) {
        int n = image.getWidth();
        for (int x = 0; x < n; ++x) {
            int m = image.getHeight();
            for (int y = 0; y < m; ++y) {
                int color = image.getRGB(x, y);
                int alpha = ColorUtils.getComponent(color, ColorComponent.ALPHA);
                int tone = ColorUtils.getIntensity(color);
                color = ColorUtils.toIntARGB((int)(mult * (float)alpha), tone, tone, tone);
                image.setRGB(x, y, color);
            }
        }
    }
}

