/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.pipeline;

import com.sodiumarc.patchwork.render.control.ImageOutputID;
import com.sodiumarc.patchwork.render.control.ImageOutputLayerID;
import com.sodiumarc.patchwork.render.control.RenderControl;
import com.sodiumarc.patchwork.render.control.RenderImage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ImageDisplayPanel
extends JPanel {
    private final JPanel canvas;
    private final JLabel imageLabel;
    private final Map<ImageOutputLayerID, BufferedImage> layerImagesByID;
    private final Set<Object> upToDateIDs;
    private Object currentImageID;
    private final ExecutorService appThread;
    private final RenderControl renderControl;

    public ImageDisplayPanel(ExecutorService appThread, RenderControl renderControl) {
        super(new BorderLayout());
        this.appThread = appThread;
        this.renderControl = renderControl;
        this.layerImagesByID = new HashMap<ImageOutputLayerID, BufferedImage>();
        this.upToDateIDs = new HashSet<Object>();
        this.canvas = new JPanel();
        this.imageLabel = new JLabel(" ");
        this.imageLabel.setOpaque(true);
        this.imageLabel.setBackground(Color.WHITE);
        this.add((Component)this.imageLabel, "North");
        JScrollPane scroller = new JScrollPane(this.canvas);
        scroller.setPreferredSize(new Dimension(350, 350));
        this.add((Component)scroller, "Center");
    }

    public void showImage(ImageOutputLayerID id) {
        this.setCurrentImageID(id);
        BufferedImage image = this.layerImagesByID.get(id);
        if (image != null) {
            this.drawImage(image);
            this.setUpToDate(this.upToDateIDs.contains(id));
        } else {
            this.loadRenderImage(id);
            this.setUpToDate(true);
        }
    }

    public void showImage(ImageOutputID id) {
        this.setCurrentImageID(id);
        this.drawImage(null);
        this.loadRenderImage(id);
        this.setUpToDate(true);
    }

    public void reloadImage(ImageOutputID id) {
        this.loadRenderImage(id);
    }

    public void reloadImage(ImageOutputLayerID id) {
        this.loadRenderImage(id);
        this.loadRenderImage(id.getImageOutputID());
    }

    private void setCurrentImageID(Object id) {
        this.currentImageID = id;
        if (id instanceof ImageOutputLayerID) {
            this.imageLabel.setText(((ImageOutputLayerID)id).getStringForm());
        } else if (id instanceof ImageOutputID) {
            this.imageLabel.setText(((ImageOutputID)id).getStringForm());
        } else {
            this.imageLabel.setText("");
        }
    }

    private void setUpToDate(boolean upToDate) {
        this.imageLabel.setBackground(upToDate ? Color.WHITE : Color.RED);
    }

    private void drawImage(Image image) {
        Graphics2D g = (Graphics2D)this.canvas.getGraphics();
        g.clearRect(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
        if (image != null) {
            g.drawImage(image, 0, 0, null);
        }
        g.dispose();
    }

    private void loadRenderImage(final Object id) {
        this.appThread.submit(new Runnable(){

            @Override
            public void run() {
                boolean upToDate;
                RenderImage renderImage;
                try {
                    if (id instanceof ImageOutputID) {
                        renderImage = ImageDisplayPanel.this.renderControl.getRenderImage((ImageOutputID)id, RenderControl.RenderCondition.NEVER);
                        upToDate = ImageDisplayPanel.this.renderControl.isRenderImageCurrent((ImageOutputID)id);
                    } else {
                        renderImage = ImageDisplayPanel.this.renderControl.getRenderImage((ImageOutputLayerID)id, RenderControl.RenderCondition.NEVER);
                        upToDate = ImageDisplayPanel.this.renderControl.isRenderImageCurrent((ImageOutputLayerID)id);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                final BufferedImage image = renderImage == null ? null : renderImage.getImage();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (id instanceof ImageOutputLayerID) {
                            ImageDisplayPanel.this.layerImagesByID.put((ImageOutputLayerID)id, image);
                        }
                        if (upToDate) {
                            ImageDisplayPanel.this.upToDateIDs.add(id);
                        } else {
                            ImageDisplayPanel.this.upToDateIDs.remove(id);
                        }
                        if (id.equals(ImageDisplayPanel.this.currentImageID)) {
                            ImageDisplayPanel.this.drawImage(image);
                            ImageDisplayPanel.this.setUpToDate(ImageDisplayPanel.this.upToDateIDs.contains(id));
                        }
                    }
                });
            }
        });
    }
}

