/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.layeredimage;

import com.sodiumarc.patchwork.app.layeredimage.LayeredImage;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import com.sodiumarc.patchwork.util.TargetablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OutputSettingsPanel
extends TargetablePanel<LayeredImage> {
    private JSpinner widthSpinner = this.makeSpinner();
    private JSpinner heightSpinner = this.makeSpinner();
    private ChangeListener spinnerListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            OutputSettingsPanel.this.onSizeChange();
        }
    };
    private JButton clearButton = new JButton("Clear");

    public OutputSettingsPanel() {
        super(new BorderLayout(5, 0));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputSettingsPanel.this.onSizeClear();
            }
        });
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        JPanel sizePanel = new JPanel();
        sizePanel.add(this.widthSpinner);
        sizePanel.add(this.heightSpinner);
        sizePanel.add(this.clearButton);
        rows.add(new LabeledRowPanel.LabeledRow("Output Size (Width/Height)", (Component)sizePanel));
        this.add((Component)new LabeledRowPanel(rows), "Center");
    }

    @Override
    protected void targetSet() {
        this.updateSpinners();
    }

    private JSpinner makeSpinner() {
        JSpinner result = new JSpinner(new SpinnerNumberModel(100, 1, 10000, 5));
        ((JSpinner.DefaultEditor)result.getEditor()).getTextField().setColumns(5);
        result.addChangeListener(this.spinnerListener);
        return result;
    }

    private void setSpinner(JSpinner spinner, int value) {
        spinner.removeChangeListener(this.spinnerListener);
        spinner.setValue(value);
        spinner.addChangeListener(this.spinnerListener);
    }

    private void onSizeChange() {
        LayeredImage target = (LayeredImage)this.getTarget();
        if (target != null) {
            Dimension size = new Dimension((Integer)this.widthSpinner.getValue(), (Integer)this.heightSpinner.getValue());
            target.setOutputSize(size);
            this.fireTargetModified();
        }
    }

    private void onSizeClear() {
        LayeredImage target = (LayeredImage)this.getTarget();
        if (target != null) {
            target.setOutputSize(null);
            this.updateSpinners();
            this.fireTargetModified();
        }
    }

    private void updateSpinners() {
        LayeredImage target = (LayeredImage)this.getTarget();
        if (target != null) {
            Dimension outputSize = target.getOutputSize();
            this.setSpinner(this.widthSpinner, outputSize.width);
            this.setSpinner(this.heightSpinner, outputSize.height);
        }
    }
}

