/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.layeredimage;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.app.common.ScrollableImagePanel;
import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.layeredimage.ImageLayer;
import com.sodiumarc.patchwork.app.layeredimage.ImageLayerPanel;
import com.sodiumarc.patchwork.app.layeredimage.LayeredImage;
import com.sodiumarc.patchwork.app.layeredimage.OutputSettingsPanel;
import com.sodiumarc.patchwork.render.RenderAppProperties;
import com.sodiumarc.patchwork.util.TargetableDialog;
import com.sodiumarc.patchwork.util.TargetablePanel;
import com.sodiumarc.patchwork.util.TargetablePanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class LayeredImagePanel
extends TargetablePanel<LayeredImage> {
    public static FileFilter IMAGE_FILTER = new FileFilter(){

        @Override
        public String getDescription() {
            return "Images";
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return FileUtils.hasFileExtension(file.getName(), "jpg") || FileUtils.hasFileExtension(file.getName(), "png");
        }
    };
    private JList layerList;
    private JButton addButton;
    private JButton deleteButton;
    private JButton promoteButton;
    private JButton demoteButton;
    private JButton editButton;
    private JCheckBox selectedOnlyCheckbox;
    private JLabel imageInfoLabel;
    private final ScrollableImagePanel imagePanel;
    private final TargetableDialog<ImageLayer> imageLayerDialog;
    private final OutputSettingsPanel outputSettingsPanel;
    private static JFileChooser FILE_CHOOSER;

    public static JFileChooser getImageFileChooser() {
        if (FILE_CHOOSER == null) {
            FILE_CHOOSER = new JFileChooser();
            FILE_CHOOSER.setFileSelectionMode(0);
            FILE_CHOOSER.setMultiSelectionEnabled(true);
        }
        return FILE_CHOOSER;
    }

    public LayeredImagePanel(List<String> layerNameOptions) {
        super(new BorderLayout(5, 5));
        JSplitPane split = new JSplitPane(1);
        split.setDividerLocation(200);
        this.imagePanel = new ScrollableImagePanel();
        ImageLayerPanel imageLayerPanel = new ImageLayerPanel(layerNameOptions);
        imageLayerPanel.addListener(new TargetablePanelListener(){

            @Override
            public void targetModified(TargetablePanel<?> source) {
                LayeredImagePanel.this.updateImageDisplay();
                LayeredImagePanel.this.repaint();
                LayeredImagePanel.this.fireTargetModified();
            }

            @Override
            public void targetChanged(TargetablePanel<?> source) {
            }
        });
        this.imageLayerDialog = new TargetableDialog<ImageLayer>(SwingUtilities.getWindowAncestor(this), "Edit Image Layer", Dialog.ModalityType.APPLICATION_MODAL, null, imageLayerPanel);
        this.outputSettingsPanel = new OutputSettingsPanel();
        this.outputSettingsPanel.addListener(new TargetablePanelListener(){

            @Override
            public void targetModified(TargetablePanel<?> source) {
                LayeredImagePanel.this.updateImageDisplay();
                LayeredImagePanel.this.fireTargetModified();
            }

            @Override
            public void targetChanged(TargetablePanel<?> source) {
            }
        });
        split.add(this.makeLayerListPanel());
        split.add(this.makeImageDisplayPanel());
        this.add((Component)split, "Center");
        this.setPreferredSize(new Dimension(620, 480));
        this.updateControlEnabling();
    }

    @Override
    protected void targetSet() {
        this.updateLayersFromTarget();
        this.updateControlEnabling();
        this.outputSettingsPanel.setTarget(this.getTarget());
    }

    protected File getDefaultImageDir() {
        return new File(RenderAppProperties.BASE_DIR.getValue(), RenderAppProperties.IMAGE_INPUT_DIR.getValue());
    }

    protected List<FileFilter> getChoosableFileFilters() {
        return Collections.emptyList();
    }

    private Component makeLayerListPanel() {
        JPanel panel = new JPanel(new BorderLayout(2, 0));
        this.layerList = new JList();
        this.layerList.setVisibleRowCount(4);
        this.layerList.setSelectionMode(0);
        this.layerList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LayeredImagePanel.this.onLayerSelection();
            }
        });
        final Icon layerIcon = IconLoader.loadIcon("silk/image.png");
        this.layerList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (component instanceof JLabel) {
                    JLabel label = (JLabel)component;
                    label.setIcon(layerIcon);
                }
                return component;
            }
        });
        JPanel buttonPanel = new JPanel(new GridLayout(1, 5, 2, 2));
        this.addButton = new JButton(IconLoader.loadIcon("silk/image_add.png"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LayeredImagePanel.this.onAddLayer();
            }
        });
        buttonPanel.add(this.addButton);
        this.deleteButton = new JButton(IconLoader.loadIcon("silk/image_delete.png"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LayeredImagePanel.this.onDeleteLayer();
            }
        });
        buttonPanel.add(this.deleteButton);
        this.promoteButton = new JButton(IconLoader.loadIcon("silk/arrow_up.png"));
        this.promoteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LayeredImagePanel.this.onPromoteLayer();
            }
        });
        buttonPanel.add(this.promoteButton);
        this.demoteButton = new JButton(IconLoader.loadIcon("silk/arrow_down.png"));
        this.demoteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LayeredImagePanel.this.onDemoteLayer();
            }
        });
        buttonPanel.add(this.demoteButton);
        this.editButton = new JButton(IconLoader.loadIcon("silk/image_edit.png"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LayeredImagePanel.this.onEditLayer();
            }
        });
        buttonPanel.add(this.editButton);
        panel.add((Component)new JScrollPane(this.layerList), "Center");
        panel.add((Component)buttonPanel, "South");
        panel.setBorder(BorderFactory.createTitledBorder("Image Layers"));
        return panel;
    }

    private Component makeImageDisplayPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        JPanel topPanel = new JPanel(new BorderLayout());
        this.selectedOnlyCheckbox = new JCheckBox("Show selected layer only");
        this.selectedOnlyCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayeredImagePanel.this.updateImageDisplay();
            }
        });
        JButton refreshButton = new JButton(IconLoader.loadIcon("silk/arrow_refresh.png"));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayeredImagePanel.this.onRefresh();
            }
        });
        topPanel.add((Component)this.selectedOnlyCheckbox, "West");
        topPanel.add((Component)refreshButton, "East");
        this.imageInfoLabel = new JLabel(" ");
        panel.add((Component)topPanel, "North");
        panel.add((Component)this.imagePanel, "Center");
        panel.add((Component)this.outputSettingsPanel, "South");
        panel.setBorder(BorderFactory.createTitledBorder("Image"));
        return panel;
    }

    private void onRefresh() {
        LayeredImage target = (LayeredImage)this.getTarget();
        if (target != null) {
            target.refresh();
        }
        this.updateImageDisplay();
    }

    private void onAddLayer() {
        JFileChooser chooser = LayeredImagePanel.getImageFileChooser();
        chooser.setCurrentDirectory(this.getDefaultImageDir());
        chooser.resetChoosableFileFilters();
        chooser.addChoosableFileFilter(IMAGE_FILTER);
        for (FileFilter choosableFilter : this.getChoosableFileFilters()) {
            chooser.addChoosableFileFilter(choosableFilter);
        }
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            for (File file : chooser.getSelectedFiles()) {
                ImageLayer newLayer = new ImageLayer(file);
                ((LayeredImage)this.getTarget()).addLayer(newLayer);
            }
            this.updateLayersFromTarget();
            this.updateControlEnabling();
            this.fireTargetModified();
        }
    }

    private void onDeleteLayer() {
        int result;
        ImageLayer selectedLayer = (ImageLayer)this.layerList.getSelectedValue();
        if (selectedLayer != null && (result = JOptionPane.showConfirmDialog(this, "Delete layer \"" + selectedLayer + "\"?", "Confirm Delete", 2)) == 0) {
            ((LayeredImage)this.getTarget()).removeLayer(selectedLayer);
        }
        this.updateLayersFromTarget();
        this.updateControlEnabling();
        this.fireTargetModified();
    }

    private void onPromoteLayer() {
        ImageLayer selectedLayer = (ImageLayer)this.layerList.getSelectedValue();
        if (selectedLayer != null) {
            ((LayeredImage)this.getTarget()).promoteLayer(selectedLayer);
        }
        this.updateLayersFromTarget();
        this.updateControlEnabling();
        this.fireTargetModified();
    }

    private void onDemoteLayer() {
        ImageLayer selectedLayer = (ImageLayer)this.layerList.getSelectedValue();
        if (selectedLayer != null) {
            ((LayeredImage)this.getTarget()).demoteLayer(selectedLayer);
        }
        this.updateLayersFromTarget();
        this.updateControlEnabling();
        this.fireTargetModified();
    }

    private void onEditLayer() {
        this.imageLayerDialog.showDialog();
    }

    private void onLayerSelection() {
        this.imageLayerDialog.getTargetablePanel().setTarget((ImageLayer)this.layerList.getSelectedValue());
        this.updateImageDisplay();
        this.updateControlEnabling();
    }

    private void updateImageDisplay() {
        BufferedImage image = null;
        LayeredImage target = (LayeredImage)this.getTarget();
        if (target != null) {
            if (this.selectedOnlyCheckbox.isSelected()) {
                ImageLayer selectedLayer = (ImageLayer)this.layerList.getSelectedValue();
                if (selectedLayer != null) {
                    image = selectedLayer.getProcessedImage();
                }
            } else {
                image = target.getCompositeImage();
            }
        }
        if (image != null) {
            this.imageInfoLabel.setText("Image Size: " + image.getWidth() + " x " + image.getHeight());
        } else {
            this.imageInfoLabel.setText(" ");
        }
        this.imagePanel.setImage(image);
    }

    private void updateControlEnabling() {
        int selectedLayerIndex = this.layerList.getSelectedIndex();
        LayeredImage target = (LayeredImage)this.getTarget();
        this.addButton.setEnabled(target != null);
        this.deleteButton.setEnabled(selectedLayerIndex >= 0);
        this.promoteButton.setEnabled(selectedLayerIndex > 0);
        this.demoteButton.setEnabled(target != null && selectedLayerIndex >= 0 && selectedLayerIndex < target.getLayers().size() - 1);
        this.editButton.setEnabled(selectedLayerIndex >= 0);
    }

    private void updateLayersFromTarget() {
        ImageLayer restoreLayer = (ImageLayer)this.layerList.getSelectedValue();
        DefaultListModel<ImageLayer> listModel = new DefaultListModel<ImageLayer>();
        LayeredImage target = (LayeredImage)this.getTarget();
        if (target != null) {
            List<ImageLayer> layers = target.getLayers();
            for (int i = layers.size() - 1; i >= 0; --i) {
                listModel.addElement(layers.get(i));
            }
        }
        this.layerList.setModel(listModel);
        if (restoreLayer != null) {
            this.layerList.setSelectedValue(restoreLayer, true);
        }
        this.updateImageDisplay();
        this.updateControlEnabling();
    }
}

