/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.layeredimage;

import com.sodiumarc.patchwork.app.layeredimage.ImageLayer;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.CompareUtilities;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import com.sodiumarc.patchwork.util.xml.SimpleTranscoder;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LayeredImage {
    private ChangeListener layerListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            LayeredImage.this.invalidate();
            LayeredImage.this.fireChanged();
        }
    };
    private final List<ImageLayer> layers = new ArrayList<ImageLayer>();
    private final UUID cacheUUID;
    private Dimension outputSize;
    private ImageLayer.ImageLoader imageLoader;
    private final List<ChangeListener> changeListeners;
    private BufferedImage compositeUnscaled;
    private BufferedImage compositeScaled;
    private boolean memCacheNeedsUpdate = true;
    private boolean diskCacheLoaded;
    private boolean diskCacheNeedsUpdate;
    private File cacheDir;

    public LayeredImage() {
        this(null);
    }

    public boolean isEmpty() {
        for (ImageLayer layer : this.layers) {
            if (layer.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void addLayer(ImageLayer layer) {
        this.addLayerImpl(layer);
        this.invalidate();
        this.fireChanged();
    }

    public void addLayer(File file) {
        this.addLayer(new ImageLayer(file));
    }

    public void removeLayer(ImageLayer layer) {
        this.layers.remove(layer);
        layer.removeChangeListener(this.layerListener);
        this.invalidate();
        this.fireChanged();
    }

    public ImageLayer.ImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public void setImageLoader(ImageLayer.ImageLoader imageLoader) {
        this.imageLoader = imageLoader;
        if (imageLoader != null) {
            for (ImageLayer layer : this.layers) {
                layer.setImageLoader(imageLoader);
            }
        }
    }

    public Dimension getOutputSize() {
        if (this.outputSize != null) {
            return this.outputSize;
        }
        return this.getCombinedImageSize();
    }

    public void setOutputSize(Dimension outputSize) {
        if (!CompareUtilities.equals(this.outputSize, outputSize)) {
            this.outputSize = outputSize;
            this.invalidate();
            this.fireChanged();
        }
    }

    public void promoteLayer(ImageLayer layer) {
        int oldIndex = this.layers.indexOf(layer);
        if (oldIndex < 0 || oldIndex == this.layers.size() - 1) {
            return;
        }
        this.layers.remove(layer);
        this.layers.add(oldIndex + 1, layer);
    }

    public void demoteLayer(ImageLayer layer) {
        int oldIndex = this.layers.indexOf(layer);
        if (oldIndex <= 0) {
            return;
        }
        this.layers.remove(layer);
        this.layers.add(oldIndex - 1, layer);
    }

    public List<ImageLayer> getLayers() {
        return this.layers;
    }

    public List<ImageLayer> getLayersByName(String name) {
        ArrayList<ImageLayer> result = new ArrayList<ImageLayer>();
        for (ImageLayer layer : this.getLayers()) {
            if (!CompareUtilities.equals(name, layer.getName())) continue;
            result.add(layer);
        }
        return result;
    }

    public List<BufferedImage> getLayerImages() {
        ArrayList<BufferedImage> result = new ArrayList<BufferedImage>();
        for (ImageLayer layer : this.getLayers()) {
            result.add(layer.getProcessedImage());
        }
        return result;
    }

    public BufferedImage getCompositeImage() {
        this.updateComposite();
        return this.compositeScaled;
    }

    public BufferedImage getCompositeUnscaled() {
        if (this.isEmpty()) {
            return null;
        }
        Dimension size = this.getCombinedImageSize();
        if (size.width == 0 || size.height == 0) {
            return null;
        }
        if (this.layers.size() == 1) {
            return this.layers.get(0).getProcessedImage();
        }
        BufferedImage result = new BufferedImage(size.width, size.height, 2);
        Graphics2D g = (Graphics2D)result.getGraphics();
        g.setComposite(AlphaComposite.SrcOver);
        for (BufferedImage image : this.getLayerImages()) {
            g.drawImage((Image)image, 0, 0, null);
        }
        g.dispose();
        return result;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void refresh() {
        this.invalidate();
        for (ImageLayer layer : this.layers) {
            layer.refresh();
        }
        this.fireChanged();
    }

    private LayeredImage(UUID cacheUUID) {
        this.cacheUUID = cacheUUID == null ? UUID.randomUUID() : cacheUUID;
        this.changeListeners = new ArrayList<ChangeListener>();
    }

    private void addLayerImpl(ImageLayer layer) {
        this.layers.add(layer);
        layer.addChangeListener(this.layerListener);
        if (this.imageLoader != null) {
            layer.setImageLoader(this.imageLoader);
        }
    }

    private void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener listener : new ArrayList<ChangeListener>(this.changeListeners)) {
            listener.stateChanged(changeEvent);
        }
    }

    private Dimension getCombinedImageSize() {
        int maxWidth = 0;
        int maxHeight = 0;
        for (ImageLayer layer : this.getLayers()) {
            BufferedImage image = layer.getProcessedImage();
            if (image == null) continue;
            maxWidth = Math.max(maxWidth, image.getWidth());
            maxHeight = Math.max(maxHeight, image.getHeight());
        }
        return new Dimension(maxWidth, maxHeight);
    }

    private void updateComposite() {
        if (!this.diskCacheNeedsUpdate) {
            this.loadCacheImage();
        }
        if (!this.memCacheNeedsUpdate) {
            return;
        }
        this.compositeUnscaled = this.getCompositeUnscaled();
        this.compositeScaled = this.compositeUnscaled != null && this.outputSize != null ? ImageUtils.scale(this.compositeUnscaled, this.outputSize.width, this.outputSize.height) : this.compositeUnscaled;
        this.memCacheNeedsUpdate = false;
    }

    private void saveCacheImage() {
        if (this.diskCacheNeedsUpdate && !this.isEmpty() && this.compositeScaled != null && this.cacheDir != null) {
            File cacheFile = new File(this.cacheDir, this.cacheUUID.toString() + ".png");
            try {
                ImageUtils.saveImage(this.compositeScaled, cacheFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.diskCacheNeedsUpdate = false;
        }
    }

    private void loadCacheImage() {
        if (!this.diskCacheLoaded && this.cacheDir != null) {
            File cacheFile = new File(this.cacheDir, this.cacheUUID.toString() + ".png");
            try {
                this.compositeScaled = ImageIO.read(cacheFile);
                if ((double)this.compositeScaled.getWidth() == this.outputSize.getWidth() && (double)this.compositeScaled.getHeight() == this.outputSize.getHeight()) {
                    this.memCacheNeedsUpdate = false;
                } else {
                    this.compositeScaled = null;
                }
            }
            catch (IOException e) {
                this.diskCacheNeedsUpdate = true;
            }
        }
        this.diskCacheLoaded = true;
    }

    private void invalidate() {
        this.memCacheNeedsUpdate = true;
        this.diskCacheNeedsUpdate = true;
    }

    public static class Transcoder
    extends SimpleTranscoder<LayeredImage> {
        private static final String ELEMENT_NAME = "LayeredImage";
        private static final String FIELD_IMAGE_LAYERS = "imageLayers";
        private static final String ATTR_CACHE_UUID = "cacheUUID";
        private static final String ATTR_SCALE_TO_SIZE = "scaleToSize";

        public Transcoder() {
            super(ELEMENT_NAME, LayeredImage.class);
            this.setFieldTranscoder(FIELD_IMAGE_LAYERS, new ImageLayer.Transcoder());
        }

        @Override
        protected LayeredImage decode(Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            String uuidStr = attributes.get(ATTR_CACHE_UUID);
            UUID uuid = null;
            if (uuidStr != null) {
                uuid = UUID.fromString(uuidStr);
            }
            LayeredImage result = new LayeredImage(uuid);
            for (Object image : decodedChildren.getAll(FIELD_IMAGE_LAYERS)) {
                result.addLayerImpl((ImageLayer)image);
            }
            String sizeStr = attributes.get(ATTR_SCALE_TO_SIZE);
            if (sizeStr != null) {
                result.outputSize = StringUtils.decodeDimension(sizeStr);
            }
            return result;
        }

        @Override
        protected void getAttributes(LayeredImage object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_CACHE_UUID, object.cacheUUID.toString());
            if (object.outputSize != null) {
                destination.put(ATTR_SCALE_TO_SIZE, StringUtils.encodeDimension(object.outputSize));
            }
        }

        @Override
        protected void getChildren(LayeredImage object, MultiMap<String, Object> destination) {
            for (ImageLayer image : object.getLayers()) {
                destination.putLast(FIELD_IMAGE_LAYERS, image);
            }
            object.saveCacheImage();
        }
    }
}

