/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.common;

import com.sodiumarc.patchwork.app.ApplicationProperties;
import com.sodiumarc.patchwork.app.common.ProgressObserver;
import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.util.CompareUtilities;
import com.sodiumarc.patchwork.util.MathUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.MouseInputListener;

public abstract class SimpleApp
extends JFrame {
    private final String title;
    private final Dimension launchSize;
    private final ExecutorService appThread;
    private final JMenuBar menuBar;
    private JMenu appMenu;
    private BlockerPanel blockerPanel;
    private AbstractAction saveAction;
    private boolean saveAlwaysEnabled;
    private int appMenuItemsAdded;
    private boolean appMenuEnabled = true;
    private boolean inputEnabled;
    private DisplayMode initialDisplayMode;
    private DisplayMode currentDisplayMode;
    private boolean isFullscreen;

    protected static final void loadProperties() {
        ApplicationProperties.load();
    }

    protected static final void launchApp(String[] args, final SimpleApp app) {
        SimpleApp.loadProperties();
        ApplicationProperties.parseArgs(args);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    app.launch();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public SimpleApp(String title, int width, int height) throws HeadlessException {
        super(title);
        this.title = title;
        this.launchSize = new Dimension(width, height);
        this.appThread = Executors.newSingleThreadExecutor();
        this.menuBar = new JMenuBar();
        this.blockerPanel = new BlockerPanel();
        this.setGlassPane(this.blockerPanel);
        this.saveAction = new AbstractAction("Save", IconLoader.loadIcon("silk/disk.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleApp.this.onSave();
                if (!SimpleApp.this.saveAlwaysEnabled) {
                    SimpleApp.this.setSaveRequired(false);
                }
            }
        };
        this.saveAction.setEnabled(false);
        this.inputEnabled = true;
    }

    protected abstract Component createMainPanel(SimpleApp var1);

    protected void onLaunch() {
    }

    protected void onSave() {
    }

    public boolean isSaveAlwaysEnabled() {
        return this.saveAlwaysEnabled;
    }

    public void setSaveAlwaysEnabled(boolean saveAlwaysEnabled) {
        this.saveAlwaysEnabled = saveAlwaysEnabled;
        if (saveAlwaysEnabled) {
            this.setSaveRequired(true);
        }
    }

    protected final void setSaveRequired(boolean saveRequired) {
        this.setTitle(saveRequired && !this.saveAlwaysEnabled ? this.title + " *" : this.title);
        this.saveAction.setEnabled(saveRequired);
    }

    protected final void executeInBackground(Runnable task) {
        this.appThread.execute(task);
    }

    protected final void setAppMenuEnabled(boolean enabled) {
        this.appMenuEnabled = enabled;
    }

    protected final void addAppMenuItem(Action action, String keystroke) {
        if (this.appMenuItemsAdded == 0) {
            this.appMenu.add((Component)new JSeparator(), 1);
            this.appMenu.add((Component)new JSeparator(), 2);
        }
        JMenuItem menuItem = new JMenuItem(action);
        if (keystroke != null) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke(keystroke));
        }
        this.appMenu.add((Component)menuItem, this.appMenuItemsAdded + 2);
        ++this.appMenuItemsAdded;
    }

    protected final void addMenuItem(JMenu menu, Action action, String keystroke) {
        JMenuItem menuItem = new JMenuItem(action);
        if (keystroke != null) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke(keystroke));
        }
        menu.add(menuItem);
    }

    protected final void addMenuSeparator(JMenu menu) {
        menu.add(new JSeparator());
    }

    protected final void addCheckBoxItem(JMenu menu, Action action, String keystroke, boolean selected) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(action);
        menuItem.setSelected(selected);
        if (keystroke != null) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke(keystroke));
        }
        menu.add(menuItem);
    }

    protected final void addRadioButtonItem(JMenu menu, Action action, String keystroke, ButtonGroup group, boolean selected) {
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(action);
        menuItem.setSelected(selected);
        group.add(menuItem);
        if (keystroke != null) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke(keystroke));
        }
        menu.add(menuItem);
    }

    protected final JMenu addMenu(String menuName) {
        JMenu menu = new JMenu(menuName);
        this.menuBar.add(menu);
        return menu;
    }

    protected void setInputEnabled(boolean enabled) {
        if (this.inputEnabled == enabled) {
            return;
        }
        if (enabled) {
            this.blockerPanel.unBlock();
        } else {
            this.blockerPanel.block();
        }
        this.inputEnabled = enabled;
    }

    protected void exit() {
        if (this.saveAction.isEnabled()) {
            int paneResult = JOptionPane.showConfirmDialog(this, "Save changes?", "Unsaved Changes", 1);
            if (paneResult == 2) {
                return;
            }
            if (paneResult == 0) {
                this.onSave();
            }
        }
        this.appThread.shutdownNow();
        System.exit(0);
    }

    protected boolean isFullScreenSupported() {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        return device.isFullScreenSupported();
    }

    protected void setFullscreen(boolean fullscreen, DisplayMode dispMode) {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (!device.isFullScreenSupported()) {
            return;
        }
        if (this.initialDisplayMode == null) {
            this.initialDisplayMode = device.getDisplayMode();
        }
        if (this.isFullscreen != fullscreen || !CompareUtilities.equals(dispMode, this.currentDisplayMode)) {
            if (fullscreen) {
                try {
                    this.setVisible(false);
                    this.dispose();
                    this.setUndecorated(true);
                    device.setFullScreenWindow(this);
                    if (device.isDisplayChangeSupported() && dispMode != null) {
                        device.setDisplayMode(dispMode);
                        this.currentDisplayMode = dispMode;
                    }
                    this.setResizable(false);
                    this.setAlwaysOnTop(false);
                    this.setVisible(true);
                }
                catch (Throwable t) {
                    fullscreen = false;
                }
            }
            if (!fullscreen) {
                if (device.isDisplayChangeSupported() && this.initialDisplayMode != null) {
                    device.setDisplayMode(this.initialDisplayMode);
                    this.currentDisplayMode = this.initialDisplayMode;
                }
                this.setVisible(false);
                this.dispose();
                this.setUndecorated(false);
                device.setFullScreenWindow(null);
                this.setLocationRelativeTo(null);
                this.setResizable(true);
                this.setSize(this.launchSize);
                this.setVisible(true);
            }
            this.isFullscreen = fullscreen;
            this.repaint();
        }
    }

    protected List<DisplayMode> getCompatibleDisplayModes() {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode[] modes = device.getDisplayModes();
        DisplayMode currentMode = device.getDisplayMode();
        ArrayList<DisplayMode> result = new ArrayList<DisplayMode>(modes.length);
        for (DisplayMode mode : modes) {
            if (mode.getRefreshRate() != currentMode.getRefreshRate() || mode.getBitDepth() != currentMode.getBitDepth()) continue;
            result.add(mode);
        }
        return result;
    }

    protected DisplayMode chooseBestDisplayMode(List<DisplayMode> modes, Dimension preferredSize) {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode currentMode = device.getDisplayMode();
        float currentAspect = (float)currentMode.getWidth() / (float)currentMode.getHeight();
        DisplayMode bestMode = null;
        for (DisplayMode mode : modes) {
            float modeAspect = (float)mode.getWidth() / (float)mode.getHeight();
            if (mode.getWidth() < preferredSize.width || mode.getHeight() < preferredSize.height || !MathUtils.epsilonEquals(modeAspect, currentAspect, 0.1)) continue;
            if (bestMode == null) {
                bestMode = mode;
                continue;
            }
            if (mode.getHeight() >= bestMode.getHeight() && mode.getWidth() >= bestMode.getWidth()) continue;
            bestMode = mode;
        }
        return bestMode;
    }

    private void launch() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                SimpleApp.this.exit();
            }
        });
        this.setJMenuBar(this.menuBar);
        if (this.appMenuEnabled) {
            this.createAppMenu();
        }
        this.setContentPane(this.createContentPane());
        this.pack();
        this.setSize(this.launchSize);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.onLaunch();
    }

    private void createAppMenu() {
        AbstractAction exitAction = new AbstractAction("Exit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleApp.this.exit();
            }
        };
        this.appMenu = this.addMenu("Application");
        this.addMenuItem(this.appMenu, this.saveAction, "control S");
        this.addMenuItem(this.appMenu, exitAction, null);
    }

    private Container createContentPane() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.add(this.createMainPanel(this));
        return panel;
    }

    private static class BlockerPanel
    extends JPanel
    implements MouseInputListener {
        private Cursor oldCursor;

        public BlockerPanel() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setOpaque(false);
            this.setLayout(null);
        }

        public void block() {
            this.oldCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.setVisible(true);
        }

        public void unBlock() {
            this.setCursor(this.oldCursor);
            this.setVisible(false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Toolkit.getDefaultToolkit().beep();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    public abstract class BlockingWorker<T, V>
    extends SwingWorker<T, V> {
        private final ProgressObserver observer = new ProgressObserver(){

            @Override
            public void setProgress(int completed, int total, String message) {
                int progress = total == 0 ? 100 : (int)(100.0f * ((float)completed / (float)total));
                BlockingWorker.this.setProgress(progress);
            }

            @Override
            public boolean hasBeenCancelled() {
                return BlockingWorker.this.isCancelled();
            }
        };

        public BlockingWorker(final ProgressMonitor progressMonitor) {
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("progress".equals(evt.getPropertyName())) {
                        int percentComplete = (Integer)evt.getNewValue();
                        BlockingWorker.this.progressChanged(percentComplete);
                        if (progressMonitor != null) {
                            if (progressMonitor.isCanceled()) {
                                BlockingWorker.this.cancel(false);
                            }
                            progressMonitor.setProgress(percentComplete);
                        }
                    }
                }
            });
        }

        @Override
        protected final T doInBackground() throws Exception {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SimpleApp.this.setInputEnabled(false);
                }
            });
            return this.doInBackground(this.observer);
        }

        @Override
        protected final void done() {
            SimpleApp.this.setInputEnabled(true);
            try {
                T result = this.isCancelled() ? null : (T)this.get();
                this.done(result);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }

        protected abstract T doInBackground(ProgressObserver var1) throws Exception;

        protected void progressChanged(int percentComplete) {
        }

        protected void done(T result) throws Exception {
        }

        protected void handleException(Exception e) {
            e.printStackTrace();
        }
    }
}

