/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class ApplicationProperties {
    private static final String SYSTEM_PROPERTIES_FILENAME = "system.properties";
    private static final Set<String> LOADED = new HashSet<String>();
    private static boolean loaded = false;

    public static void load() {
        if (loaded) {
            return;
        }
        loaded = true;
        try {
            ApplicationProperties.loadProperties(SYSTEM_PROPERTIES_FILENAME, true);
        }
        catch (IOException e) {
            Logger.getLogger(ApplicationProperties.class).error(e);
            System.exit(-1);
        }
    }

    public static void parseArgs(String[] args) {
        assert (args != null);
        boolean readProperty = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (readProperty) {
                int split = arg.indexOf("=");
                if (split != -1) {
                    String property = arg.substring(0, split);
                    String value = arg.substring(split + 1);
                    if (property.length() > 0) {
                        System.setProperty(property, value);
                    }
                }
                readProperty = false;
                continue;
            }
            readProperty = arg.equals("-p");
        }
    }

    private ApplicationProperties() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties(String filename, boolean warnIfNotPresent) throws IOException {
        if (LOADED.contains(filename)) {
            return;
        }
        Logger logger = Logger.getLogger(ApplicationProperties.class);
        File file = new File(ApplicationProperties.getRunDir(), filename);
        if (logger.isDebugEnabled()) {
            logger.debug("Looking for properties file: " + file.getAbsolutePath());
        }
        if (!file.exists()) {
            if (warnIfNotPresent) {
                logger.warn("File '" + file.getAbsolutePath() + "' does not exist");
            }
            return;
        }
        FileInputStream fin = new FileInputStream(file);
        try {
            Properties properties = new Properties();
            properties.load(new BufferedInputStream(fin));
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        finally {
            fin.close();
            LOADED.add(filename);
        }
    }

    private static File getRunDir() {
        return new File(".");
    }

    static {
        ApplicationProperties.load();
    }
}

