/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.AS3Animation;
import com.sodiumarc.patchwork.animation.SplitableAnimation;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.render.control.ImageOutputID;
import com.sodiumarc.patchwork.render.control.RenderControl;
import com.sodiumarc.patchwork.render.control.RenderImage;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class StillImage
extends AS3Animation
implements SplitableAnimation {
    public static String ELEMENT_NAME = "image";
    public static String IMAGE_NAME_ATTR_NAME = "name";
    public static String LAYER_IDS_ATTR_NAME = "layer_ids";
    public static DocumentNodeDecoder<StillImage> DECODER = new DocumentNodeDecoder<StillImage>(){

        @Override
        public StillImage decode(Node node) {
            RenderImage image;
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> properties = XMLUtils.getAttributes(node);
            List<StillImage> childImages = XMLUtils.decodeChildren(node, this);
            String imageName = RenderImage.completeImageName(properties.get(IMAGE_NAME_ATTR_NAME), node);
            String layerIDStr = properties.get(LAYER_IDS_ATTR_NAME);
            List<String> layerIDList = layerIDStr == null ? null : Arrays.asList(layerIDStr.split(","));
            try {
                image = imageName == null ? null : RenderControl.getInstance().getLayerComposite(new ImageOutputID(imageName), layerIDList, null);
            }
            catch (Exception e) {
                Logger.getLogger(StillImage.class).warn("Decode failed: ", e);
                return null;
            }
            return new StillImage(properties, image, childImages);
        }
    };
    private final RenderImage renderedImage;
    private final List<StillImage> childImages;
    private RenderImage compositeRenderedImage;

    public StillImage(String id, RenderImage image, List<StillImage> childImages, long durationInMillis) {
        super(id);
        this.renderedImage = image;
        this.childImages = childImages;
        this.setDurationInMillis(durationInMillis);
    }

    public StillImage(Map<String, String> properties, RenderImage image, List<StillImage> childImages) {
        super(properties);
        this.renderedImage = image;
        this.childImages = childImages;
    }

    public StillImage(String id, RenderImage image, long durationInMillis) {
        this(id, image, new ArrayList<StillImage>(), durationInMillis);
    }

    public StillImage(String id, RenderImage image) {
        this(id, image, new ArrayList<StillImage>(), -1L);
    }

    public RenderImage getRenderedImage() {
        return this.renderedImage;
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        StringTemplate template = templates.getTemplate(this.getClass());
        assert (template != null) : "Missing template: " + this.getClass();
        template.setParameterValueQuoted("ID", this.getID());
        RenderImage actualImage = this.getActualImage();
        String imageVal = actualImage == null ? null : actualImage.getImageFilename();
        template.setParameterValueQuoted("IMAGE_NAME", imageVal);
        template.setParameterValue("DURATION_IN_MILLIS", this.durationAsAS3String());
        return template.getProcessedText();
    }

    @Override
    public Set<RenderImage> getImages(boolean renderableOnly) {
        RenderImage actualImage = this.getActualImage();
        if (actualImage == null || renderableOnly && actualImage.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.singleton(actualImage);
    }

    public String toString() {
        return "StillImage [imageName=" + this.renderedImage + "]";
    }

    @Override
    public List<AS3Animation> splitByLayer(List<String> layerPatterns) {
        ArrayList<AS3Animation> result = new ArrayList<AS3Animation>();
        if (this.childImages.isEmpty() && this.renderedImage != null) {
            List<String> layerIDs = this.renderedImage.getMatchingLayerIDs(layerPatterns);
            for (String layerID : layerIDs) {
                RenderControl renderControl = RenderControl.getInstance();
                RenderImage splitImage = null;
                try {
                    splitImage = renderControl.getLayerImage(this.renderedImage, layerID, RenderControl.DEFAULT_CONDITION);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).warn("Error loading images: ", e);
                }
                String splitID = this.getID() + "_" + layerID;
                result.add(new StillImage(splitID, splitImage));
            }
        }
        return result;
    }

    private RenderImage getActualImage() {
        if (!this.childImages.isEmpty()) {
            if (this.compositeRenderedImage == null) {
                ArrayList<RenderImage> images = new ArrayList<RenderImage>(this.childImages.size() + 1);
                CollectionUtils.addIfNotNull(images, this.renderedImage);
                for (StillImage child : this.childImages) {
                    CollectionUtils.addIfNotNull(images, child.getRenderedImage());
                }
                String compName = "FLAT" + RenderControl.newUniqueIDString();
                this.compositeRenderedImage = RenderControl.getInstance().createComposite(compName, images);
            }
            return this.compositeRenderedImage;
        }
        return this.renderedImage == null ? null : this.renderedImage;
    }
}

