/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.AnimationSequencer;
import com.sodiumarc.patchwork.animation.MultiPropertyKeyframes;
import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3ConversionUtils;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class ScriptedSequencer
extends AnimationSequencer {
    public static String ELAPSED_CYCLES_PROPERTY = "cycles";
    public static String LAYER_INDEX_PROPERTY = "layer";
    static String ELEMENT_NAME = "scripted_seq";
    private final List<MultiPropertyKeyframes> keyframesByAnimIndex = new ArrayList<MultiPropertyKeyframes>();

    public ScriptedSequencer() {
    }

    public ScriptedSequencer(List<MultiPropertyKeyframes> keyframesByAnimIndex) {
        this();
        this.setKeyframesByAnimIndex(keyframesByAnimIndex);
    }

    public void setKeyframesByAnimIndex(List<MultiPropertyKeyframes> keyframesByAnimIndex) {
        this.keyframesByAnimIndex.clear();
        this.keyframesByAnimIndex.addAll(keyframesByAnimIndex);
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        StringTemplate template = templates.getTemplate(ScriptedSequencer.class);
        assert (template != null) : "Missing template: " + ScriptedSequencer.class;
        StringTemplate addKeyframesTemplate = templates.getTemplate(ScriptedSequencer.class, "ADD_KEYFRAMES");
        assert (addKeyframesTemplate != null) : "Missing template: ADD_KEYFRAMES";
        StringBuilder addKeyframes = new StringBuilder();
        int animIndex = 0;
        for (MultiPropertyKeyframes multiKeyframes : this.keyframesByAnimIndex) {
            addKeyframesTemplate.clearParameterValues();
            addKeyframesTemplate.setParameterValue((Object)"ANIM_INDEX", animIndex);
            addKeyframesTemplate.setParameterValue("CYCLES_TIMES", AS3ConversionUtils.toArrayLiteral(multiKeyframes.getKeyframes(ELAPSED_CYCLES_PROPERTY).getTimes()));
            addKeyframesTemplate.setParameterValue("CYCLES_VALUES", AS3ConversionUtils.toArrayLiteral(multiKeyframes.getKeyframes(ELAPSED_CYCLES_PROPERTY).getValues()));
            addKeyframesTemplate.setParameterValue("LAYER_TIMES", AS3ConversionUtils.toArrayLiteral(multiKeyframes.getKeyframes(LAYER_INDEX_PROPERTY).getTimes()));
            addKeyframesTemplate.setParameterValue("LAYER_VALUES", AS3ConversionUtils.toArrayLiteral(multiKeyframes.getKeyframes(LAYER_INDEX_PROPERTY).getValues()));
            addKeyframes.append(addKeyframesTemplate.getProcessedText());
            ++animIndex;
        }
        template.setParameterValue("ADD_KEYFRAMES", addKeyframes.toString());
        return template.getProcessedText();
    }

    public static class Decoder
    implements DocumentNodeDecoder<ScriptedSequencer> {
        @Override
        public ScriptedSequencer decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            List keyframesByAnimIndex = XMLUtils.decodeChildren(node, MultiPropertyKeyframes.getSubclassDecoders());
            return new ScriptedSequencer(keyframesByAnimIndex);
        }
    }
}

