/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.InterpolationFunction;
import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.MathUtils;

public class RampInterpFunction
implements InterpolationFunction {
    private final Range<Float> ramp;

    public static final float getInterpFraction(float inputFraction, float rampStart, float rampEnd) {
        if (inputFraction <= rampStart) {
            return 0.0f;
        }
        if (inputFraction >= rampEnd) {
            return 1.0f;
        }
        return (float)MathUtils.rangeFraction(inputFraction, rampStart, rampEnd);
    }

    public RampInterpFunction(float rampStart, float rampEnd) {
        this.ramp = new Range<Float>(Float.valueOf(rampStart), Float.valueOf(rampEnd));
    }

    @Override
    public float getInterpFraction(float inputFraction) {
        return RampInterpFunction.getInterpFraction(inputFraction, this.ramp.getMin().floatValue(), this.ramp.getMax().floatValue());
    }
}

