/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.AS3Animation;
import com.sodiumarc.patchwork.animation.AlphaFunction;
import com.sodiumarc.patchwork.animation.AnimationSequencer;
import com.sodiumarc.patchwork.animation.MultiPropertyKeyframes;
import com.sodiumarc.patchwork.animation.StillImage;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.render.control.RenderImage;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class CompoundAnimation
extends AS3Animation {
    public static String ELEMENT_NAME = "comp_anim";
    public static DocumentNodeDecoder<CompoundAnimation> DECODER = new DocumentNodeDecoder<CompoundAnimation>(){

        @Override
        public CompoundAnimation decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> properties = XMLUtils.getAttributes(node);
            CompoundAnimation result = new CompoundAnimation(properties);
            result.setComponentAnimations(XMLUtils.decodeChildren(node, AS3Animation.getSubclassDecoders()));
            MultiPropertyKeyframes keyframes = (MultiPropertyKeyframes)CollectionUtils.first(XMLUtils.decodeChildren(node, MultiPropertyKeyframes.getSubclassDecoders()));
            result.setContainerKeyframes(keyframes);
            AlphaFunction alphaFunction = (AlphaFunction)CollectionUtils.first(XMLUtils.decodeChildren(node, AlphaFunction.getSubclassDecoders()));
            result.setAlphaFunction(alphaFunction);
            AnimationSequencer sequencer = (AnimationSequencer)CollectionUtils.first(XMLUtils.decodeChildren(node, AnimationSequencer.getSubclassDecoders()));
            result.setSequencer(sequencer);
            return result;
        }
    };
    private final List<AS3Animation> componentAnimations = new ArrayList<AS3Animation>();
    private final List<MultiPropertyKeyframes> componentKeyframes = new ArrayList<MultiPropertyKeyframes>();
    private MultiPropertyKeyframes containerKeyframes;
    private AnimationSequencer sequencer = null;

    public CompoundAnimation(Map<String, String> properties) {
        super(properties);
    }

    public CompoundAnimation(String id, long durationInMillis) {
        super(id, durationInMillis);
    }

    public CompoundAnimation(String id) {
        this(id, -1L);
    }

    public void setComponentAnimations(List<? extends AS3Animation> componentAnimations) {
        this.componentAnimations.clear();
        this.componentAnimations.addAll(componentAnimations);
        if (this.getID() != null) {
            int childIndex = 0;
            for (AS3Animation animation : this.componentAnimations) {
                if (animation.getID() == null) {
                    animation.setID(this.getID() + "-" + childIndex);
                }
                ++childIndex;
            }
        }
    }

    public void setComponentKeyframes(List<MultiPropertyKeyframes> componentKeyframes) {
        this.componentKeyframes.clear();
        this.componentKeyframes.addAll(componentKeyframes);
    }

    public List<AS3Animation> getComponentAnimations() {
        return this.componentAnimations;
    }

    @Deprecated
    public void setContainerKeyframes(MultiPropertyKeyframes containerKeyframes) {
        this.containerKeyframes = containerKeyframes;
    }

    public void setSequencer(AnimationSequencer sequencer) {
        this.sequencer = sequencer;
    }

    public AS3Animation simplify() {
        AS3Animation animation;
        if (this.componentAnimations.size() == 0) {
            return new StillImage(this.getID(), null, this.getDurationInMillis());
        }
        if (this.containerKeyframes == null && this.getAlphaFunction() == null && this.componentAnimations.size() == 1 && (animation = this.componentAnimations.get(0)).getDurationInMillis() == this.getDurationInMillis()) {
            if (this.getID() != null) {
                if (animation.getID() == null) {
                    animation.setID(this.getID());
                } else {
                    return this;
                }
            }
            return animation;
        }
        return this;
    }

    public final String containerKeyframesAsAS3String(TemplateLibrary templates) throws ParseException {
        return this.containerKeyframes == null ? null : this.containerKeyframes.toAS3String(templates);
    }

    public final String sequencerAsAS3String(TemplateLibrary templates) throws ParseException {
        return this.sequencer == null ? null : this.sequencer.toAS3String(templates);
    }

    @Override
    public Set<RenderImage> getImages(boolean renderableOnly) {
        HashSet<RenderImage> result = new HashSet<RenderImage>();
        for (AS3Animation anim : this.componentAnimations) {
            result.addAll(anim.getImages(renderableOnly));
        }
        return result;
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        AS3Animation simplified = this.simplify();
        if (simplified != this) {
            return simplified.toAS3String(templates);
        }
        StringTemplate template = templates.getTemplate(CompoundAnimation.class);
        assert (template != null) : "Missing template: " + CompoundAnimation.class;
        StringTemplate addToArrayTemplate = templates.getTemplate(AS3Animation.class, "ADD_TO_ARRAY");
        assert (addToArrayTemplate != null) : "Missing template: ADD_TO_ARRAY";
        StringTemplate addChildKeyframesTemplate = templates.getTemplate(CompoundAnimation.class, "ADD_CHILD_KEYFRAMES");
        assert (addChildKeyframesTemplate != null) : "Missing template: ADD_CHILD_KEYFRAMES";
        StringBuilder animDefList = new StringBuilder();
        for (AS3Animation anim : this.getComponentAnimations()) {
            addToArrayTemplate.clearParameterValues();
            addToArrayTemplate.setParameterValue("ANIMATION", anim.toAS3String(templates));
            animDefList.append(addToArrayTemplate.getProcessedText());
        }
        StringBuilder childKeyframesList = new StringBuilder();
        int index = 0;
        for (MultiPropertyKeyframes keyframes : this.componentKeyframes) {
            addChildKeyframesTemplate.clearParameterValues();
            addChildKeyframesTemplate.setParameterValue((Object)"INDEX", index);
            addChildKeyframesTemplate.setParameterValue("KEYFRAMES", keyframes.toAS3String(templates));
            childKeyframesList.append(addChildKeyframesTemplate.getProcessedText());
            ++index;
        }
        template.setParameterValueQuoted("ID", this.getID());
        template.setParameterValue("ANIMATION_LAYERS", animDefList.toString());
        template.setParameterValue("DURATION_IN_MILLIS", this.durationAsAS3String());
        template.setParameterValue("ALPHA_FUNCTION", this.alphaFunctionAsAS3String(templates));
        template.setParameterValue("CONTAINER_KEYFRAMES", this.containerKeyframesAsAS3String(templates));
        template.setParameterValue("CHILD_KEYFRAMES", childKeyframesList.toString());
        template.setParameterValue("SEQUENCER", this.sequencerAsAS3String(templates));
        return template.getProcessedText();
    }
}

