/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.AS3Animation;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.render.control.RenderImage;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class AnimationInstance
extends AS3Animation {
    public static String ELEMENT_NAME = "anim_instance";
    public static String REF_ID_ATTR_NAME = "ref_id";
    public static DocumentNodeDecoder<AnimationInstance> DECODER = new DocumentNodeDecoder<AnimationInstance>(){

        @Override
        public AnimationInstance decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> properties = XMLUtils.getAttributes(node);
            return new AnimationInstance(null, properties.get(REF_ID_ATTR_NAME));
        }
    };
    private final String refID;

    public AnimationInstance(String id, String refID) {
        super(id);
        this.refID = refID;
    }

    @Override
    public Set<RenderImage> getImages(boolean renderableOnly) {
        return Collections.emptySet();
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        StringTemplate template = templates.getTemplate(this.getClass());
        assert (template != null) : "Missing template: " + this.getClass();
        template.setParameterValue("REF_ID", this.refID);
        return template.getProcessedText();
    }
}

