/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.Animation;
import com.sodiumarc.patchwork.animation.AnimationListener;
import com.sodiumarc.patchwork.util.MathUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;

public abstract class AbstractAnimation
implements Animation {
    private final Timer timer = new Timer(40, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractAnimation.this.eachFrame();
        }
    });
    private final List<AnimationListener> listeners = new ArrayList<AnimationListener>();
    private long durationInMillis = 2000L;
    private boolean isLoop = false;
    private long startTime;
    private float elapsedFraction;
    private static final int MILLIS_PER_FRAME = 40;

    @Override
    public void setElapsedFraction(float elapsedFraction) {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.setElapsedFractionImpl(elapsedFraction);
    }

    @Override
    public float getElapsedFraction() {
        return this.elapsedFraction;
    }

    @Override
    public void setDurationInMillis(long durationInMillis) {
        this.durationInMillis = durationInMillis;
    }

    @Override
    public long getDurationInMillis() {
        return this.durationInMillis;
    }

    @Override
    public void setLoop(boolean isLoop) {
        this.isLoop = isLoop;
    }

    @Override
    public boolean isLoop() {
        return this.isLoop;
    }

    @Override
    public void start() {
        this.startTime = System.currentTimeMillis();
        this.timer.start();
        this.fireStarted();
    }

    @Override
    public void stop() {
        this.timer.stop();
        this.fireStopped();
    }

    @Override
    public boolean isRunning() {
        return this.timer.isRunning();
    }

    @Override
    public void addListener(AnimationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(AnimationListener listener) {
        this.listeners.remove(listener);
    }

    protected abstract void elapsedFractionChanged(float var1);

    protected Animation getEventSource() {
        return this;
    }

    protected void animationStarted(Animation source) {
    }

    protected void animationStopped(Animation source) {
    }

    protected void elapsedFractionChanged(Animation source, float elapsedFraction) {
    }

    private void setElapsedFractionImpl(float fraction) {
        this.elapsedFraction = this.toNormalRange(fraction);
        this.elapsedFractionChanged(this.elapsedFraction);
        this.fireElapsedFractionChanged();
    }

    private void eachFrame() {
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        this.setElapsedFractionImpl((float)elapsedTime / (float)this.durationInMillis);
        if (this.elapsedFraction >= 1.0f && this.timer.isRunning() && !this.isLoop) {
            this.stop();
        }
    }

    private float toNormalRange(float elapsedFraction) {
        if (this.isLoop) {
            return elapsedFraction % 1.0f;
        }
        return MathUtils.clamp(elapsedFraction, 0.0f, 1.0f);
    }

    private void fireStarted() {
        this.animationStarted(this.getEventSource());
        for (AnimationListener listener : new ArrayList<AnimationListener>(this.listeners)) {
            listener.animationStarted(this.getEventSource());
        }
    }

    private void fireStopped() {
        this.animationStopped(this.getEventSource());
        for (AnimationListener listener : new ArrayList<AnimationListener>(this.listeners)) {
            listener.animationStopped(this.getEventSource());
        }
    }

    private void fireElapsedFractionChanged() {
        this.elapsedFractionChanged(this.getEventSource(), this.elapsedFraction);
        for (AnimationListener listener : new ArrayList<AnimationListener>(this.listeners)) {
            listener.elapsedFractionChanged(this.getEventSource(), this.elapsedFraction);
        }
    }
}

