-- Mod custom strings

local STRINGS = GLOBAL.STRINGS

-- Interface
STRINGS.UI.LOADGAMESCREEN.UW = "Ocean Depth %d-%d"
STRINGS.UI.LOADGAMESCREEN.UW_SHORT = "Ocean Depth %d"
STRINGS.UI.MAINSCREEN.UW_UPDATENAME = "Explore the Reef (Alpha)"
STRINGS.UI.WORLDGEN.UWTITLE = "Filling the Ocean"
STRINGS.UI.WORLDGEN.UW_VERBS = {
    "Generating",
    "Herding",
    "Soaking",
    "Iterating upon",
    "Insinuating",
    "Reticulating",
    "Pushing",
    "Inserting",
    "Distributing",
    "Empowering",
    "Creating",
    "Spawning",
    "Watering",
    "Messing with",
}
STRINGS.UI.WORLDGEN.UW_NOUNS = {
    "corals",
    "pathos",
    "seagrass",
    "jellyfish",
    "monsters",
    "a keen sense of despair",
    "buckets and buckets of loot",
    "mod functions",
    "clams",
	"shrimp",
    "crabs",
    "Merm villages",
    "sponges",
    "fish",
    "the developers",
    "geothermal vents",
    "bubbles",     
}

-- World objects
STRINGS.NAMES.GEOTHERMAL_VENT = "Geothermal Vent"
STRINGS.NAMES.CRABHOLE = "Mud Hole"
STRINGS.NAMES.UNDERWATER_ENTRANCE_OPEN = "Underwater Entrance"
STRINGS.NAMES.UNDERWATER_ENTRANCE_CLOSED = "Sealed Underwater Entrance"
STRINGS.NAMES.UNDERWATER_ENTRANCE_OPEN_CAVE = "Deeper Underwater Entrance"
STRINGS.NAMES.UNDERWATER_ENTRANCE_CLOSED_CAVE = "Sealed Deeper Underwater Entrance"
STRINGS.NAMES.UNDERWATER_EXIT = "Underwater Exit"
STRINGS.NAMES.MERMNOBLEHOUSE = "Prestigious Merm House"
STRINGS.NAMES.MERMWORKERHOUSE = "Merm House"
STRINGS.NAMES.MERMGUARDHOUSE = "Merm Guardhouse"
STRINGS.NAMES.ROTTING_TRUNK = "Rotting Tree Trunk"
STRINGS.NAMES.SUNKEN_CHEST = "Ancient Sea Chest"
STRINGS.NAMES.SEAGRASS = "Seagrass"
STRINGS.NAMES.DEPLETED_SEAGRASS = "Seagrass"
STRINGS.NAMES.UW_CORAL = "Fire Coral"
STRINGS.NAMES.UW_CORAL_BLUE = "Turquoise Coral"
STRINGS.NAMES.UW_CORAL_GREEN = "Emerald Coral"
STRINGS.NAMES.FLOWER_SEA = "Sea Flower"
STRINGS.NAMES.SANDSTONE_BOULDER = "Sandstone Boulder"
STRINGS.NAMES.IRON_BOULDER = "Iron Ore Vein"
STRINGS.NAMES.SUNKEN_CHEST = "Sea Chest"
STRINGS.NAMES.KELP = "Kelp"
STRINGS.NAMES.WORMPLANT = "Worm Plant"
STRINGS.NAMES.DECORATIVE_SHELL = "Pretty Shell"
STRINGS.NAMES.SPONGE = "Sea Sponge"
STRINGS.NAMES.BUBBLE_VENT = "Bubbling Vent"
STRINGS.NAMES.UW_FLOWERS = "Sea Flowers"


-- Craftable items
STRINGS.NAMES.HAT_DIVING = "Diving Helmet"
STRINGS.RECIPE_DESC.HAT_DIVING = "For aquatic exploration."
STRINGS.NAMES.SNORKEL = "Snorkelling Gear"
STRINGS.RECIPE_DESC.SNORKEL = "Perfect for observing the reef."
STRINGS.NAMES.PEARL_AMULET = "Pearl Amulet"
STRINGS.RECIPE_DESC.PEARL_AMULET = "Converts sea water into fresh air."
STRINGS.NAMES.FLARE = "Flare"
STRINGS.RECIPE_DESC.FLARE = "Illuminate the ocean's depths."
STRINGS.NAMES.DIVING_SUIT_SUMMER = "Wetsuit"
STRINGS.RECIPE_DESC.DIVING_SUIT_SUMMER = "Clothing for dives into the ocean."
STRINGS.NAMES.DIVING_SUIT_WINTER = "Drysuit"
STRINGS.RECIPE_DESC.DIVING_SUIT_WINTER = "Sure to keep you warm while underwater."
STRINGS.NAMES.JELLY_LANTERN = "Jelly O' Lantern'"
STRINGS.RECIPE_DESC.JELLY_LANTERN = "Lasting light for longer dives."
STRINGS.RECIPE_DESC.CORAL_CLUSTER = "When a bouquet of flowers just won't do the trick."
STRINGS.NAMES.CORAL_CLUSTER = "Coral Cluster"


-- Inventory items
STRINGS.NAMES.PEARL = "Mysterious Pearl"
STRINGS.NAMES.CORAL_PIECES = "Coral Fragments"
STRINGS.NAMES.SANDSTONE = "Pile of Sand"
STRINGS.NAMES.IRON_ORE = "Iron Ore"
STRINGS.NAMES.BUBBLE_ITEM = "Bubble"
STRINGS.NAMES.LAVASTONE = "Lavastone"
STRINGS.NAMES.SPONGE_PIECE = "Piece of Sponge"
STRINGS.NAMES.JELLY_CAP = "Jelly Cap"
STRINGS.NAMES.SALT = "Salt"
STRINGS.NAMES.SEA_CUCUMBER = "Sea Cucumber"
STRINGS.NAMES.SEAGRASS_CHUNK = "Chunk of Seagrass"
STRINGS.NAMES.CUT_ORANGE_CORAL = "Precious Fire Coral"
STRINGS.NAMES.CUT_GREEN_CORAL = "Precious Emerald Coral"
STRINGS.NAMES.CUT_BLUE_CORAL = "Precious Turquoise Coral"
STRINGS.NAMES.SEA_PETALS = "Sea Petals"


-- Food
STRINGS.NAMES.FISH_FILLET = "Fish Fillet"
STRINGS.NAMES.FISH_FILLET_COOKED = "Cooked Fish Fillet"
STRINGS.NAMES.FISH_GAZPACHO = "Gazpacho Soup"
STRINGS.NAMES.SPONGE_CAKE = "Sponge Cake"
STRINGS.NAMES.FISH_N_CHIPS = "Fish 'n Chips"
STRINGS.NAMES.TUNA_MUFFIN = "Tuna Muffin"
STRINGS.NAMES.TENTACLE_SUSHI = "Geso Sushi"
STRINGS.NAMES.FLOWER_SUSHI = "Bento Sushi"
STRINGS.NAMES.FISH_SUSHI = "Aji Sushi"
STRINGS.NAMES.SHRIMP_TAIL = "Shrimp Tail"
STRINGS.NAMES.SEAJELLY = "Sea Jelly"


-- Monsters and mobs
STRINGS.NAMES.COMMONFISH = "Sea Bass"
STRINGS.NAMES.REEF_JELLYFISH = "Deep-Sea Jellyfish"
STRINGS.NAMES.SQUID = "Squiddy"
STRINGS.NAMES.CRAB = "Crab"
STRINGS.NAMES.MERMNOBLE = "Gentle-Merm"
STRINGS.NAMES.MERMWORKER = "Merm Labourer"
STRINGS.NAMES.MERMGUARD = "Merm Guard"
STRINGS.NAMES.SEATENTACLE = "Sea Tentacle"
STRINGS.NAMES.SEAQUAKETENTACLE = "Tentacle of the Kraken"
STRINGS.NAMES.CLAM = "Giant Clam"
STRINGS.NAMES.SEA_EEL = "Giant Eel"
STRINGS.NAMES.SHRIMP = "Shrimpet"


-- Names
STRINGS.MERMNAMES = {MERM_NOBLE = {}, MERM_WORKER = {}}
STRINGS.MERMNAMES.MERM_NOBLE[1] = 
{
	"Lampwick",
	"Warren",
	"William",
	"Rudderford",
}
STRINGS.MERMNAMES.MERM_NOBLE[2] = 
{
	"Helena",
	"Priscilla",
	"Elizabeth",
	"Evelyn",
}
STRINGS.MERMNAMES.MERM_WORKER[1] = 
{
	"Frank",
	"Boris",
	"Bill",
	"Joe",
}
STRINGS.MERMNAMES.MERM_WORKER[2] = 
{
	"Maggie",
	"Leslie",
	"Beth",
	"Freda",
}

-- Merm strings
STRINGS.MERM_TALK_HELP_CHOP_WOOD = 
{
	MERM_NOBLE = {"Physical toil is best suited to others, I think.", "Sorry ol' thing, but my back you see...", "Good swing you have there.", "Don't worry, I'll wait."},
	MERM_WORKER = {"Alright, let's get to it.", "Lunch'll be afterwards, right?", "It won't know what hit it!", "I'll get that down in a jiffy."},
	MERM_GUARD = {"'Fraid that's outside my pay grade.", "I'll wait here.", "", ""},
}
STRINGS.MERM_TALK_FOLLOWWILSON =
{
	MERM_NOBLE = {"Lovely day.", "Will there be tea sometime soon?", "Smashing!", "I do enjoy a good walk after lunch."},
	MERM_WORKER = {"I'm being paid by the hour, right?", "'Fraid I can't do overtime.", "Are you a union member?", "What's the next job?"},
	MERM_GUARD = {"", "", "", ""},
}
STRINGS.MERM_TALK_RUNAWAY_WILSON =
{
	MERM_NOBLE = {"Do you mind?", "Little too close there, ol' thing.", "Don't you know anything about personal space?", "Off with you!"},
	MERM_WORKER = {"Hey, what's your problem?", "I don't think so...", "Not pickin' my pocket are you?", "Clear off!"},
	MERM_GUARD = {"Move along!", "Stay clear of defence personnel at all times.", "I'll have my eye on you.", "Back off you!"},
}
STRINGS.MERM_TALK_LOOKATWILSON =
{
	MERM_NOBLE = {"", "", "", ""},
	MERM_WORKER = {"", "", "", ""},
	MERM_GUARD = {"", "", "", ""},
}
STRINGS.MERM_TALK_PANICFIRE =
{
	MERM_NOBLE = {"I'm burning up!", "Someone put it out! PUT IT OUT!", "AHH! AHH! FIIIIREE!"},
	MERM_WORKER = {"I'm burning up!", "Someone put it out! PUT IT OUT!", "AHH! AHH! FIIIIREE!"},
	MERM_GUARD = {"I'm burning up!", "Someone put it out! PUT IT OUT!", "AHH! AHH! FIIIIREE!"},
}
STRINGS.MERM_TALK_FIGHT =
{
	MERM_NOBLE = {"Tally-ho!", "Guards! GUUUAAARRDDSSS!", "Thief! Murderer! Vagrant!", "Your mother was a hamster, and your father smelt of elderberries!"},
	MERM_WORKER = {"Clear out you!", "I'll clean your clock!", "Let's get 'em!", "Come and fight, you pansy!"},
	MERM_GUARD = {"Out of here, you scoundrel!", "Tally-ho!", "I'll give you a good seeing too, ruffian!", "Halt! You're under arrest!"},
}
STRINGS.MERM_TALK_ATTEMPT_TRADE =
{
	MERM_NOBLE = {"A gift?", "Yes?"},
	MERM_WORKER = {"What's this then?", "Need a hired hand?"},
	MERM_GUARD = {"You have something for me?", "Bribery is a crime, ya-know."},
}
STRINGS.MERM_TALK_GO_HOME =
{
	MERM_NOBLE = {"Time to retire.", "Brilliant day that!", "Time for a nightcap.", "Must be off!"},
	MERM_WORKER = {"Time to knock off!", "Home time!", "At last!", "What's for supper?"},
	MERM_GUARD = {"Better get some shut eye.", "Thought that shift would never end.", "Me legs are all stiff!", "I'm getting too old for this."},
}

