--[[
Likes high number of brush strokes & high color complexity
Hates brush time

score fields:
    float originality;
    float colorComplexity;
    float brushLength;
    float brushTime;
    int brushStrokes;
    int truePrice;
    int price;
    string name;
--]]

buyDialogue = {
	"The artist has really worked his paint into the grain of the canvas.",
	"The strokes are plentyful and precise. Most admirable!",
	"Excellent craftsmanship!"
}

tooFewStrokesDialogue = {
	"I have little regard for such minimalism!",
	"I find the effort put into it lacking.",
	"More effort, please, this is poor! Yuck!"
}

notComplexEnoughDialogue = {
	"Hmm, the strokes are plentyful, but it adds nothing to the complexity.",
	"This is just... bland. Where's the action!? The excitement!?",
	"Very uninspiring. More complexity please!"
}

-- Overpriced (over marginal)
overPricedDialogue = {
	"Oh my. Seems overpriced.",
	"The artist obviously doesn't understand pricing.",
	"I scoff at this overpricing."
}

brushStrokes = 0
colorComplexity = 0
budget = 0
function initialize()
    brushStrokes = random.range(10, 20)
    colorComplexity = random.range(0.4, 0.6)
    budget = random.range(50, 100)
margin = 10
end



function getRandomLine(dialogueTable)
	return dialogueTable[random.intrange(1, #dialogueTable+1)]
end

function evaluatePainting(score)
	local res = {}
	res["buying"] = false
	res["dialogue"] = "fee fi fum"
	if score.brushStrokes >= brushStrokes and score.colorComplexity >= colorComplexity and score.price - score.truePrice <= margin then
		res["buying"] = true
		res["dialogue"] = getRandomLine(buyDialogue)
	elseif score.brushStrokes < brushStrokes then
		res["dialogue"] = getRandomLine(tooFewStrokesDialogue)
	elseif(score.colorComplexity < colorComplexity) then
		res["dialogue"] = getRandomLine(notComplexEnoughDialogue)
	elseif score.price - score.truePrice > margin then
		res["dialogue"] = getRandomLine(overPricedDialogue)
	end
	
    return res
end

--[[
Like a 50 year old "beer conniseur"
TBA dialogue:
- The artist has really worked his paint into the grain of the canvas. Excellent craftsmanship!
- The strokes are plentyful and precise. Most admirable!

- Sure there's a lot of detail in this, but I find the amount of strokes put into it lacking.
- Hmm, the strokes are plentyful, but it doesn't mean much when it adds nothing to the 
	complexity of the painting

--]]
