﻿--[[
score fields:
   float originality;
   float colorComplexity;
   float brushLength;
   float brushTime;
   int brushStrokes;
   int truePrice;
   int price;
   string name;
--]]

buyDialogue = {
	"A perfect ornament for my lair",
	"This is guaranteed to win me favour with the females.",
	"Another piece to my man cave!"
}

unoriginalDialogue = {
	"I want originality!",
	"No no no! This is not unique!",
	"Uninspiring!",
	"Dissapointed!"
}
--Korta penseldrag, överarbetat
shortBrushLength = {
	"Was probably better before it got overworked",
	"Seems like too much brush flicking!",
	"I want calmer paintings!"
}

-- Overpriced (over marginal)
overPricedDialogue = {
	"Geez. This is overpriced!",
	"Expensive!",
	"It's hardly worth this much."
}

function initialize()
   minOriginality = random.range(0.3, 0.5)
   minBrushLength = random.range(0.2, 0.6)
   margin = 10
end



function getRandomLine(dialogueTable)
	return dialogueTable[random.intrange(1, #dialogueTable+1)]
end

function evaluatePainting(score)
	local res = {}
	res["buying"] = false
	res["dialogue"] = "Default Comment"
	if(minOriginality <= score.originality and minBrushLength <= score.brushLength and score.price - score.truePrice <= margin) then
		res["dialogue"] = getRandomLine(buyDialogue)
		res["buying"] = true
	elseif minOriginality > score.originality then
		res["dialogue"] = getRandomLine(unoriginalDialogue)
	elseif minBrushLength > score.brushLength then
		res["dialogue"] = getRandomLine(shortBrushLength)
	elseif score.price - score.truePrice > margin then
		res["dialogue"] = getRandomLine(overPricedDialogue)
	end
   return res
end

--[[


- Can't see without my glaaaaassess.
- I predict a 95% percent chance this will suit my lair.
- This is guaranteed to win me favour with the females of this species.

- I wish I hadn't seen this with my glasses on.
- 
--]]