--[[
score fields:
	float originality;
	float colorComplexity;
	float brushLength;
	float brushTime;
	int brushStrokes;
	int truePrice;
	int price;
	string name;
--]]

buyDialogue = {
	"Excecuted with great stratégie!",
	"Magnifique!",
	"Marvelous!",
	"Génial!"
}

shortBrushLength = {
	"I hate this one.",
	"Seems too jagged to moi.",
	"Not enough follow through!",
	"I hate the way the strokes are made!"
}
-- Dragen tog kort tid
shortBrushTime = {
	"Far too hastily done!", 
	"It's made too rapide!",
	"This is hasted. Yuck!"
}
-- Overpriced (over marginal)
overPricedDialogue = {
	"Oh oh. Seems overpriced to moi.",
	"The artist obviously doesn't comprendre pricing.",
	"I scoff at this overpricing."
}

function initialize()
	minBrushLength = random.range(0.5, 0.7)
	minBrushTime = random.range(0.4, 0.6)
	maxPrice = random.intrange(40, 60)
margin = 10
end

function getRandomLine(dialogueTable)
	return dialogueTable[random.intrange(1, #dialogueTable+1)]
end

function evaluatePainting(score)
	local res = {}
	res["buying"] = false
	res["dialogue"] = "Default Comment"
	if(score.brushLength >= minBrushLength and score.brushTime >= minBrushTime and score.price - score.truePrice <= margin) then
		res["buying"] = true;
		res["dialogue"] = getRandomLine(buyDialogue)
	elseif (score.brushLength < minBrushLength) then
		res["dialogue"] = getRandomLine(shortBrushLength)
	elseif (score.brushTime < minBrushTime) then
		res["dialogue"] = getRandomLine(shortBrushTime)
	elseif (score.price - score.truePrice > margin) then
		res["dialogue"] = getRandomLine(overPricedDialogue)
	end
	
	return res
end
