--[[
score fields:
	float originality;
	float colorComplexity;
	float brushLength;
	float brushTime;
	int brushStrokes;
	int truePrice;
	int price;
	string name;
--]]

buyDialogue = {
	"New, exciting and just within my price range!",
	"Woah! Fresh!",
	"Original! I love it!"
}
--  för lik tavlor du redan gjort
unoriginal = {
	"I think I already have one of these.",
	"Is this a copy of something?",
	"Originality, please!",
	"Disappointed!"
}
-- för dyr (utanför marginalen)
overPricedDialogue = {
	"Heyo! Pricetag out of control!",
	"Calm down with the overpricing, man!",
	"This is uniquely overpriced"
}

function initialize()
	minOriginality = 0.5
	margin = 20
end

function getRandomLine(dialogueTable)
	return dialogueTable[random.intrange(1, #dialogueTable+1)]
end

function evaluatePainting(score)
	local res = {}
	res["buying"] = false
	res["dialogue"] = "Default Comment"
	if(score.originality >= minOriginality and score.price - score.truePrice <= margin) then
		res["buying"] = true;
		res["dialogue"] = getRandomLine(buyDialogue)
	elseif(score.originality < minOriginality) then
		res["dialogue"] = getRandomLine(unoriginal)
	elseif (score.price - score.truePrice > margin) then
		res["dialogue"] = getRandomLine(overPricedDialogue)
	end
	
	return res
end
