--[[
Likes low colorComplexty & low originality
score fields:
   float originality;
   float colorComplexity;
   float brushLength;
   float brushTime;
   int brushStrokes;
   int truePrice;
   int price;
   string name;
--]]
buyDialogue = {
	"I love simple art!",
	"Such simplicity! I'll take it!",
	"Holy daffodils! I must have this!",
	"Wonderful!"
}

-- för originell (olik andra tavlor du gjort)
tooOriginalDialogue = {
	"This is too original for me!",
	"This is too unique! I hate it!",
	"Too daring of a piece for me!"
}

-- för hög färgkomplexitet (För många små färgöar, alltså komplext)
tooComplexDialogue = {
	"I don't like this much detail!",
	"Too much going on here, yuck!",
	"This is way too complex for my taste!",
	"I despise this!"
}

-- För dyrt pris (utanför marginalen)
overPricedDialogue = {
	"I'm afraid there can only be one diva in my heart."
}

function initialize()
   maxOriginality = 0.3
   maxColorComplexity = 0.5
   margin = 5
end




function getRandomLine(dialogueTable)
	return dialogueTable[random.intrange(1, #dialogueTable+1)]
end

function evaluatePainting(score)
	local res = {}
	res["buying"] = false
	res["dialogue"] = "Default Comment"
	if(score.originality <= maxOriginality and score.colorComplexity <= maxColorComplexity and score.price - score.truePrice <= margin) then
		-- Going to buy
		res["buying"] = true
		res["dialogue"] = getRandomLine(buyDialogue)
	elseif(score.originality > maxOriginality) then
		-- Too original
		res["dialogue"] = getRandomLine(tooOriginalDialogue)
	elseif(score.colorComplexity > maxColorComplexity) then
		-- Too complex
		res["dialogue"] = getRandomLine(tooComplexDialogue)
	elseif(score.price - score.truePrice > margin) then
		res["dialogue"] = getRandomLine(overPricedDialogue)
	end
	return res
end



--[[
Friendly botanist
TBA Dialogue:
- This will fit nicely with my begonias!
- Such simplicity will perfectly complement my dazzling bouqets!

- Why this is far too daring. I can't have this competing with the radiant beauty of my tulips.
- This painting is a sunflower in its own right. There can only be one rose in my abode.
--]]