--[[
Only really cares about price.
score fields:
   float originality;
   float colorComplexity;
   float brushLength;
   float brushTime;
   int brushStrokes;
   int truePrice;
   int price;
   string name;
--]]
buyDialogue = {
	"A perfect cheap canvas for my own artwork!",
	"This isn't crap and it's cheap. Right down my alley!",
	"Another painting from a delusional artist to my collection!",
	"Unknown art is the best and only art."
}
-- brushStrokes för lite (antal)
tooFewStrokesDialogue = {
	"Seems to me not much effort went into this painting...",
	"If only my marriage took as little effort as this painting.",
	"Is this even art?",
	"This doesn't even cut it as refrigerator art.",
	"Even my three year old puts more effort into his drawings."
}
-- För dyrt pris (utanför marginalen)
overPricedDialogue = {
	"Overpriced like my wife's wedding ring, no buy!",
	"This price is too damn high!",
	"I think this is too overpriced!",
	"Price tag is too high!"
}

function initialize()
	-- random.range(0, 3.5)
	margin = 0
	brushStrokesMin = 5
   
end



function getRandomLine(dialogueTable)
	return dialogueTable[random.intrange(1, #dialogueTable+1)]
end


function evaluatePainting(score)
	local res = {}
	res["buying"] = false
	res["dialogue"] = "Default Comment"
	if(score.brushStrokes <= brushStrokesMin and score.price - score.truePrice <= margin) then
		-- Buys painting
		res["buying"] = true
		res["dialogue"] = getRandomLine(buyDialogue)
	elseif(score.brushStrokes > brushStrokesMin) then
		-- Not enough brush strokes
		res["dialogue"] = getRandomLine(tooFewStrokesDialogue)
	elseif(score.price - score.truePrice > margin) then
		-- Price too high
		res["dialogue"] = getRandomLine(overPricedDialogue)
	end
	return res
end

--[[
TBA Dialogue:
- I guess this will do for the... kitchen, was it?
- Score! Now to just remove the price tag so she won't notice I took the cheapest available.
- Hm, I suppose this could pass for something expensive.


- Why am I the one who have to go buy this crap? I guess if she goes she'll ruin us by bringing
	something as expensive as this.
- How on earth do people afford these things?
- This much for some paint on a piece of cloth!? This is ridiculous!

--]]