title: I18n 国际化
---

为了方便开发多语言应用，框架内置了国际化（I18n）支持，由 [egg-i18n](https://github.com/eggjs/egg-i18n) 插件提供。

## 默认语言

默认语言是 `en-US`。假设我们想修改默认语言为简体中文：

```js
// config/config.default.js
exports.i18n = {
  defaultLocale: 'zh-CN',
};
```

## 切换语言

我们可以通过下面几种方式修改应用的当前语言（修改后会记录到 `locale` 这个 Cookie），下次请求直接用设定好的语言。

优先级从高到低：

1. query: `/?locale=en-US`
2. cookie: `locale=zh-TW`
3. header: `Accept-Language: zh-CN,zh;q=0.5`

如果想修改 query 或者 Cookie 参数名称：

```js
// config/config.default.js
exports.i18n = {
  queryField: 'locale',
  cookieField: 'locale',
  // Cookie 默认一年后过期， 如果设置为 Number，则单位为 ms
  cookieMaxAge: '1y',
};
```

## 编写 I18n 多语言文件

多种语言的配置是独立的，统一存放在 `config/locales/*.js` 下。

```
- config/locales/
  - en-US.js
  - zh-CN.js
  - zh-TW.js
```

不仅对于应用目录生效，在框架，插件的 `config/locales` 目录下同样生效。

__注意单词拼写，是 locales 不是 locals。__

例如：

```js
// config/locales/zh-CN.js
module.exports = {
  Email: '邮箱',
};
```

或者也可以用 JSON 格式的文件：

```json
// config/locales/zh-CN.json
{
  "Email": "邮箱"
}
```

## 获取多语言文本

我们可以使用 `__` (Alias: `gettext`) 函数获取 locales 文件夹下面的多语言文本。

__注意: `__` 是两个下划线__

以上面配置过的多语言为例：

```js
ctx.__('Email')
// zh-CN => 邮箱
// en-US => Email
```

如果文本中含有 `%s`，`%j` 等 format 函数，可以按照 [`util.format()`](https://nodejs.org/api/util.html#util_util_format_format_args) 类似的方式调用：

```js
// config/locales/zh-CN.js
module.exports = {
  'Welcome back, %s!': '欢迎回来，%s!',
};

ctx.__('Welcome back, %s!', 'Shawn');
// zh-CN => 欢迎回来，Shawn!
// en-US => Welcome back, Shawn!
```

同时支持数组下标占位符方式，例如：

```js
// config/locales/zh-CN.js
module.exports = {
  'Hello {0}! My name is {1}.': '你好 {0}! 我的名字叫 {1}。',
};

ctx.__('Hello {0}! My name is {1}.', ['foo', 'bar'])
// zh-CN => 你好 foo！我的名字叫 bar。
// en-US => Hello foo! My name is bar.
```

### Controller 中使用

```js
module.exports = function* (ctx) {
  ctx.body = {
    message: ctx.__('Welcome back, %s!', ctx.user.name)
    // 或者使用 gettext，gettext 是 __ 函数的 alias
    // message: ctx.gettext('Welcome back', ctx.user.name)
    user: ctx.user,
  };
};
```

### View 中使用

假设我们使用的模板引擎是 [Nunjucks](https://github.com/eggjs/egg-view-nunjucks)

```html
<li>{{ __('Email') }}: {{ user.email }}</li>
<li>
  {{ __('Welcome back, %s!', user.name) }}
</li>
<li>
  {{ __('Hello {0}! My name is {1}.', ['foo', 'bar']) }}
</li>
```
