/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.agent;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import sun.tools.agent.AbsentInformationException;
import sun.tools.agent.Agent;
import sun.tools.agent.CachedField;
import sun.tools.agent.CachedMethod;
import sun.tools.agent.Handler;
import sun.tools.agent.Location;

class CachedClass {
    final Class realClass;
    private Hashtable methodCache;
    private Hashtable fieldCache;
    private static Hashtable classCache;

    private static native String getSourceFileName(Class var0) throws AbsentInformationException;

    private static native int[] getLineNumbers(Class var0) throws AbsentInformationException;

    private static native long[] getMethodIDs(Class var0) throws AbsentInformationException;

    private static native long[] getFieldIDs(Class var0) throws AbsentInformationException;

    private CachedClass(Class clazz) {
        this.realClass = clazz;
        this.methodCache = null;
        this.fieldCache = null;
    }

    Class getRealClass() {
        return this.realClass;
    }

    private Hashtable methodCache() {
        if (this.methodCache == null) {
            this.methodCache = new Hashtable();
        }
        return this.methodCache;
    }

    CachedMethod findMethod(long l) {
        return (CachedMethod)this.methodCache().get(new Long(l));
    }

    void cacheMethod(long l, CachedMethod cachedMethod) {
        this.methodCache().put(new Long(l), cachedMethod);
    }

    private Hashtable fieldCache() {
        if (this.fieldCache == null) {
            this.fieldCache = new Hashtable();
        }
        return this.fieldCache;
    }

    CachedField findField(long l) {
        return (CachedField)this.fieldCache().get(new Long(l));
    }

    void cacheField(long l, CachedField cachedField) {
        this.fieldCache().put(new Long(l), cachedField);
    }

    private static Hashtable classCache() {
        if (classCache == null) {
            classCache = new Hashtable();
        }
        return classCache;
    }

    String getName() {
        return this.realClass.getName();
    }

    String getSourceFileName() throws AbsentInformationException {
        return CachedClass.getSourceFileName(this.realClass);
    }

    Location lineToLocation(int n) throws AbsentInformationException {
        CachedMethod[] cachedMethodArray = this.getMethods();
        Location location = null;
        int n2 = 0;
        while (n2 < cachedMethodArray.length && location == null) {
            location = cachedMethodArray[n2].lineToLocation(n);
            ++n2;
        }
        return location;
    }

    int[] getLinenumbers() throws AbsentInformationException {
        CachedMethod[] cachedMethodArray = this.getMethods();
        int n = 0;
        int n2 = 0;
        while (n2 < cachedMethodArray.length) {
            n += cachedMethodArray[n2].getLinenumberCount();
            ++n2;
        }
        int[] nArray = new int[n];
        if (n == 0) {
            return nArray;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < cachedMethodArray.length) {
            int[] nArray2 = cachedMethodArray[n4].getLinenumbers();
            System.arraycopy(nArray2, 0, nArray, n3, nArray2.length);
            n3 += nArray2.length;
            ++n4;
        }
        Arrays.sort(nArray);
        int n5 = nArray[0];
        int n6 = 1;
        while (n6 < n) {
            int n7 = nArray[n6];
            if (n5 == n7) {
                int n8 = n6++;
                while (n6 < n) {
                    n7 = nArray[n6];
                    if (n5 != n7) {
                        nArray[n8++] = n7;
                        n5 = n7;
                    }
                    ++n6;
                }
                int[] nArray3 = new int[n8];
                System.arraycopy(nArray, 0, nArray3, 0, n8);
                return nArray3;
            }
            n5 = n7;
            ++n6;
        }
        return nArray;
    }

    CachedMethod[] getMethods() throws AbsentInformationException {
        long[] lArray = CachedClass.getMethodIDs(this.realClass);
        int n = lArray.length;
        CachedMethod[] cachedMethodArray = new CachedMethod[n];
        int n2 = 0;
        while (n2 < n) {
            cachedMethodArray[n2] = this.getMethod(lArray[n2]);
            ++n2;
        }
        return cachedMethodArray;
    }

    CachedField[] getFields() throws AbsentInformationException {
        long[] lArray = CachedClass.getFieldIDs(this.realClass);
        int n = lArray.length;
        CachedField[] cachedFieldArray = new CachedField[n];
        int n2 = 0;
        while (n2 < n) {
            cachedFieldArray[n2] = this.getField(lArray[n2]);
            ++n2;
        }
        return cachedFieldArray;
    }

    CachedClass getSuperclass() {
        Class clazz = this.realClass.getSuperclass();
        if (clazz == null) {
            return null;
        }
        return CachedClass.getCachedClass(clazz);
    }

    static CachedClass getCachedClass(String string) throws ClassNotFoundException {
        return CachedClass.getCachedClass(Class.forName(string, true, Agent.getAppLoader()));
    }

    static CachedClass getCachedClass(Class clazz) {
        CachedClass cachedClass = (CachedClass)CachedClass.classCache().get(clazz);
        if (cachedClass == null) {
            cachedClass = new CachedClass(clazz);
            classCache.put(clazz, cachedClass);
        }
        return cachedClass;
    }

    static CachedClass findCachedClass(Class clazz) {
        return (CachedClass)CachedClass.classCache().get(clazz);
    }

    static void freeAllBut(Set set) {
        classCache.clear();
        Handler.the_event.clearCache();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            CachedClass cachedClass = (CachedClass)iterator.next();
            classCache.put(cachedClass.getRealClass(), cachedClass);
        }
    }

    CachedMethod getMethod(long l) {
        return CachedMethod.getMethod(this, l);
    }

    CachedMethod getMethod(String string, String string2) {
        return CachedMethod.getMethod(this, string, string2);
    }

    CachedField getField(String string, String string2) {
        return CachedField.getField(this, string, string2);
    }

    CachedField getField(long l) {
        return CachedField.getField(this, l);
    }

    public String toString() {
        return this.getName();
    }
}

