/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.io;

import com.sun.corba.se.internal.io.FVDCodeBaseImpl;
import com.sun.corba.se.internal.io.IIOPInputStream;
import com.sun.corba.se.internal.io.IIOPOutputStream;
import com.sun.corba.se.internal.io.LibraryManager;
import com.sun.corba.se.internal.io.ObjectStreamClass;
import com.sun.corba.se.internal.io.ObjectStreamClassCorbaExt;
import com.sun.corba.se.internal.util.RepositoryId;
import com.sun.corba.se.internal.util.Utility;
import com.sun.org.omg.SendingContext.CodeBase;
import com.sun.org.omg.SendingContext.CodeBaseHelper;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.SendingContext.RunTime;

public class ValueHandlerImpl
implements ValueHandler {
    public static final short kRemoteType = 0;
    public static final short kAbstractType = 1;
    public static final short kValueType = 2;
    private Hashtable inputStreamPairs = null;
    private Hashtable outputStreamPairs = null;
    private CodeBase codeBase = null;
    private static boolean libraryManagerLoaded = false;
    private boolean useHashtables = true;
    private boolean isInputStream = true;
    private IIOPOutputStream outputStreamBridge = null;
    private IIOPInputStream inputStreamBridge = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$org$omg$CORBA$Object;

    public ValueHandlerImpl() {
        if (!libraryManagerLoaded) {
            LibraryManager.load();
            libraryManagerLoaded = true;
        }
    }

    public ValueHandlerImpl(boolean bl) {
        this();
        this.useHashtables = false;
        this.isInputStream = bl;
    }

    public void writeValue(org.omg.CORBA.portable.OutputStream outputStream, Serializable serializable) {
        block9: {
            OutputStream outputStream2 = (OutputStream)outputStream;
            if (!this.useHashtables) {
                if (this.outputStreamBridge == null) {
                    this.outputStreamBridge = this.createOutputStream();
                    this.outputStreamBridge.setOrbStream(outputStream2);
                }
                try {
                    this.outputStreamBridge.increaseRecursionDepth();
                    this.writeValueInternal(this.outputStreamBridge, outputStream2, serializable);
                    Object var5_4 = null;
                    this.outputStreamBridge.decreaseRecursionDepth();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.outputStreamBridge.decreaseRecursionDepth();
                    throw throwable;
                }
                return;
            }
            IIOPOutputStream iIOPOutputStream = null;
            if (this.outputStreamPairs == null) {
                this.outputStreamPairs = new Hashtable();
            }
            if ((iIOPOutputStream = (IIOPOutputStream)this.outputStreamPairs.get(outputStream)) == null) {
                iIOPOutputStream = this.createOutputStream();
                iIOPOutputStream.setOrbStream(outputStream2);
                this.outputStreamPairs.put(outputStream, iIOPOutputStream);
            }
            try {
                iIOPOutputStream.increaseRecursionDepth();
                this.writeValueInternal(iIOPOutputStream, outputStream2, serializable);
                Object var7_8 = null;
                if (iIOPOutputStream.decreaseRecursionDepth() != 0) break block9;
                this.outputStreamPairs.remove(outputStream);
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (iIOPOutputStream.decreaseRecursionDepth() == 0) {
                    this.outputStreamPairs.remove(outputStream);
                }
                throw throwable;
            }
            {
            }
        }
    }

    private void writeValueInternal(IIOPOutputStream iIOPOutputStream, OutputStream outputStream, Serializable serializable) {
        Class clazz = serializable.getClass();
        if (clazz.isArray()) {
            this.write_Array(outputStream, serializable, clazz.getComponentType());
        } else {
            iIOPOutputStream.simpleWriteObject(serializable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Serializable readValue(org.omg.CORBA.portable.InputStream inputStream, int n, Class clazz, String string, RunTime runTime) {
        CodeBase codeBase = CodeBaseHelper.narrow(runTime);
        InputStream inputStream2 = (InputStream)inputStream;
        if (!this.useHashtables) {
            if (this.inputStreamBridge == null) {
                this.inputStreamBridge = this.createInputStream();
                this.inputStreamBridge.setOrbStream(inputStream2);
                this.inputStreamBridge.setSender(codeBase);
                this.inputStreamBridge.setValueHandler(this);
            }
            Serializable serializable = null;
            try {
                this.inputStreamBridge.increaseRecursionDepth();
                serializable = this.readValueInternal(this.inputStreamBridge, inputStream2, n, clazz, string, codeBase);
                Object var10_10 = null;
                if (this.inputStreamBridge.decreaseRecursionDepth() != 0) return serializable;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (this.inputStreamBridge.decreaseRecursionDepth() != 0) throw throwable;
                throw throwable;
            }
            return serializable;
        }
        IIOPInputStream iIOPInputStream = null;
        if (this.inputStreamPairs == null) {
            this.inputStreamPairs = new Hashtable();
        }
        if ((iIOPInputStream = (IIOPInputStream)this.inputStreamPairs.get(inputStream)) == null) {
            iIOPInputStream = this.createInputStream();
            iIOPInputStream.setOrbStream(inputStream2);
            iIOPInputStream.setSender(codeBase);
            iIOPInputStream.setValueHandler(this);
            this.inputStreamPairs.put(inputStream, iIOPInputStream);
        }
        Serializable serializable = null;
        try {
            iIOPInputStream.increaseRecursionDepth();
            serializable = this.readValueInternal(iIOPInputStream, inputStream2, n, clazz, string, codeBase);
            Object var12_14 = null;
            if (iIOPInputStream.decreaseRecursionDepth() != 0) return serializable;
            this.inputStreamPairs.remove(inputStream);
            return serializable;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (iIOPInputStream.decreaseRecursionDepth() != 0) throw throwable;
            this.inputStreamPairs.remove(inputStream);
            throw throwable;
        }
    }

    private Serializable readValueInternal(IIOPInputStream iIOPInputStream, InputStream inputStream, int n, Class clazz, String string, CodeBase codeBase) {
        Serializable serializable = null;
        if (clazz == null) {
            if (this.isArray(string)) {
                this.read_Array(iIOPInputStream, inputStream, null, codeBase, n);
            } else {
                iIOPInputStream.simpleSkipObject(string, codeBase);
            }
            return serializable;
        }
        serializable = clazz.isArray() ? (Serializable)this.read_Array(iIOPInputStream, inputStream, clazz, codeBase, n) : (Serializable)iIOPInputStream.simpleReadObject(clazz, string, codeBase, n);
        if (serializable != null) {
            // empty if block
        }
        return serializable;
    }

    public String getRMIRepositoryID(Class clazz) {
        return RepositoryId.createForJavaType(clazz);
    }

    public boolean isCustomMarshaled(Class clazz) {
        return ObjectStreamClass.lookup(clazz).isCustomMarshaled();
    }

    public RunTime getRunTimeCodeBase() {
        if (this.codeBase != null) {
            return this.codeBase;
        }
        this.codeBase = new FVDCodeBaseImpl();
        FVDCodeBaseImpl fVDCodeBaseImpl = (FVDCodeBaseImpl)this.codeBase;
        fVDCodeBaseImpl.setValueHandler(this);
        return this.codeBase;
    }

    public boolean useFullValueDescription(Class clazz, String string) throws IOException {
        return RepositoryId.useFullValueDescription(clazz, string);
    }

    public String getClassName(String string) {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getClassName();
    }

    public Class getClassFromType(String string) throws ClassNotFoundException {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getClassFromType();
    }

    public Class getAnyClassFromType(String string) throws ClassNotFoundException {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getAnyClassFromType();
    }

    public String createForAnyType(Class clazz) {
        return RepositoryId.createForAnyType(clazz);
    }

    public String getDefinedInId(String string) {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getDefinedInId();
    }

    public String getUnqualifiedName(String string) {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getUnqualifiedName();
    }

    public String getSerialVersionUID(String string) {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getSerialVersionUID();
    }

    public boolean isAbstractBase(Class clazz) {
        return RepositoryId.isAbstractBase(clazz);
    }

    public boolean isSequence(String string) {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.isSequence();
    }

    public Serializable writeReplace(Serializable serializable) {
        return ObjectStreamClass.lookup(serializable.getClass()).writeReplace(serializable);
    }

    protected void writeCharArray(OutputStream outputStream, char[] cArray, int n, int n2) {
        outputStream.write_wchar_array(cArray, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void write_Array(OutputStream outputStream, Serializable serializable, Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                int[] nArray = (int[])serializable;
                int n = nArray.length;
                outputStream.write_ulong(n);
                outputStream.write_long_array(nArray, 0, n);
                return;
            } else if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])serializable;
                int n = byArray.length;
                outputStream.write_ulong(n);
                outputStream.write_octet_array(byArray, 0, n);
                return;
            } else if (clazz == Long.TYPE) {
                long[] lArray = (long[])serializable;
                int n = lArray.length;
                outputStream.write_ulong(n);
                outputStream.write_longlong_array(lArray, 0, n);
                return;
            } else if (clazz == Float.TYPE) {
                float[] fArray = (float[])serializable;
                int n = fArray.length;
                outputStream.write_ulong(n);
                outputStream.write_float_array(fArray, 0, n);
                return;
            } else if (clazz == Double.TYPE) {
                double[] dArray = (double[])serializable;
                int n = dArray.length;
                outputStream.write_ulong(n);
                outputStream.write_double_array(dArray, 0, n);
                return;
            } else if (clazz == Short.TYPE) {
                short[] sArray = (short[])serializable;
                int n = sArray.length;
                outputStream.write_ulong(n);
                outputStream.write_short_array(sArray, 0, n);
                return;
            } else if (clazz == Character.TYPE) {
                char[] cArray = (char[])serializable;
                int n = cArray.length;
                outputStream.write_ulong(n);
                this.writeCharArray(outputStream, cArray, 0, n);
                return;
            } else {
                if (clazz != Boolean.TYPE) throw new Error("Invalid primitive type : " + serializable.getClass().getName());
                boolean[] blArray = (boolean[])serializable;
                int n = blArray.length;
                outputStream.write_ulong(n);
                outputStream.write_boolean_array(blArray, 0, n);
            }
            return;
        } else if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = ValueHandlerImpl.class$("java.lang.Object")) : class$java$lang$Object)) {
            Object[] objectArray = (Object[])serializable;
            int n = objectArray.length;
            outputStream.write_ulong(n);
            int n2 = 0;
            while (n2 < n) {
                Util.writeAny(outputStream, objectArray[n2]);
                ++n2;
            }
            return;
        } else {
            Object[] objectArray = (Object[])serializable;
            int n = objectArray.length;
            outputStream.write_ulong(n);
            int n3 = 2;
            if (clazz.isInterface()) {
                String string = clazz.getName();
                if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = ValueHandlerImpl.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz)) {
                    n3 = 0;
                } else if ((class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = ValueHandlerImpl.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).isAssignableFrom(clazz)) {
                    n3 = 0;
                } else if (RepositoryId.isAbstractBase(clazz)) {
                    n3 = 1;
                } else if (ObjectStreamClassCorbaExt.isAbstractInterface(clazz)) {
                    n3 = 1;
                }
            }
            int n4 = 0;
            while (n4 < n) {
                switch (n3) {
                    case 0: {
                        Util.writeRemoteObject(outputStream, objectArray[n4]);
                        break;
                    }
                    case 1: {
                        Util.writeAbstractObject(outputStream, objectArray[n4]);
                        break;
                    }
                    case 2: {
                        try {
                            outputStream.write_value((Serializable)objectArray[n4]);
                            break;
                        }
                        catch (ClassCastException classCastException) {
                            if (objectArray[n4] instanceof Serializable) {
                                throw classCastException;
                            }
                            Utility.throwNotSerializableForCorba();
                        }
                    }
                }
                ++n4;
            }
        }
    }

    protected void readCharArray(InputStream inputStream, char[] cArray, int n, int n2) {
        inputStream.read_wchar_array(cArray, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object read_Array(IIOPInputStream iIOPInputStream, InputStream inputStream, Class clazz, CodeBase codeBase, int n) {
        Serializable serializable;
        block52: {
            Serializable serializable2;
            block51: {
                Serializable serializable3;
                block50: {
                    Serializable serializable4;
                    block49: {
                        Serializable serializable5;
                        block48: {
                            Serializable serializable6;
                            block47: {
                                Serializable serializable7;
                                block46: {
                                    Serializable serializable8;
                                    block45: {
                                        Serializable serializable9;
                                        block44: {
                                            try {
                                                int n2 = inputStream.read_ulong();
                                                Class clazz2 = null;
                                                if (clazz == null) {
                                                    int n3 = 0;
                                                    while (true) {
                                                        if (n3 >= n2) {
                                                            Object var9_11 = null;
                                                            Object var16_22 = null;
                                                            iIOPInputStream.activeRecursionMgr.removeObject(n);
                                                            return var9_11;
                                                        }
                                                        inputStream.read_value();
                                                        ++n3;
                                                    }
                                                }
                                                clazz2 = clazz.getComponentType();
                                                if (clazz2.isPrimitive()) {
                                                    if (clazz2 == Integer.TYPE) {
                                                        int[] nArray = new int[n2];
                                                        inputStream.read_long_array(nArray, 0, n2);
                                                        serializable9 = (Serializable)nArray;
                                                        break block44;
                                                    }
                                                    if (clazz2 == Byte.TYPE) {
                                                        byte[] byArray = new byte[n2];
                                                        inputStream.read_octet_array(byArray, 0, n2);
                                                        serializable8 = (Serializable)byArray;
                                                        break block45;
                                                    }
                                                    if (clazz2 == Long.TYPE) {
                                                        long[] lArray = new long[n2];
                                                        inputStream.read_longlong_array(lArray, 0, n2);
                                                        serializable7 = (Serializable)lArray;
                                                        break block46;
                                                    }
                                                    if (clazz2 == Float.TYPE) {
                                                        float[] fArray = new float[n2];
                                                        inputStream.read_float_array(fArray, 0, n2);
                                                        serializable6 = (Serializable)fArray;
                                                        break block47;
                                                    }
                                                    if (clazz2 == Double.TYPE) {
                                                        double[] dArray = new double[n2];
                                                        inputStream.read_double_array(dArray, 0, n2);
                                                        serializable5 = (Serializable)dArray;
                                                        break block48;
                                                    }
                                                    if (clazz2 == Short.TYPE) {
                                                        short[] sArray = new short[n2];
                                                        inputStream.read_short_array(sArray, 0, n2);
                                                        serializable4 = (Serializable)sArray;
                                                        break block49;
                                                    }
                                                    if (clazz2 == Character.TYPE) {
                                                        char[] cArray = new char[n2];
                                                        this.readCharArray(inputStream, cArray, 0, n2);
                                                        serializable3 = (Serializable)cArray;
                                                        break block50;
                                                    }
                                                    if (clazz2 != Boolean.TYPE) throw new Error("Invalid primitive type : " + clazz.getName());
                                                    boolean[] blArray = new boolean[n2];
                                                    inputStream.read_boolean_array(blArray, 0, n2);
                                                    serializable2 = (Serializable)blArray;
                                                    break block51;
                                                }
                                                if (clazz2 == (class$java$lang$Object == null ? (class$java$lang$Object = ValueHandlerImpl.class$("java.lang.Object")) : class$java$lang$Object)) {
                                                    Object object;
                                                    Object[] objectArray = (Object[])Array.newInstance(clazz2, n2);
                                                    iIOPInputStream.activeRecursionMgr.addObject(n, objectArray);
                                                    int n4 = 0;
                                                    while (true) {
                                                        if (n4 >= n2) break;
                                                        object = null;
                                                        try {
                                                            object = Util.readAny(inputStream);
                                                        }
                                                        catch (IndirectionException indirectionException) {
                                                            try {
                                                                object = iIOPInputStream.activeRecursionMgr.getObject(indirectionException.offset);
                                                            }
                                                            catch (IOException iOException) {
                                                                throw new MARSHAL("Invalid indirection to offset " + indirectionException.offset, 0x53550003, CompletionStatus.COMPLETED_NO);
                                                            }
                                                        }
                                                        objectArray[n4] = object;
                                                        ++n4;
                                                    }
                                                    object = (Serializable)objectArray;
                                                    Object var16_31 = null;
                                                    iIOPInputStream.activeRecursionMgr.removeObject(n);
                                                    return object;
                                                }
                                                Object[] objectArray = (Object[])Array.newInstance(clazz2, n2);
                                                iIOPInputStream.activeRecursionMgr.addObject(n, objectArray);
                                                int n5 = 2;
                                                boolean bl = false;
                                                if (clazz2.isInterface()) {
                                                    boolean bl2 = false;
                                                    if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = ValueHandlerImpl.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz2)) {
                                                        n5 = 0;
                                                        bl2 = true;
                                                    } else if ((class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = ValueHandlerImpl.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).isAssignableFrom(clazz2)) {
                                                        n5 = 0;
                                                        bl2 = true;
                                                    } else if (RepositoryId.isAbstractBase(clazz2)) {
                                                        n5 = 1;
                                                        bl2 = true;
                                                    } else if (ObjectStreamClassCorbaExt.isAbstractInterface(clazz2)) {
                                                        n5 = 1;
                                                    }
                                                    if (bl2) {
                                                        try {
                                                            String string = Util.getCodebase(clazz2);
                                                            String string2 = RepositoryId.createForAnyType(clazz2);
                                                            clazz2 = Utility.loadStubClass(string2, string, clazz2);
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            bl = true;
                                                        }
                                                    } else {
                                                        bl = true;
                                                    }
                                                }
                                                int n6 = 0;
                                                while (true) {
                                                    if (n6 >= n2) {
                                                        serializable = (Serializable)objectArray;
                                                        break block52;
                                                    }
                                                    try {
                                                        switch (n5) {
                                                            case 0: {
                                                                if (!bl) {
                                                                    objectArray[n6] = inputStream.read_Object(clazz2);
                                                                    break;
                                                                }
                                                                objectArray[n6] = Utility.readObjectAndNarrow(inputStream, clazz2);
                                                                break;
                                                            }
                                                            case 1: {
                                                                if (!bl) {
                                                                    objectArray[n6] = inputStream.read_abstract_interface(clazz2);
                                                                    break;
                                                                }
                                                                objectArray[n6] = Utility.readAbstractAndNarrow(inputStream, clazz2);
                                                                break;
                                                            }
                                                            case 2: {
                                                                objectArray[n6] = inputStream.read_value(clazz2);
                                                                break;
                                                            }
                                                        }
                                                    }
                                                    catch (IndirectionException indirectionException) {
                                                        try {
                                                            objectArray[n6] = iIOPInputStream.activeRecursionMgr.getObject(indirectionException.offset);
                                                        }
                                                        catch (IOException iOException) {
                                                            throw new MARSHAL("Invalid indirection to offset " + indirectionException.offset, 0x53550003, CompletionStatus.COMPLETED_NO);
                                                        }
                                                    }
                                                    ++n6;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Object var16_33 = null;
                                                iIOPInputStream.activeRecursionMgr.removeObject(n);
                                                throw throwable;
                                            }
                                        }
                                        Object var16_23 = null;
                                        iIOPInputStream.activeRecursionMgr.removeObject(n);
                                        return serializable9;
                                    }
                                    Object var16_24 = null;
                                    iIOPInputStream.activeRecursionMgr.removeObject(n);
                                    return serializable8;
                                }
                                Object var16_25 = null;
                                iIOPInputStream.activeRecursionMgr.removeObject(n);
                                return serializable7;
                            }
                            Object var16_26 = null;
                            iIOPInputStream.activeRecursionMgr.removeObject(n);
                            return serializable6;
                        }
                        Object var16_27 = null;
                        iIOPInputStream.activeRecursionMgr.removeObject(n);
                        return serializable5;
                    }
                    Object var16_28 = null;
                    iIOPInputStream.activeRecursionMgr.removeObject(n);
                    return serializable4;
                }
                Object var16_29 = null;
                iIOPInputStream.activeRecursionMgr.removeObject(n);
                return serializable3;
            }
            Object var16_30 = null;
            iIOPInputStream.activeRecursionMgr.removeObject(n);
            return serializable2;
        }
        Object var16_32 = null;
        iIOPInputStream.activeRecursionMgr.removeObject(n);
        return serializable;
    }

    private boolean isArray(String string) {
        return RepositoryId.cache.getId(string).isSequence();
    }

    protected String getOutputStreamClassName() {
        return "com.sun.corba.se.internal.io.IIOPOutputStream";
    }

    private IIOPOutputStream createOutputStream() {
        return (IIOPOutputStream)AccessController.doPrivileged(new StreamFactory(this.getOutputStreamClassName()));
    }

    protected String getInputStreamClassName() {
        return "com.sun.corba.se.internal.io.IIOPInputStream";
    }

    private IIOPInputStream createInputStream() {
        return (IIOPInputStream)AccessController.doPrivileged(new StreamFactory(this.getInputStreamClassName()));
    }

    protected TCKind getJavaCharTCKind() {
        return TCKind.tk_wchar;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class StreamFactory
    implements PrivilegedAction {
        private String className;

        public StreamFactory(String string) {
            this.className = string;
        }

        public Object run() {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                Class clazz = classLoader.loadClass(this.className);
                return clazz.newInstance();
            }
            catch (Throwable throwable) {
                throw new InternalError("Error loading " + this.className + ": " + throwable.getClass().getName() + ": " + throwable.getMessage());
            }
        }
    }
}

