/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.utils;

public class Tokenizer {
    private String srcString;
    private int strIndex;
    private int strLen;
    private char delimiterChar;
    private char escapeChar;
    private boolean eatEmptyTokens = false;

    public Tokenizer(String string) {
        this.srcString = string;
        if (string != null) {
            this.strLen = string.length();
        }
        this.strIndex = 0;
        this.delimiterChar = (char)44;
        this.escapeChar = (char)92;
        this.eatEmptyTokens = false;
    }

    public void setDelimiter(char c) {
        this.delimiterChar = c;
    }

    public void setEscape(char c) {
        this.escapeChar = c;
    }

    public void reset() {
        this.strIndex = 0;
    }

    public void cullEmptyTokens(boolean bl) {
        this.eatEmptyTokens = bl;
    }

    public String nextToken() {
        String string = "";
        if (this.EOS()) {
            return null;
        }
        if (this.eatEmptyTokens) {
            while (!this.EOS() && this.isDelimiter()) {
                this.incCharPtr();
            }
        }
        while (!this.EOS() && !this.isDelimiter()) {
            char c = this.curChar();
            string = string + c;
            this.incCharPtr();
        }
        this.incCharPtr();
        string = string.trim();
        return string;
    }

    public boolean EOS() {
        return this.strIndex >= this.strLen;
    }

    private char charAt(int n) {
        if (n < 0 || n >= this.strLen) {
            return '\n';
        }
        return this.srcString.charAt(n);
    }

    private boolean isDelimiter() {
        boolean bl = false;
        char c = this.srcString.charAt(this.strIndex);
        if (c == this.delimiterChar) {
            int n = this.strIndex - 1;
            int n2 = 0;
            while (this.charAt(n) == this.escapeChar) {
                ++n2;
                --n;
            }
            if (n2 % 2 == 0) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean isSpace() {
        return Character.isWhitespace(this.srcString.charAt(this.strIndex));
    }

    private void incCharPtr() {
        this.strIndex = this.charAt(this.strIndex) == this.escapeChar ? (this.strIndex += 2) : ++this.strIndex;
    }

    private char curChar() {
        char c = this.srcString.charAt(this.strIndex);
        if (c == this.escapeChar) {
            c = this.strIndex < this.strLen - 1 ? (char)this.srcString.charAt(this.strIndex + 1) : (char)' ';
        }
        return (char)c;
    }
}

