/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.app;

import com.macromedia.generator.api.Buffer;
import com.macromedia.generator.api.Color;
import com.macromedia.generator.api.Context;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.Matrix;
import com.macromedia.generator.api.Rect;
import com.macromedia.generator.api.Script;
import com.macromedia.generator.api.Serial;
import com.macromedia.generator.app.CacheManager;
import com.macromedia.generator.app.CommandProperties;
import com.macromedia.generator.app.Expired;
import com.macromedia.generator.app.FlashCommandException;
import com.macromedia.generator.app.FlashCommandLog;
import com.macromedia.generator.app.FontCache;
import com.macromedia.generator.app.GenericCommand;
import com.macromedia.generator.app.Invalid;
import com.macromedia.generator.app.InvalidCommandException;
import com.macromedia.generator.app.Logo;
import com.macromedia.generator.app.MediaCache;
import com.macromedia.generator.commands.SetEnvironment2Command;
import com.macromedia.generator.commands.SetEnvironmentCommand;
import com.macromedia.generator.platform.Mac;
import com.macromedia.generator.utils.GenInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class FlashEnvironment
extends Hashtable
implements FlashCommandLog {
    private boolean busy;
    private File directory;
    private Serial serial;
    private Script template;
    private String dataEncoding;
    private boolean previewMode;
    private int nestingCount;
    private CacheManager cacheMgr;
    private FontCache fontCache = null;
    private MediaCache mediaCache = null;
    private int loggingLevel = 1;
    private String extFontLocation;
    private PrintWriter logWriter;
    private StringWriter strWriter;
    private Hashtable templateCommands;
    private boolean defaultSymbolScriptLoaded = false;
    private Script defaultSymbolScript = null;
    private byte[] expiredData = Expired.expiredData;
    private byte[] invalidData = Invalid.invalidData;
    private GenInfo mGenInfo = null;
    private static boolean limitedVersion = false;
    private String stringToEmbed = null;
    private Color bgColor = null;

    public FlashEnvironment(int n, boolean bl, Serial serial, String string, CacheManager cacheManager) {
        this.loggingLevel = n;
        this.extFontLocation = string;
        this.previewMode = bl;
        this.serial = serial;
        this.cacheMgr = cacheManager;
        this.strWriter = new StringWriter();
        this.logWriter = new PrintWriter(this.strWriter);
        this.createInternalCaches();
        this.busy = false;
        this.mGenInfo = null;
        if (serial != null) {
            limitedVersion = serial.getLimited();
        }
        this.dataEncoding = "System";
    }

    protected void finalize() throws Throwable {
        this.destroyInternalCaches();
    }

    private void createInternalCaches() {
        if (this.cacheMgr == null || !this.cacheMgr.useInternalCache()) {
            return;
        }
        long l = 0L;
        if (this.cacheMgr.getFontCache() != null && !this.cacheMgr.getFontCache().isCacheEnabled()) {
            l = this.cacheMgr.getInternalFontCacheMaxSize();
            this.fontCache = new FontCache(l, false, true, 0L, true, 0, 0, null);
        }
        if (this.cacheMgr.getMediaCache() != null && !this.cacheMgr.getMediaCache().isCacheEnabled()) {
            l = this.cacheMgr.getInternalMediaCacheMaxSize();
            this.mediaCache = new MediaCache(l, false, true, 0L, true, 0, 0, null);
        }
    }

    private void destroyInternalCaches() {
        if (this.fontCache != null) {
            this.fontCache.dispose();
            this.fontCache = null;
        }
        if (this.mediaCache != null) {
            this.mediaCache.dispose();
            this.mediaCache = null;
        }
    }

    public FontCache getFontCache() {
        return this.fontCache;
    }

    public MediaCache getMediaCache() {
        return this.mediaCache;
    }

    public void setDefaultSymbolScript(Script script) {
        this.defaultSymbolScript = script;
    }

    public Script getDefaultSymbolScript() {
        return this.defaultSymbolScript;
    }

    public Script loadDefaultSymbols() {
        String string = null;
        File file = null;
        string = System.getProperty("com.macromedia.generator.defaultSymbolFile");
        if (string != null) {
            file = this.makeFile(string);
        }
        if (file == null) {
            String string2 = System.getProperty("com.macromedia.generator.installpath");
            String string3 = System.getProperty("file.separator");
            if (string2 != null) {
                if (string != null) {
                    string = string2 + string3 + "bin" + string3 + string;
                    file = this.makeFile(string);
                }
                if (file == null) {
                    string = string2 + string3 + "bin" + string3 + "DefaultSymbolFile.swt";
                    file = this.makeFile(string);
                }
            }
        }
        if (file == null || !file.exists() || !file.isFile()) {
            this.defaultSymbolScript = null;
        } else {
            this.defaultSymbolScript = new Script();
            try {
                this.defaultSymbolScript.setFile(file.getPath(), true);
            }
            catch (GeneratorApiException generatorApiException) {
                this.defaultSymbolScript = null;
            }
        }
        return this.defaultSymbolScript;
    }

    private File makeFile(String string) {
        File file = null;
        Mac mac = Mac.getMac();
        if (mac != null) {
            String string2 = mac.makeJavaPretty(string);
            file = new File(string2);
            if (!file.exists() || !file.isFile()) {
                file = new File(string2.substring(1));
            }
        } else {
            file = new File(string);
        }
        if (file == null) {
            return file;
        }
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        return file;
    }

    private synchronized Class findTemplateCommand(String string, FlashEnvironment flashEnvironment) {
        if (this.templateCommands == null) {
            this.templateCommands = new Hashtable();
        }
        try {
            Class<?> clazz = (Class<?>)this.templateCommands.get(string);
            if (clazz == null) {
                clazz = Class.forName(string);
                this.templateCommands.put(string, clazz);
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.macromedia.generator.resources.ResourceData", Locale.getDefault());
            flashEnvironment.logError(resourceBundle.getString("FlashCommand") + string + ": " + resourceBundle.getString("TemplateNotFound"));
        }
        catch (ClassCastException classCastException) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.macromedia.generator.resources.ResourceData", Locale.getDefault());
            flashEnvironment.logError(resourceBundle.getString("FlashCommand") + string + ": " + resourceBundle.getString("TemplateCast"));
        }
        catch (Exception exception) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.macromedia.generator.resources.ResourceData", Locale.getDefault());
            flashEnvironment.logError(resourceBundle.getString("FlashCommand") + string + ": " + exception.getMessage());
        }
        return null;
    }

    public boolean getPreviewMode() {
        return this.previewMode;
    }

    public void setDataEncoding(String string) {
        this.dataEncoding = string;
    }

    public String getDataEncoding() {
        return this.dataEncoding;
    }

    public Script getTemplate() {
        return this.template;
    }

    public File getDirectory() {
        return this.directory;
    }

    public String getExternalFontLocation() {
        return this.extFontLocation;
    }

    public String getMessages() {
        return this.strWriter.toString();
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public CacheManager getCacheManager() {
        return this.cacheMgr;
    }

    public void processScript(Script script, Context context) {
        ++this.nestingCount;
        if (this.nestingCount < 50) {
            Object object;
            Context context2;
            if (script == this.template) {
                context2 = context;
            } else {
                context2 = new Context();
                context2.setParent(context);
            }
            int n = script.getCommandCount();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                block15: {
                    String string = script.getCommandString(n2);
                    try {
                        GenericCommand genericCommand;
                        CommandProperties commandProperties = new CommandProperties();
                        commandProperties.parseCommand(string);
                        object = this.findTemplateCommand(commandProperties.getProperty("command"), this);
                        if (object == null || (genericCommand = (GenericCommand)((Class)object).newInstance()) == null) break block15;
                        long l = System.currentTimeMillis();
                        if (genericCommand instanceof SetEnvironmentCommand || genericCommand instanceof SetEnvironment2Command) {
                            if (bl) break block15;
                            bl = true;
                        }
                        genericCommand.doCommand(this, script, context2, n2, commandProperties);
                    }
                    catch (InstantiationException instantiationException) {
                        this.logError(this.getResString("CommandProcess") + n2 + ": " + string);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        this.logError(this.getResString("CommandProcess") + n2 + ": " + string);
                    }
                    catch (FlashCommandException flashCommandException) {
                        this.logError(this.getResString("CommandProcess") + n2 + ": " + string);
                    }
                    catch (InvalidCommandException invalidCommandException) {
                        this.logError(this.getResString("CommandProcess") + n2 + ": " + string);
                    }
                }
                ++n2;
            }
            int n3 = script.getScriptCount();
            int n4 = 0;
            while (n4 < n3) {
                object = script.getScript(n4);
                if (!((Script)object).getIsCommand() && !((Script)object).getIsProcessed()) {
                    this.processScript((Script)object, context2);
                }
                ((Script)object).release();
                ++n4;
            }
            script.applyContext(context2);
            if (context2 != context) {
                context2.release();
            }
        } else {
            this.logError(this.getResString("InfiniteLoop"));
        }
        script.setIsProcessed(true);
        --this.nestingCount;
    }

    public Buffer processTemplate(File file, Vector vector) {
        Object object;
        Buffer buffer = null;
        if (this.busy) {
            this.logError(this.getResString("InvalidCall"));
            return null;
        }
        if (file.getAbsolutePath().endsWith(".swf")) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                buffer = new Buffer();
                int n = fileInputStream.available();
                byte[] byArray = new byte[n];
                int n2 = fileInputStream.read(byArray);
                buffer.write(byArray);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logError(this.getResString("LoadTempError") + file.getAbsolutePath());
                buffer = null;
            }
            catch (IOException iOException) {
                this.logError("ummm... not good.");
                buffer = null;
            }
            catch (GeneratorApiException generatorApiException) {
                this.logError("Error in writing buffer for " + file.getAbsolutePath());
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return buffer;
        }
        int n = this.serial.flush(this.previewMode);
        if (this.previewMode) {
            n = 0;
        }
        if (n == 1) {
            this.logError(this.getResString("SerialExpired"));
            try {
                buffer = new Buffer();
                buffer.write(this.expiredData);
            }
            catch (GeneratorApiException generatorApiException) {
                this.logError(this.getResString("MemWriteErr"));
                return null;
            }
        }
        if (n == 2) {
            this.logError(this.getResString("SerialInvalid"));
            try {
                buffer = new Buffer();
                buffer.write(this.invalidData);
            }
            catch (GeneratorApiException generatorApiException) {
                this.logError(this.getResString("MemWriteErr"));
                return null;
            }
        }
        this.busy = true;
        Context context = new Context();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (String[])enumeration.nextElement();
            context.setValue(object[0], object[1]);
        }
        if (!file.exists() || !file.isFile()) {
            this.logError(this.getResString("LoadTempError") + file.getAbsolutePath());
            context.release();
            this.busy = false;
            return null;
        }
        object = new File(file.getAbsolutePath());
        String string = ((File)object).getParent();
        if (string == null) {
            this.logError(this.getResString("TempPathErr"));
            context.release();
            this.busy = false;
            return null;
        }
        this.directory = new File(string);
        try {
            this.template = new Script();
            this.template.setFile(((File)object).getPath(), !this.previewMode);
            this.template.setSerial(this.serial);
        }
        catch (GeneratorApiException generatorApiException) {
            this.logError(this.getResString("TempCreateErr"));
            context.release();
            this.busy = false;
            return null;
        }
        try {
            if (this.cacheMgr != null) {
                this.cacheMgr.loadExternalFonts(this, this.template);
            }
        }
        catch (GeneratorApiException generatorApiException) {
            context.release();
            this.busy = false;
            return null;
        }
        this.nestingCount = 0;
        this.processScript(this.template, context);
        if (this.stringToEmbed != null && this.stringToEmbed.length() > 0) {
            try {
                this.template.addTag(this.stringToEmbed, this.getDataEncoding());
            }
            catch (GeneratorApiException generatorApiException) {
                this.logError(this.getResString("EmbedStringErr"));
            }
        }
        if (this.bgColor != null) {
            this.template.insertBackgroundColor(this.bgColor);
        }
        if (n == 3) {
            try {
                int n3 = this.template.getLastFrame();
                Buffer buffer2 = new Buffer();
                buffer2.write(Logo.logoData);
                Script script = new Script();
                script.setBuffer(buffer2);
                script.insertFrames(0, n3);
                int n4 = this.template.getWidth();
                int n5 = this.template.getHeight();
                int n6 = script.getWidth();
                int n7 = script.getHeight();
                long l = System.currentTimeMillis() / 100L;
                String string2 = Long.toString(l);
                int n8 = (int)(l - l / 5L * 5L);
                int n9 = 100;
                int n10 = 100;
                int n11 = n6 / 2;
                int n12 = n7 / 2;
                Rect rect = this.template.getBounds();
                switch (n8) {
                    default: {
                        n9 = rect.getXMin() + n11;
                        n10 = rect.getYMin() + n12;
                        break;
                    }
                    case 1: {
                        n9 = rect.getXMax() - n11;
                        n10 = rect.getYMin() + n12;
                        break;
                    }
                    case 2: {
                        n9 = rect.getXMax() - n11;
                        n10 = rect.getYMax() - n12;
                        break;
                    }
                    case 3: {
                        n9 = rect.getXMin() + n11;
                        n10 = rect.getYMax() - n12;
                        break;
                    }
                    case 4: {
                        n9 = (rect.getXMin() + rect.getXMax() >> 1) - 4 * n11;
                        n10 = (rect.getYMin() + rect.getYMax() >> 1) - 4 * n12;
                    }
                }
                float f = 1.0f;
                float f2 = 1.0f;
                Matrix matrix = new Matrix();
                matrix.setXOffset(n9);
                matrix.setYOffset(n10);
                matrix.setXScale(f);
                matrix.setYScale(f2);
                this.template.insertObject(script, 0, 0, matrix, n3, matrix, null, string2);
                script.release();
                matrix.release();
                buffer2.release();
            }
            catch (GeneratorApiException generatorApiException) {
                this.logError(this.getResString("InsertMarkErr"));
                context.release();
                this.busy = false;
                return null;
            }
        }
        try {
            buffer = this.template.writeBuffer();
        }
        catch (GeneratorApiException generatorApiException) {
            this.logError(this.getResString("MemWriteErr"));
            context.release();
            this.busy = false;
            return null;
        }
        this.template.release();
        this.template = null;
        this.directory = null;
        context.release();
        this.busy = false;
        return buffer;
    }

    public GenInfo getGenInfo() {
        if (this.mGenInfo == null) {
            this.mGenInfo = new GenInfo();
            this.mGenInfo.setEnvironment(this);
        }
        return this.mGenInfo;
    }

    public int logLevel() {
        return this.loggingLevel;
    }

    public void logError(String string, String string2, String string3) {
        if (this.loggingLevel > 0) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault());
            this.logWriter.println("\t" + resourceBundle.getString(string2) + (string3 != null ? string3 : ""));
        }
    }

    public void logError(String string) {
        if (this.loggingLevel > 0) {
            this.logWriter.println("\t" + string);
        }
    }

    public void logWarning(String string, String string2, String string3) {
        if (this.loggingLevel > 1) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault());
            this.logWriter.println("\t" + resourceBundle.getString(string2) + (string3 != null ? string3 : ""));
        }
    }

    public void logWarning(String string) {
        if (this.loggingLevel > 1) {
            this.logWriter.println("\t" + string);
        }
    }

    public void logMessage(String string, String string2, String string3) {
        if (this.loggingLevel > 2) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault());
            this.logWriter.println("\t" + resourceBundle.getString(string2) + (string3 != null ? string3 : ""));
        }
    }

    public void logMessage(String string) {
        if (this.loggingLevel > 2) {
            this.logWriter.println("\t" + string);
        }
    }

    public String getResString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.macromedia.generator.resources.ResourceData", Locale.getDefault());
        return resourceBundle.getString(string);
    }

    public static boolean isLimited() {
        return limitedVersion;
    }

    public void setEmbeddedString(String string) {
        this.stringToEmbed = string;
    }

    public void setBackgroundColor(String string) {
        if (string == null || string.length() == 0) {
            this.bgColor = null;
            return;
        }
        try {
            Color color = new Color();
            color.setRGBValue(string);
            this.bgColor = color;
        }
        catch (GeneratorApiException generatorApiException) {
            this.logError(this.getResString("BGColorErr") + string);
        }
    }
}

