/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.webdesigner3.ve;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class EditorSettings {
    public static final String SEPERATOR = ";";
    protected IResource file;
    protected IEditorPart editor;
    protected ArrayList settings = new ArrayList();

    protected EditorSettings(IResource f, IEditorPart e) {
        this.file = f;
        this.editor = e;
    }

    public void apply() {
        int i = 0;
        while (i < this.settings.size()) {
            ((ISetting)this.settings.get(i)).apply();
            ++i;
        }
    }

    public void addSetting(ISetting s) {
        s.setQualifier("com.genuitec.eclipse.ui.common");
        s.setEditor(this.editor);
        s.setResource(this.file);
        this.settings.add(s);
    }

    public void addSettingAndApply(ISetting s) {
        this.addSetting(s);
        s.apply();
    }

    public void dispose() {
        int i = 0;
        while (i < this.settings.size()) {
            ((ISetting)this.settings.get(i)).dispose();
            ++i;
        }
    }

    public void setInput(FileEditorInput input) {
        this.file = input.getFile();
        int i = 0;
        while (i < this.settings.size()) {
            ((ISetting)this.settings.get(i)).setResource(this.file);
            ++i;
        }
    }

    public static EditorSettings getEditorSetting(IEditorPart editor) {
        EditorSettings settings = null;
        if (editor != null) {
            IFile r = ((FileEditorInput)editor.getEditorInput()).getFile();
            settings = new EditorSettings((IResource)r, editor);
        }
        return settings;
    }

    public String toString() {
        return this.file.getName();
    }

    public static interface ISetting {
        public void apply();

        public void dispose();

        public void setQualifier(String var1);

        public void setEditor(IEditorPart var1);

        public void setResource(IResource var1);
    }
}

