/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.util;

import com.genuitec.eclipse.core.CommonUI;
import com.genuitec.eclipse.core.util.Util;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;

public class FileResourceUtils {
    private static final byte[] BUFFER = new byte[8192];

    public static String getSrcPath(IJavaProject theJavaProject) {
        try {
            List<IClasspathEntry> cp = Arrays.asList(theJavaProject.getRawClasspath());
            for (IClasspathEntry c : cp) {
                if (c.getEntryKind() != 3) continue;
                return c.getPath().toString();
            }
        }
        catch (Exception e) {
            CommonUI.getDefault().log("Error", e);
        }
        return null;
    }

    public static boolean classExist(IJavaProject theJavaProject, String typeName) {
        boolean result = false;
        try {
            result = Util.isNullOrEmpty((String)typeName) ? false : theJavaProject.findType(typeName) != null;
        }
        catch (Exception e) {
            CommonUI.getDefault().log("Error", e);
        }
        return result;
    }

    public static boolean fileExist(Object oProject, Object oFile) {
        if (oFile == null) {
            return false;
        }
        if (!(oProject instanceof IProject)) {
            throw new IllegalArgumentException("Project must be an instance of org.eclipse.core.resources.IProject");
        }
        if (!(oFile instanceof IPath)) {
            throw new IllegalArgumentException("File must be an instance of org.eclipse.core.runtime.IPath");
        }
        IProject project = (IProject)oProject;
        IPath file = (IPath)oFile;
        if (file.isAbsolute()) {
            file = new Path("./" + file);
        }
        return project.exists(file);
    }

    public static boolean fileExist(String osPath) {
        if (osPath == null) {
            return false;
        }
        File temp = new File(osPath);
        return temp != null && temp.exists();
    }

    protected IJavaElement getInitialJavaElement(IStructuredSelection selection) {
        IProject[] projects;
        IResource resource;
        IAdaptable adaptable;
        Object selectedElement;
        IJavaElement jelem = null;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IAdaptable && (jelem = (IJavaElement)(adaptable = (IAdaptable)selectedElement).getAdapter(IJavaElement.class)) == null && (resource = (IResource)adaptable.getAdapter(IResource.class)) != null && resource.getType() != 8) {
            while (jelem == null && resource.getType() != 4) {
                resource = resource.getParent();
                jelem = (IJavaElement)resource.getAdapter(IJavaElement.class);
            }
            if (jelem == null) {
                jelem = JavaCore.create((IResource)resource);
            }
        }
        if (jelem == null) {
            jelem = EditorUtility.getActiveEditorJavaInput();
        }
        if (jelem == null && (projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()).length > 0) {
            jelem = JavaCore.create((IProject)projects[0]);
        }
        return jelem;
    }

    public static boolean fileDoesNotExist(IFileEditorInput input, Throwable[] coreException) {
        boolean result;
        block16: {
            result = false;
            InputStream inStream = null;
            if (!input.exists() || !input.getFile().exists()) {
                result = true;
            } else {
                try {
                    try {
                        inStream = input.getFile().getContents(true);
                    }
                    catch (CoreException e) {
                        result = true;
                        coreException[0] = e;
                        if (input == null) break block16;
                        try {
                            if (inStream != null) {
                                inStream.close();
                            }
                        }
                        catch (IOException e2) {
                            CommonUI.getDefault().log(e2);
                        }
                    }
                }
                finally {
                    if (input != null) {
                        try {
                            if (inStream != null) {
                                inStream.close();
                            }
                        }
                        catch (IOException e) {
                            CommonUI.getDefault().log(e);
                        }
                    }
                }
            }
        }
        return result;
    }

    public static boolean unZip(File input, File outputFolder) {
        ZipFile zFile = null;
        ZipLeveledStructureProvider structureProvider = null;
        try {
            try {
                zFile = new ZipFile(input);
                structureProvider = new ZipLeveledStructureProvider(zFile);
                Object root = structureProvider.getRoot();
                FileResourceUtils.unZip(structureProvider, root, outputFolder);
            }
            catch (IOException e) {
                CommonUI.getDefault().log("Could not unzip file", e);
                if (structureProvider != null) {
                    structureProvider.closeArchive();
                }
                if (zFile != null) {
                    try {
                        zFile.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (structureProvider != null) {
                structureProvider.closeArchive();
            }
            if (zFile != null) {
                try {
                    zFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (structureProvider != null) {
            structureProvider.closeArchive();
        }
        if (zFile != null) {
            try {
                zFile.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private static void unZip(ZipLeveledStructureProvider sProvider, Object root, File parent) throws IOException {
        List children = sProvider.getChildren(root);
        if (children == null) {
            return;
        }
        for (ZipEntry entry : children) {
            File output = new File(parent, entry.getName());
            if (!entry.isDirectory()) {
                int count;
                InputStream stream = sProvider.getContents((Object)entry);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(output), BUFFER.length);
                while ((count = stream.read(BUFFER)) != -1) {
                    bos.write(BUFFER, 0, count);
                }
                bos.flush();
                bos.close();
                stream.close();
                continue;
            }
            if (!output.exists()) {
                output.mkdir();
            }
            FileResourceUtils.unZip(sProvider, entry, parent);
        }
    }

    public static boolean checkProjectVariantExists(String projectName) {
        Resource container = (Resource)Util.getWorkspaceRoot();
        IResource project = container.findExistingResourceVariant((IPath)new Path("/" + projectName));
        return project != null;
    }
}

