/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.preference;

import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.ui.preference.ListFieldEditor;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Widget;

public class TldsFieldEditor
extends ListFieldEditor {
    protected Button addTldButton;
    private String lastPath;

    protected TldsFieldEditor() {
    }

    public TldsFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected String[] getNewTld() {
        String file;
        FileDialog dialog = new FileDialog(this.addTldButton.getShell(), 2);
        dialog.setFilterExtensions(new String[]{"*.tld", "*.*"});
        dialog.setFilterNames(new String[]{"*.tld", Messages.TldsFieldEditor_filtername_all_files});
        if (this.lastPath != null && new File(this.lastPath).exists()) {
            dialog.setFilterPath(this.lastPath);
        }
        if ((file = dialog.open()) == null) {
            return null;
        }
        String[] files = dialog.getFileNames();
        ArrayList<String> fileList = new ArrayList<String>(files.length);
        IPath dirPath = new Path(file).removeLastSegments(1);
        int i = 0;
        while (i < files.length) {
            file = files[i].trim();
            if (file.length() != 0) {
                if (i == 0) {
                    this.lastPath = new File(file).getAbsolutePath();
                }
                String displayString = this.makeDisplayPathString(dirPath.append(file).toOSString());
                fileList.add(displayString);
            }
            ++i;
        }
        return fileList.toArray(new String[fileList.size()]);
    }

    @Override
    protected void createButtons(Composite buttonBox) {
        this.addTldButton = this.createPushButton(buttonBox, Messages.TldsFieldEditor_button_add_tlds);
        this.removeButton = this.createPushButton(buttonBox, Messages.TldsFieldEditor_button_remove);
    }

    @Override
    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == TldsFieldEditor.this.addTldButton) {
                    TldsFieldEditor.this.addTldPressed();
                } else if (widget == TldsFieldEditor.this.removeButton) {
                    TldsFieldEditor.this.removePressed();
                } else if (widget == TldsFieldEditor.this.list) {
                    TldsFieldEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void addTldPressed() {
        this.setPresentsDefaultValue(false);
        String[] inputs = this.getNewTld();
        if (inputs != null) {
            int i = 0;
            while (i < inputs.length) {
                String input = inputs[i];
                int index = this.list.getSelectionIndex();
                if (index >= 0) {
                    this.list.add(input, index + 1);
                } else {
                    this.list.add(input, 0);
                }
                this.selectionChanged();
                ++i;
            }
        }
    }
}

