/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.preference;

import com.genuitec.eclipse.core.CommonUI;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class ExtFieldEditorPreferencePage
extends FieldEditorPreferencePage {
    private IPreferenceStore store;
    private List<FieldEditor> editors;
    private HashSet<FieldEditor> modifiedEditors;
    private boolean noUpdate = false;

    public ExtFieldEditorPreferencePage() {
        this(0);
    }

    protected ExtFieldEditorPreferencePage(int style) {
        super(style);
    }

    protected ExtFieldEditorPreferencePage(String title, int style) {
        super(title, style);
    }

    protected ExtFieldEditorPreferencePage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.getPreferenceStore()) {
            if (this.loadEditors() && !this.noUpdate) {
                for (FieldEditor fldEd : this.editors) {
                    if (!fldEd.getPreferenceName().equals(event.getProperty()) || this.getModifiedEditors().contains(fldEd)) continue;
                    fldEd.load();
                }
            }
        } else if (event.getSource() instanceof FieldEditor) {
            if (event.getNewValue() != null && event.getNewValue().toString().equals(this.store.getString(((FieldEditor)event.getSource()).getPreferenceName()))) {
                this.getModifiedEditors().remove((FieldEditor)event.getSource());
            } else {
                this.getModifiedEditors().add((FieldEditor)event.getSource());
            }
        }
    }

    protected void performDefaults() {
        this.noUpdate = true;
        try {
            super.performDefaults();
        }
        finally {
            this.noUpdate = false;
        }
    }

    protected HashSet<FieldEditor> getModifiedEditors() {
        if (this.modifiedEditors == null) {
            this.modifiedEditors = new HashSet();
        }
        return this.modifiedEditors;
    }

    public IPreferenceStore getPreferenceStore() {
        IPreferenceStore res = super.getPreferenceStore();
        this.addListenerIfRequired(res);
        return res;
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.addListenerIfRequired(store);
        super.setPreferenceStore(store);
    }

    public boolean performOk() {
        this.noUpdate = true;
        try {
            boolean result = super.performOk();
            this.getModifiedEditors().clear();
            boolean bl = result;
            return bl;
        }
        finally {
            this.noUpdate = false;
        }
    }

    protected boolean loadEditors() {
        if (this.editors == null) {
            try {
                Field f = FieldEditorPreferencePage.class.getDeclaredField("fields");
                f.setAccessible(true);
                this.editors = (List)f.get((Object)this);
            }
            catch (Exception e) {
                CommonUI.getDefault().log("Cannot retrieve list of editors", e);
                this.editors = new ArrayList<FieldEditor>();
            }
        }
        return this.editors != null;
    }

    private void addListenerIfRequired(IPreferenceStore newStore) {
        if (newStore != this.store) {
            if (this.store != null) {
                this.store.removePropertyChangeListener((IPropertyChangeListener)this);
            }
            this.store = newStore;
            if (this.store != null) {
                this.store.addPropertyChangeListener((IPropertyChangeListener)this);
            }
        }
    }

    public void dispose() {
        this.addListenerIfRequired(null);
        super.dispose();
    }
}

