/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.preference;

import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.ui.preference.ListButtonDetails;
import com.genuitec.eclipse.core.ui.preference.ListFieldEditor;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;

public class ClasspathFieldEditor
extends ListFieldEditor {
    public static final String DEFAULT_ADDJARZIP_LABEL = Messages.ClasspathFieldEditor_label_default_addjarzip;
    public static final String DEFAULT_ADDDIR_LABEL = Messages.ClasspathFieldEditor_label_default_adddir;
    private String lastPath;
    private String[] customExtensions = null;

    protected ClasspathFieldEditor() {
    }

    public ClasspathFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, new ListButtonDetails(DEFAULT_ADDJARZIP_LABEL, DEFAULT_ADDDIR_LABEL, ListButtonDetails.DEFAULT_REMOVE_LABEL, ListButtonDetails.DEFAULT_MOVEUP_LABEL, ListButtonDetails.DEFAULT_MOVEDOWN_LABEL), parent);
    }

    public ClasspathFieldEditor(String name, String labelText, ListButtonDetails theButtonDetails, Composite parent) {
        super(name, labelText, theButtonDetails, parent);
    }

    public ClasspathFieldEditor(String name, String labelText, ListButtonDetails theButtonDetails, Composite parent, String[] customExtensions) {
        super(name, labelText, theButtonDetails, parent);
        this.customExtensions = customExtensions;
    }

    public void store() {
        super.store();
    }

    protected String[] getNewJarZip() {
        String file;
        FileDialog dialog = new FileDialog(this.addButton1.getShell(), 2);
        if (this.customExtensions == null) {
            dialog.setFilterNames(new String[]{Messages.ClasspathFieldEditor_filternames_newjarzip_1, Messages.ClasspathFieldEditor_filternames_newjarzip_2});
            dialog.setFilterExtensions(new String[]{"*.jar;*.zip", "*.*"});
        } else {
            dialog.setFilterNames(this.customExtensions);
            dialog.setFilterExtensions(this.customExtensions);
        }
        if (this.lastPath != null && new File(this.lastPath).exists()) {
            dialog.setFilterPath(this.lastPath);
        }
        if ((file = dialog.open()) == null) {
            return new String[0];
        }
        String[] files = dialog.getFileNames();
        ArrayList<String> fileList = new ArrayList<String>(files.length);
        IPath dirPath = new Path(file).removeLastSegments(1);
        int i = 0;
        while (i < files.length) {
            file = files[i].trim();
            if (file.length() != 0) {
                if (i == 0) {
                    this.lastPath = new File(file).getAbsolutePath();
                }
                fileList.add(dirPath.append(file).toOSString());
            }
            ++i;
        }
        return fileList.toArray(new String[fileList.size()]);
    }

    protected String getNewDir() {
        String dir;
        DirectoryDialog dialog = new DirectoryDialog(this.addButton1.getShell());
        if (this.lastPath != null && new File(this.lastPath).exists()) {
            dialog.setFilterPath(this.lastPath);
        }
        if ((dir = dialog.open()) != null) {
            if ((dir = dir.trim()).length() == 0) {
                return null;
            }
            this.lastPath = dir;
        }
        return dir;
    }

    @Override
    protected void createButtons(Composite buttonBox) {
        super.createButtons(buttonBox);
    }

    @Override
    protected void add1Pressed() {
        this.setPresentsDefaultValue(false);
        String[] input = this.getNewJarZip();
        if (input != null) {
            int index = this.list.getSelectionIndex();
            index = index > 0 ? index : 0;
            int i = 0;
            while (i < input.length) {
                this.list.add(input[i], index++);
                ++i;
            }
            this.selectionChanged();
        }
    }

    @Override
    protected void add2Pressed() {
        this.setPresentsDefaultValue(false);
        String input = this.getNewDir();
        if (input != null) {
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.add(input, index + 1);
            } else {
                this.list.add(input, 0);
            }
            this.selectionChanged();
        }
    }
}

