/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.dialog;

import com.genuitec.eclipse.core.ui.util.SWTUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LinkDialog
extends MessageDialog {
    private Link messageLink;
    private final Runnable linkRunnable;
    private String checkboxLabel;
    private boolean checkboxState;
    private Button checkbox;

    public LinkDialog(Shell theParentShell, String theDialogTitle, Image theDialogTitleImage, String theDialogMessage, int theDialogImageType, String[] theDialogButtonLabels, int theDefaultIndex, Runnable linkRunnable) {
        super(theParentShell, theDialogTitle, theDialogTitleImage, theDialogMessage, theDialogImageType, theDialogButtonLabels, theDefaultIndex);
        this.linkRunnable = linkRunnable;
    }

    public void setCheckboxLabel(String checkboxLabel) {
        this.checkboxLabel = checkboxLabel;
    }

    public boolean getToggleState() {
        return this.checkboxState;
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            this.addAccessibleListeners(this.imageLabel, image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        if (this.message != null) {
            this.messageLink = new Link(composite, this.getMessageLabelStyle());
            this.messageLink.setText(this.message);
            this.messageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent theE) {
                    SWTUtil.postOnDisplayQueue((Runnable)LinkDialog.this.linkRunnable);
                }
            });
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.messageLink);
        }
        if (this.checkboxLabel != null) {
            this.checkbox = new Button(composite, 32);
            this.checkbox.setText(this.checkboxLabel);
            GridDataFactory.generate((Control)this.checkbox, (Point)new Point(2, 1));
        }
        return composite;
    }

    public boolean close() {
        this.checkboxState = this.checkbox != null && this.checkbox.getSelection();
        return super.close();
    }

    private void addAccessibleListeners(Label label, final Image image) {
        label.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                String accessibleMessage = LinkDialog.this.getAccessibleMessageFor(image);
                if (accessibleMessage == null) {
                    return;
                }
                event.result = accessibleMessage;
            }
        });
    }

    private String getAccessibleMessageFor(Image image) {
        if (image.equals((Object)this.getErrorImage())) {
            return JFaceResources.getString((String)"error");
        }
        if (image.equals((Object)this.getWarningImage())) {
            return JFaceResources.getString((String)"warning");
        }
        if (image.equals((Object)this.getInfoImage())) {
            return JFaceResources.getString((String)"info");
        }
        if (image.equals((Object)this.getQuestionImage())) {
            return JFaceResources.getString((String)"question");
        }
        return null;
    }

    public static final class HelpRunnable
    implements Runnable {
        private final String helpTopic;

        public HelpRunnable(String helpTopic) {
            this.helpTopic = helpTopic;
        }

        @Override
        public void run() {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(this.helpTopic);
        }
    }
}

