/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.property;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;

public class MetricSummary {
    public static final int PRJ = 1;
    public static final int SRC_FOLDER = 2;
    public static final int PKG = 3;
    public static final int CLASS = 4;
    public static final int OTHER = 0;
    private int type = 0;
    private IJavaElement javaElement;
    private int localCount;
    private ArrayList children;

    public MetricSummary(IJavaProject theProject) {
        this((IJavaElement)theProject, 1);
    }

    public MetricSummary(IPackageFragmentRoot thePkgFragmentRoot) {
        this((IJavaElement)thePkgFragmentRoot, 2);
    }

    public MetricSummary(IPackageFragment thePkgFragment) {
        this((IJavaElement)thePkgFragment, 3);
    }

    public MetricSummary(ICompilationUnit theCompUnit) {
        this((IJavaElement)theCompUnit, 4);
        try {
            ISourceRange srcRanage = theCompUnit.getSourceRange();
            this.setLocalCount(srcRanage.getLength());
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public MetricSummary(IJavaElement theJavaElement, int theType) {
        this.type = theType;
        this.javaElement = theJavaElement;
        if (theType != 4) {
            this.children = new ArrayList();
        }
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public void addChild(MetricSummary theChild) {
        this.children.add(theChild);
    }

    public int getLocalCount() {
        return this.localCount;
    }

    public void setLocalCount(int localCount) {
        this.localCount = localCount;
    }

    public IJavaElement getJavaElement() {
        return this.javaElement;
    }

    public IResource getResource() {
        return this.getJavaElement().getResource();
    }

    public int getType() {
        return this.type;
    }
}

