/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core;

import com.genuitec.eclipse.core.util.EditorUtil;
import java.util.ArrayList;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class GenerateFacadePropertyTester
extends PropertyTester {
    public boolean test(Object theReceiver, String theProperty, Object[] theArgs, Object theExpectedValue) {
        IEditorPart activeEditor;
        if (theReceiver instanceof TreeSelection) {
            return this.validateSelection((StructuredSelection)theReceiver);
        }
        if (theReceiver instanceof TextSelection && (activeEditor = EditorUtil.getActiveEditor()) instanceof CompilationUnitEditor) {
            return this.isEnabledForSelection((CompilationUnitEditor)activeEditor);
        }
        return false;
    }

    private boolean validateSelection(StructuredSelection selection) {
        if (selection.size() == 1) {
            if (selection instanceof StructuredSelection) {
                boolean enabled = this.isEnabledForSelection(selection.getFirstElement());
                return enabled;
            }
        } else if (selection.size() > 1) {
            int packageSelected = 0;
            int validElement = 0;
            IJavaElement referencePackage = null;
            for (Object selectedElement : selection.toList()) {
                if (selectedElement instanceof PackageFragment) {
                    if (++packageSelected > 1) {
                        return false;
                    }
                    referencePackage = (IJavaElement)selectedElement;
                    ++validElement;
                    continue;
                }
                if (!(selectedElement instanceof ICompilationUnit)) continue;
                if (referencePackage != null && !((ICompilationUnit)selectedElement).getParent().equals(referencePackage)) {
                    return false;
                }
                referencePackage = ((ICompilationUnit)selectedElement).getParent();
                ++validElement;
            }
            if (validElement > 0) {
                boolean finalResult = false;
                for (Object selectedElement : selection.toList()) {
                    boolean result = this.isEnabledForSelection(selectedElement);
                    finalResult |= result;
                }
                return finalResult;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEnabledForSelection(Object element) {
        try {
            if (!(element instanceof PackageFragment)) {
                if (!(element instanceof CompilationUnit)) return false;
                return this.isEnabledforSelection((CompilationUnit)element);
            }
            boolean result = true;
            PackageFragment packageSelected = (PackageFragment)element;
            if (!packageSelected.hasChildren()) {
                return false;
            }
            IJavaElement[] iJavaElementArray = packageSelected.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return result;
                }
                IJavaElement children = iJavaElementArray[n2];
                if (children instanceof CompilationUnit) {
                    result |= this.isEnabledforSelection((CompilationUnit)children);
                } else {
                    boolean cfr_ignored_0 = children instanceof PackageFragment;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    private boolean isEnabledforSelection(CompilationUnit compilationUnit) {
        ArrayList types = null;
        Object type = null;
        try {
            IJavaProject jProject;
            types = compilationUnit.getChildrenOfType(7);
            if (!types.isEmpty()) {
                type = types.get(0);
            }
            if (type instanceof SourceType && (jProject = ((SourceType)type).getJavaProject()) != null) {
                SourceType sType = type;
                return Flags.isPublic((int)sType.getFlags());
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    protected boolean isEnabledForSelection(CompilationUnitEditor editor) {
        IEditorInput input = editor.getEditorInput();
        ITypeRoot editorElement = JavaUI.getEditorInputTypeRoot((IEditorInput)input);
        if (editorElement instanceof CompilationUnit) {
            return this.isEnabledForSelection(editorElement);
        }
        return false;
    }
}

