/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.wizard;

import com.genuitec.eclipse.core.GenuitecCoreLicenseDialog;
import com.genuitec.eclipse.core.LicenseUtil;
import com.genuitec.eclipse.core.gsdc.GSDCController;
import com.genuitec.eclipse.core.portability.wizard.DialogField;
import com.genuitec.eclipse.core.portability.wizard.SimpleStringDialogField;
import com.genuitec.eclipse.core.ui.wizard.ActivationDialog;
import com.genuitec.eclipse.core.util.PlatformUtil;
import com.genuitec.eclipse.core.util.StatusInfo;
import com.genuitec.eclipse.core.vU;
import java.text.MessageFormat;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class UpdateLicenseDialog
extends GenuitecCoreLicenseDialog {
    private static final int F = 20;
    private boolean G;
    private Label D;
    private SimpleStringDialogField H;
    private SimpleStringDialogField I;
    private boolean E;
    private boolean J = true;
    private _A K;
    private Label C;

    public UpdateLicenseDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 8);
        this.G = GSDCController.getInstance().isActive();
    }

    @Override
    protected void setShellTitleMessage() {
        this.title = "Enter your license key";
    }

    @Override
    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.populateFields();
        this.dialogFieldChanged(null);
        return control;
    }

    @Override
    protected void createDetailsArea(Composite composite) {
        boolean bl = !PlatformUtil.isWebclipse();
        Label label = this.createWrappedLabel(composite);
        label.setText(this.getProductMessage("Enter or update your license subscription details to get the most from {0}.", bl));
        Composite composite2 = this.createGridLayoutComposite(composite, 2);
        GridData gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.verticalSpacing = 20;
        this.H = this.createStringDF("Your subscriber ID:", composite2, -1);
        this.setLabelStyle((Control)this.H.getLabelControl(null));
        this.I = this.createStringDF("Subscription code:", composite2, -1);
        this.setLabelStyle((Control)this.I.getLabelControl(null));
        if (this.G) {
            this.H.getTextControl(null).setEnabled(false);
            this.I.getTextControl(null).setEnabled(false);
        }
        label = new Label(composite2, 64);
        label.setText("Validation of License:");
        this.setLabelStyle((Control)label);
        this.D = new Label(composite2, 64);
        gridData = new GridData(768);
        this.D.setLayoutData((Object)gridData);
        this.setLabelStyle((Control)this.D);
        label = new Label(composite2, 64);
        label.setText("Activation Status:");
        this.setLabelStyle((Control)label);
        this.C = new Label(composite2, 64);
        gridData = new GridData(768);
        this.C.setLayoutData((Object)gridData);
        this.C.setText("N/A");
        this.setLabelStyle((Control)this.C);
    }

    protected void populateFields() {
        this.H.setTextWithoutUpdate(LicenseUtil.getCurrentLicensee());
        this.I.setTextWithoutUpdate(LicenseUtil.maskCode(LicenseUtil.getCurrentLicenseCode(), 4));
        this.K = new _A();
        this.H.getTextControl(null).addKeyListener((KeyListener)this.K);
        this.H.getTextControl(null).addMouseListener((MouseListener)this.K);
        this.I.getTextControl(null).addKeyListener((KeyListener)this.K);
        this.I.getTextControl(null).addMouseListener((MouseListener)this.K);
    }

    @Override
    protected void createLinks(Composite composite) {
        int n = 3;
        this.createHyperlink(composite, "Close", 18);
        this.createSpacer(composite);
        if (!this.G) {
            this.createHyperlink(composite, "Find Your Code", UpdateLicenseDialog.getFindCodeURL());
            ++n;
        }
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = n;
    }

    @Override
    protected Object[] getPrimaryButtonDetails() {
        return new Object[]{"Enable Now", 20};
    }

    @Override
    protected boolean validate(DialogField dialogField) {
        int n;
        String string;
        String string2;
        if (!this.J) {
            string2 = this.H.getText();
            string = this.I.getText();
        } else {
            string2 = LicenseUtil.getCurrentLicensee();
            string = LicenseUtil.getCurrentLicenseCode();
        }
        boolean bl = PlatformUtil.isNullOrEmpty((String)string2);
        boolean bl2 = PlatformUtil.isNullOrEmpty((String)string);
        int n2 = 1;
        if (bl || bl2) {
            if (PlatformUtil.isWebclipse() && bl && bl2) {
                long l = LicenseUtil.getDays();
                if (l < 8L) {
                    this.D.setText(MessageFormat.format("Free Mode: {0} {1} of {2} used this month", l, l > 1L ? "days" : "day", 8));
                } else {
                    this.D.setText("Free Mode: No more days left this month");
                }
            } else if (vU.TT__11232323lkjasdf() && bl && bl2) {
                this.D.setText(LicenseUtil.getShortLicenseDescription(string2, string));
            } else if (bl) {
                this.D.setText("Please provide your subscriber ID");
            } else {
                this.D.setText("Please provide your subscription code");
            }
            this.setLabelStyle((Control)this.D);
            n2 = 0;
        } else {
            StatusInfo statusInfo = LicenseUtil.validateSubscriptionKey(string2, string);
            n = statusInfo.getCode();
            if (n == 2) {
                this.D.setText("Invalid license, please double check your ID and code");
                this.setLabelStyleError((Control)this.D);
                n2 = 0;
            } else if (n == 5) {
                this.D.setText("License is not valid for this product");
                this.setLabelStyleError((Control)this.D);
                n2 = 0;
            } else {
                this.D.setText(LicenseUtil.getShortLicenseDescription(string2, string));
                if (n == 100) {
                    this.setLabelStyleWarning((Control)this.D);
                } else if (n == 3) {
                    this.setLabelStyleError((Control)this.D);
                    n2 = 0;
                } else {
                    this.setLabelStyleOK((Control)this.D);
                }
            }
        }
        boolean bl3 = this.A(string2, string);
        n = this.A(n2 != 0, bl3) ? 1 : 0;
        if (bl3) {
            this.primaryButton.setButtonText("Activate");
        } else {
            this.primaryButton.setButtonText("Enable Now");
        }
        return (bl3 ? n : n2) != 0;
    }

    private boolean A(boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (!bl) {
            this.C.setText("N/A");
            this.setLabelStyle((Control)this.C);
        } else if (bl2 && !LicenseUtil.isActivationRequired(false)) {
            this.C.setText("Product activated");
            this.setLabelStyleOK((Control)this.C);
        } else {
            int n = LicenseUtil.getActivationGracePeriodDaysLeft();
            this.C.setText(LicenseUtil.getActivationDescription(n));
            this.setLabelStyleError((Control)this.C);
            bl3 = true;
        }
        return bl3;
    }

    private boolean A(String string, String string2) {
        return string.trim().equals(LicenseUtil.getCurrentLicensee()) && string2.trim().equals(LicenseUtil.getCurrentLicenseCode());
    }

    protected void buttonPressed(int n) {
        this.setReturnCode(n);
        switch (n) {
            case 20: {
                this.close();
                if (this.isEditStarted()) {
                    LicenseUtil.storeKey(this.H.getText().trim(), this.I.getText().trim(), LicenseUtil.getCurrentActivationData());
                }
                ActivationDialog activationDialog = new ActivationDialog(this.getShell(), ActivationDialog.ActivationDialogMode.ACTIVATION_OPTIONS);
                activationDialog.open();
                break;
            }
            case 18: {
                this.close();
            }
        }
        super.buttonPressed(n);
    }

    public boolean isEditStarted() {
        return this.E;
    }

    public void setEditStarted(boolean bl) {
        if (this.E == bl) {
            return;
        }
        this.E = bl;
        if (this.E) {
            this.J = false;
            this.I.setText("");
        }
    }

    private class _A
    implements KeyListener,
    MouseListener {
        private _A() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (!UpdateLicenseDialog.this.isEditStarted()) {
                UpdateLicenseDialog.this.setEditStarted(true);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (!UpdateLicenseDialog.this.isEditStarted()) {
                UpdateLicenseDialog.this.setEditStarted(true);
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }
    }
}

