/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.wizard;

import com.genuitec.eclipse.core.LicenseUtil;
import com.genuitec.eclipse.core.URLMessageDialog;
import com.genuitec.eclipse.core.ViperCore;
import com.genuitec.eclipse.core.gsdc.GSDCController;
import com.genuitec.eclipse.core.portability.wizard.DialogField;
import com.genuitec.eclipse.core.portability.wizard.IDialogFieldListener;
import com.genuitec.eclipse.core.portability.wizard.SelectionButtonDialogFieldGroup;
import com.genuitec.eclipse.core.portability.wizard.Separator;
import com.genuitec.eclipse.core.portability.wizard.StatusInfo;
import com.genuitec.eclipse.core.ui.util.PlatformSWTUtil;
import com.genuitec.eclipse.core.ui.wizard.ActivationBaseWizardPage;
import com.genuitec.eclipse.core.ui.wizard.LicenseEnforcementWizard;
import com.genuitec.eclipse.core.util.PlatformUIUtil;
import com.genuitec.eclipse.core.util.PlatformUtil;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class MainActivationWizardPage
extends ActivationBaseWizardPage
implements IDialogFieldListener {
    public static final IStatus OK_STATUS = new StatusInfo();
    private static final String R = "LICENSE_WIZARDPAGE";
    private static final int S = 0;
    private static final int Q = 1;
    private static final int U = 2;
    private static final int P = 3;
    private SelectionButtonDialogFieldGroup T;

    public MainActivationWizardPage() {
        super(R);
        this.setTitle("Product Activation");
        this.setDescription("Choose your product activation method");
    }

    private String[] D() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (GSDCController.getInstance().isActive()) {
            arrayList.add("Automated activation using the configured Secure Delivery Center server");
            if (GSDCController.getInstance().isManualActivationAllowed()) {
                arrayList.add("Web activation (Information for your SDC server will be provided)");
                arrayList.add("I already have an activation code");
            }
        } else {
            arrayList.add("Automated activation (requires an Internet connection)");
            arrayList.add("Web activation (connect using your web browser)");
            arrayList.add("I already have an activation code");
        }
        if ((n = LicenseUtil.getActivationGracePeriodDaysLeft()) > 0) {
            arrayList.add("Not Now (" + n + " days remaining)");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void createControl(Composite composite) {
        Hyperlink hyperlink;
        GridData gridData;
        Label label;
        this.D();
        this.T = new SelectionButtonDialogFieldGroup(16, this.D(), 1);
        this.T.setSelection(0, true);
        this.T.setDialogFieldListener((IDialogFieldListener)this);
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        String string = LicenseUtil.getActivationDescription();
        if (!PlatformUtil.isNullOrEmpty((String)string)) {
            label = new Label(composite2, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 2;
            label.setLayoutData((Object)gridData);
            label.setText(string);
            if (LicenseUtil.getActivationGracePeriodDaysLeft() <= 5) {
                label.setForeground(PlatformSWTUtil.getSystemColor((int)3));
            }
            PlatformSWTUtil.createVerticalSpacer((Composite)composite2, (int)2);
        }
        label = new Label(composite2, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText("Choose activation method:");
        this.T.doFillIntoGrid(composite2, 2);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalIndent = 20;
        gridData.horizontalAlignment = 3;
        if (!GSDCController.getInstance().isActive()) {
            hyperlink = new Hyperlink(composite2, 0);
            hyperlink.setLayoutData((Object)gridData);
            hyperlink.setForeground(composite.getDisplay().getSystemColor(9));
            hyperlink.setText("Product Activation FAQ");
            hyperlink.setUnderlined(true);
            hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                    String string = "http://genuitec.com/mobile/activationfaq.html";
                    String string2 = "https://www.myeclipseide.com/licadmin/activationfaqs.php";
                    if (!PlatformUtil.isMobiOne()) {
                        if (!PlatformUIUtil.openLink((String)string2)) {
                            new URLMessageDialog(hyperlink.getShell(), ViperCore.getDefault().getResourceString("UpdateLicenseWizardPage_dialog_subscriptionlink_title"), ViperCore.getDefault().getResourceString("UpdateLicenseWizardPage_dialog_subscriptionlinkerror_message"), 2, string2).open();
                        }
                    } else if (!PlatformUIUtil.openLink((String)string)) {
                        new URLMessageDialog(hyperlink.getShell(), ViperCore.getDefault().getResourceString("MobiOne_UpdateLicenseWizardPage_dialog_subscriptionlink_title"), ViperCore.getDefault().getResourceString("MobiOne_UpdateLicenseWizardPage_dialog_subscriptionlinkerror_message"), 2, string).open();
                    }
                }
            });
        }
        hyperlink = new Button(composite2, 8);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        hyperlink.setLayoutData((Object)gridData2);
        hyperlink.setText("Configure Network Settings");
        hyperlink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUIUtil.getActiveShell(), (String)"org.eclipse.ui.net.NetPreferences", (String[])new String[]{"org.eclipse.ui.net.NetPreferences"}, null).open();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.setControl((Control)composite2);
        this.setPageComplete(true);
    }

    public boolean canFlipToNextPage() {
        return !this.C();
    }

    boolean G() {
        return this.T.isSelected(0);
    }

    boolean E() {
        return this.T.isSelected(1);
    }

    boolean F() {
        return this.T.isSelected(2);
    }

    boolean C() {
        return this.T.isSelected(3);
    }

    protected void createSeparator(Composite composite, int n) {
        new Separator(258).doFillIntoGrid(composite, n, this.convertHeightInCharsToPixels(1));
    }

    public void dialogFieldChanged(DialogField dialogField) {
        if (this.C()) {
            this.setPageComplete(true);
            ((LicenseEnforcementWizard)this.getWizard()).setCancelEnabled(false);
        } else {
            ((LicenseEnforcementWizard)this.getWizard()).setCancelEnabled(true);
        }
        this.getContainer().updateButtons();
    }
}

