/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.activation;

import com.genuitec.eclipse.core.GenuitecCoreLicenseDialog;
import com.genuitec.eclipse.core.LicenseUtil;
import com.genuitec.eclipse.core.ViperCore;
import com.genuitec.eclipse.core.activation.ProductActivator;
import com.genuitec.eclipse.core.gsdc.GSDCController;
import com.genuitec.eclipse.core.ui.util.SafeUIJob;
import com.genuitec.eclipse.core.ui.wizard.TransRegisterDialog;
import com.genuitec.eclipse.core.util.PlatformUIUtil;
import com.genuitec.eclipse.core.util.PlatformUtil;
import com.genuitec.eclipse.core.util.StatusInfo;
import com.genuitec.eclipse.core.vU;
import com.genuitec.pulse.client.trans.ui.DeliveryBrandingProvider;
import com.genuitec.pulse.client.trans.ui.IPopupButtonListener;
import com.genuitec.pulse.client.trans.ui.ITransDialogBrandingProvider;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class ProductRegistrar
extends ProductActivator {
    private static final String H = "EMAIL";
    private static final String N = "ID";
    private static final String O = "REGISTRATION_TIME";
    private static final String L = "DO_NOT_REGISTER";
    private static final String G = "REGISTRATION_SUCCESSFUL";
    private static final long K = 86400000L;
    private static final long J = 300000L;
    private String I;
    private String M;
    private String F;

    public ProductRegistrar(String string, String string2, String string3) {
        this.F = string;
        this.M = string3;
        this.I = "id=" + string + "&key=" + string2 + "&email=" + string3;
        this.I = String.valueOf(this.I) + "&version=" + PlatformUtil.getBundle((String)"com.genuitec.eclipse.core").getVersion();
    }

    public void setUpgradeTrialData(int n, int n2) {
        this.I = String.valueOf(this.I) + "&activatedTrials=" + n + "&requestedTrial=" + n2;
    }

    public void setNewTrialData(String string, String string2) {
        this.I = String.valueOf(this.I) + "&technology=" + string + "&foundUs=" + string2;
    }

    @Override
    protected String A() {
        return GenuitecCoreLicenseDialog.getRegistrationURL();
    }

    @Override
    protected String B(String string) {
        return MessageFormat.format(string, "Registration", "registration");
    }

    @Override
    protected void A(HttpURLConnection httpURLConnection) {
        super.A(httpURLConnection);
        try {
            httpURLConnection.setRequestMethod("POST");
        }
        catch (ProtocolException protocolException) {}
        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        httpURLConnection.setRequestProperty("charset", "utf-8");
        httpURLConnection.setRequestProperty("Content-Length", Integer.toString(this.I.getBytes().length));
        httpURLConnection.setDoOutput(true);
    }

    @Override
    protected IStatus A(URLConnection uRLConnection) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
            dataOutputStream.writeBytes(this.I);
            dataOutputStream.flush();
            dataOutputStream.close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string = bufferedReader.readLine();
            bufferedReader.close();
            if (this.M.equals(string.trim())) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
        }
        catch (Exception exception) {
            ViperCore.getDefault().log("Registration error", exception);
            StatusInfo statusInfo = new StatusInfo(4, "Network error - Error communicating with registration server.", 1);
            return statusInfo;
        }
        finally {
            ((HttpURLConnection)uRLConnection).disconnect();
        }
        return Status.CANCEL_STATUS;
    }

    public static IEclipsePreferences getPreferenceNode() {
        return ConfigurationScope.INSTANCE.getNode("com.genuitec.eclipse.core");
    }

    public static String getSavedEmail() {
        return ProductRegistrar.getPreferenceNode().get(H, null);
    }

    private static void A(String string, String string2, String string3, Integer n, Integer n2, String string4, String string5) {
        ProductRegistrar productRegistrar = new ProductRegistrar(string, string2, string3);
        if (n2 != null) {
            productRegistrar.setUpgradeTrialData(n, n2);
        }
        if (string4 != null) {
            productRegistrar.setNewTrialData(string4, string5);
        }
        _A _A2 = new _A(productRegistrar);
        _A2.schedule();
    }

    public static void doTrialRegistration(String string, String string2, String string3) {
        ProductRegistrar.doRegistration("SYSTEMID_" + LicenseUtil.getSystemId(), "N/A", string);
    }

    public static void doRegistration(String string, String string2, String string3, Integer n, Integer n2) {
        ProductRegistrar.A(string, string2, string3, n, n2, null, null);
    }

    public static void doRegistration(String string, String string2, String string3) {
        ProductRegistrar.A(string, string2, string3, null, null, null, null);
    }

    private static void B() {
        String string = LicenseUtil.getCurrentLicensee();
        String string2 = LicenseUtil.getCurrentLicenseCode();
        String string3 = ProductRegistrar.getSavedEmail();
        ProductRegistrar.doRegistration(string, string2, string3);
    }

    public static void showRegistrationPopupIfReq() {
        if (!GSDCController.getInstance().isActive() && !vU.TT__11232323lkjasdf()) {
            _B _B2 = new _B();
            _B2.schedule(300000L);
        }
    }

    public static boolean registrationValid(boolean bl) {
        IEclipsePreferences iEclipsePreferences = ProductRegistrar.getPreferenceNode();
        if (!bl) {
            String string = iEclipsePreferences.get(N, null);
            String string2 = LicenseUtil.getCurrentLicensee();
            return string2.equals(string);
        }
        String string = iEclipsePreferences.get(H, null);
        return string != null;
    }

    public static boolean needsRegistration() {
        boolean bl = vU.TT__11232323lkjasdf();
        IEclipsePreferences iEclipsePreferences = ProductRegistrar.getPreferenceNode();
        if (!bl ? iEclipsePreferences.getBoolean(L, false) || LicenseUtil.isActivationRequired(false) : PlatformUtil.isWebclipse()) {
            return false;
        }
        if (!ProductRegistrar.registrationValid(bl)) {
            return bl ? true : ProductRegistrar.C();
        }
        boolean bl2 = iEclipsePreferences.getBoolean(G, false);
        if (!bl2 && ProductRegistrar.C()) {
            ProductRegistrar.B();
        }
        return false;
    }

    private static boolean C() {
        IEclipsePreferences iEclipsePreferences = ProductRegistrar.getPreferenceNode();
        String string = iEclipsePreferences.get(O, null);
        if (string != null) {
            try {
                Date date = new Date(Long.parseLong(string));
                return new Date().after(date);
            }
            catch (NumberFormatException numberFormatException) {
                ViperCore.getDefault().log("Could not load registration time");
            }
        }
        return true;
    }

    public static void saveRegistrationTime(int n) {
        IEclipsePreferences iEclipsePreferences = ProductRegistrar.getPreferenceNode();
        long l = System.currentTimeMillis() + (long)n * 86400000L;
        iEclipsePreferences.put(O, new Long(l).toString());
        try {
            iEclipsePreferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            ViperCore.getDefault().log("Error saving registration time", backingStoreException);
        }
    }

    public void saveRegistration(boolean bl) {
        IEclipsePreferences iEclipsePreferences = ProductRegistrar.getPreferenceNode();
        iEclipsePreferences.put(N, this.F);
        iEclipsePreferences.put(H, this.M);
        iEclipsePreferences.put(G, Boolean.toString(bl));
        try {
            iEclipsePreferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            ViperCore.getDefault().log("Error saving registration information", backingStoreException);
        }
    }

    public static void setDoNotRegister() {
        IEclipsePreferences iEclipsePreferences = ProductRegistrar.getPreferenceNode();
        iEclipsePreferences.putBoolean(L, true);
        try {
            iEclipsePreferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            ViperCore.getDefault().log("Error setting do_not_register", backingStoreException);
        }
    }

    private static class _A
    extends Job {
        private ProductRegistrar A;

        public _A(ProductRegistrar productRegistrar) {
            super("Registering MyEclipse");
            this.A = productRegistrar;
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            IStatus iStatus = this.A.doAutoActivation("dummy", "dummy");
            this.A.saveRegistration(iStatus.isOK());
            if (!iStatus.isOK()) {
                ProductRegistrar.saveRegistrationTime(7);
            }
            return StatusInfo.OK_STATUS;
        }
    }

    private static class _B
    extends Job
    implements IPopupButtonListener {
        private TransRegisterDialog A;

        public _B() {
            super("Check registration");
            this.setSystem(true);
            this.setPriority(50);
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            if (ProductRegistrar.needsRegistration()) {
                String string = ProductRegistrar.getSavedEmail();
                boolean bl = !PlatformUtil.isWebclipse();
                this.A = new TransRegisterDialog((ITransDialogBrandingProvider)new DeliveryBrandingProvider(), PlatformUIUtil.getActiveShell(), MessageFormat.format("Complete {0} Activation", bl ? "MyEclipse" : "Webclipse"), MessageFormat.format("Register now to stay up to date on the latest news and {0} promotions.", bl ? "MyEclipse" : "Webclipse"), string, true, null);
                this.A.setButtonListener(this);
                SafeUIJob safeUIJob = new SafeUIJob("Registration"){

                    protected IStatus runSafelyInUIThread(IProgressMonitor iProgressMonitor) {
                        _B.this.A.open();
                        return StatusInfo.OK_STATUS;
                    }
                };
                safeUIJob.schedule();
            }
            return Status.OK_STATUS;
        }

        public void clicked(int n) {
            switch (n) {
                case 0: {
                    ProductRegistrar.setDoNotRegister();
                    break;
                }
                case 2: {
                    String string = LicenseUtil.getCurrentLicensee();
                    String string2 = LicenseUtil.getCurrentLicenseCode();
                    ProductRegistrar.doRegistration(string, string2, this.A.getEmail());
                    LicenseUtil.openThanksPage(LicenseUtil.ThanksAction.LICENSEREG, this.A.getEmail());
                }
                case 1: {
                    ProductRegistrar.saveRegistrationTime(10);
                }
            }
        }
    }
}

