/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAPublicKeyImpl;

public class RSAUtil {
    public static String encrypt(Key key, String string) throws Exception {
        return RSAUtil.rsaEncrypt(key, string);
    }

    public static String decrypt(Key key, String string) throws Exception {
        return RSAUtil.rsaDecrypt(key, string);
    }

    public static byte[] decrypt(Key key, byte[] byArray) throws Exception {
        return RSAUtil.rsaDecrypt(key, byArray);
    }

    public static KeyPair rsaCreateKeyPair() throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance("rsa").generateKeyPair();
    }

    public static String rsaDecrypt(Key key, String string) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, DecoderException {
        return new String(RSAUtil.rsaDecrypt(key, Hex.decodeHex((char[])string.toCharArray())));
    }

    public static byte[] rsaDecrypt(Key key, byte[] byArray) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, DecoderException {
        Cipher cipher = Cipher.getInstance("rsa");
        cipher.init(2, key);
        byte[] byArray2 = cipher.doFinal(byArray);
        return byArray2;
    }

    public static String rsaEncrypt(Key key, String string) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance("rsa");
        cipher.init(1, key);
        byte[] byArray = cipher.doFinal(string.getBytes());
        return new String(Hex.encodeHex((byte[])byArray));
    }

    public static Key rsaLoadBinaryPrivateKey(byte[] byArray) throws InvalidKeyException {
        return RSAPrivateCrtKeyImpl.newKey((byte[])byArray);
    }

    public static Key rsaLoadBinaryPrivateKey(File file) throws IOException, InvalidKeyException {
        byte[] byArray = RSAUtil.A(file);
        return RSAUtil.rsaLoadBinaryPrivateKey(byArray);
    }

    public static Key rsaLoadBinaryPublicKey(byte[] byArray) throws InvalidKeyException {
        return new RSAPublicKeyImpl(byArray);
    }

    public static Key rsaLoadBinaryPublicKey(File file) throws IOException, InvalidKeyException {
        byte[] byArray = RSAUtil.A(file);
        return RSAUtil.rsaLoadBinaryPublicKey(byArray);
    }

    public static Key rsaLoadHexEncodedPrivateKey(File file) throws IOException, DecoderException, InvalidKeyException {
        byte[] byArray = RSAUtil.B(file);
        return RSAPrivateCrtKeyImpl.newKey((byte[])byArray);
    }

    public static Key rsaLoadHexEncodedPrivateKey(String string) throws InvalidKeyException, DecoderException {
        return RSAPrivateCrtKeyImpl.newKey((byte[])Hex.decodeHex((char[])string.toCharArray()));
    }

    public static Key rsaLoadHexEncodedPublicKey(File file) throws IOException, DecoderException, InvalidKeyException {
        byte[] byArray = RSAUtil.B(file);
        return new RSAPublicKeyImpl(byArray);
    }

    public static Key rsaLoadHexEncodedPublicKey(String string) throws InvalidKeyException, DecoderException {
        return new RSAPublicKeyImpl(Hex.decodeHex((char[])string.toCharArray()));
    }

    public static void rsaStoreBinaryKey(File file, Key key) throws IOException {
        RSAUtil.A(file, key.getEncoded());
    }

    public static byte[] rsaStoreBinaryKey(Key key) {
        return key.getEncoded();
    }

    public static void rsaStoreHexEncodedKey(File file, Key key) throws IOException {
        RSAUtil.B(file, key.getEncoded());
    }

    public static String rsaStoreHexEncodedKey(Key key) {
        return new String(Hex.encodeHex((byte[])key.getEncoded()));
    }

    public static KeyStore rsaReadKeyStoreFile(File file, String string) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(new FileInputStream(file), string != null ? string.toCharArray() : null);
        return keyStore;
    }

    private static byte[] A(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        return byArray;
    }

    private static byte[] B(File file) throws IOException, DecoderException {
        byte[] byArray = RSAUtil.A(file);
        return Hex.decodeHex((char[])new String(byArray).toCharArray());
    }

    private static void A(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    private static void B(File file, byte[] byArray) throws IOException {
        RSAUtil.A(file, new String(Hex.encodeHex((byte[])byArray)).getBytes());
    }

    private RSAUtil() {
    }
}

