/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.facet.ui;

import com.genuitec.eclipse.j2eedt.facet.ui.FacetConfigurationControl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class FacetsConfigurationGroup {
    private String caption;
    private IDataModel model;
    private List<FacetConfigurationControl> controls;
    private IFacetedProjectWorkingCopy fpwc;
    private Set<IProjectFacetVersion> initialFacets;
    private Set<IProjectFacetVersion> facetsTmp;

    public FacetsConfigurationGroup(IDataModel model, IFacetedProjectWorkingCopy fpwc, String caption) {
        this.model = model;
        this.caption = caption;
        this.controls = new ArrayList<FacetConfigurationControl>();
        this.fpwc = fpwc;
        this.initialFacets = new HashSet<IProjectFacetVersion>();
        this.facetsTmp = new HashSet<IProjectFacetVersion>();
        if (fpwc.getFacetedProject() != null) {
            this.initialFacets.addAll(fpwc.getFacetedProject().getProjectFacets());
        }
    }

    public void addFacetControl(FacetConfigurationControl control) {
        this.controls.add(control);
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public Group createGroup(Composite parent, int colums) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false, colums, 1));
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 20;
        group.setLayout((Layout)gl);
        group.setText(this.caption);
        for (FacetConfigurationControl control : this.controls) {
            control.initialize(this, this.model);
            control.createControl((Composite)group);
        }
        this.refreshFacetConfiguration(null);
        return group;
    }

    void refreshFacetConfiguration(FacetConfigurationControl source) {
        this.facetsTmp.clear();
        this.facetsTmp.addAll(this.initialFacets);
        boolean refreshEnablement = source == null;
        for (FacetConfigurationControl control : this.controls) {
            if (refreshEnablement) {
                control.updateSelectionEnablement(this.facetsTmp);
            } else {
                refreshEnablement = control == source;
            }
            IProjectFacetVersion fv = control.getSelectedFacetVersion();
            if (fv == null) continue;
            this.facetsTmp.add(fv);
        }
        for (IProjectFacetVersion fv : this.facetsTmp) {
            if (!this.fpwc.hasProjectFacet(fv.getProjectFacet())) continue;
            this.fpwc.changeProjectFacetVersion(fv);
        }
        this.fpwc.setProjectFacets(this.facetsTmp);
    }
}

