/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.legacy.migration.internal.simple;

import com.genuitec.eclipse.core.util.InitException;
import com.genuitec.eclipse.core.util.Util;
import com.genuitec.eclipse.runtime.internal.RuntimeManagerImpl;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.legacy.migration.internal.simple.SimpleEASIEServerMigrationExtPointManager;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;

public class SimpleEASIEServerAbstractMigrationSpec {
    private static final String ATTR_HOME_PREF_KEY = "home-pref-key";
    private static final String ATTR_ID = "id";
    private static final String ATTR_EXTENDS = "extends";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DEFAULT = "default";
    private static final String EL_MIGRATE_PREF = "migrate-pref";
    private String id;
    private Map<String, String> prefsToMigrate;
    private String homePrefKey;
    private String extendedId;
    private SimpleEASIEServerAbstractMigrationSpec extended;

    public SimpleEASIEServerAbstractMigrationSpec(IConfigurationElement element) throws InitException {
        this.id = element.getAttribute(ATTR_ID);
        if (Util.isNullOrEmpty((String)this.id)) {
            RuntimeManagerImpl.reportMissingAttribute((IConfigurationElement)element, (String)ATTR_ID);
            throw new InitException();
        }
        this.extendedId = element.getAttribute(ATTR_EXTENDS);
        this.homePrefKey = element.getAttribute(ATTR_HOME_PREF_KEY);
        this.prefsToMigrate = new HashMap<String, String>();
        IConfigurationElement[] iConfigurationElementArray = element.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if (el.getName().equals(EL_MIGRATE_PREF)) {
                this.readMigratePref(el);
            }
            ++n2;
        }
    }

    private void readMigratePref(IConfigurationElement element) {
        String name = element.getAttribute(ATTR_NAME);
        if (Util.isNullOrEmpty((String)name)) {
            RuntimeManagerImpl.reportMissingAttribute((IConfigurationElement)element, (String)ATTR_NAME);
            return;
        }
        this.prefsToMigrate.put(name, element.getAttribute(ATTR_DEFAULT));
    }

    protected void init() {
        if (this.extendedId != null) {
            this.extended = SimpleEASIEServerMigrationExtPointManager.getAbstractServerMigrationSpec(this.extendedId);
            if (this.extended == null) {
                ServerCorePlugin.getDefault().log("Cannot find an abstract EASIE Server Migration Specification with id {0}.", new String[]{this.extendedId});
            } else if (!this.extended.isAbstract()) {
                ServerCorePlugin.getDefault().log("{0} cannot extend non-abstract EASIE Server Migration Specification with id {1}.", new String[]{this.getId(), this.extendedId});
                this.extended = null;
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isAbstract() {
        return true;
    }

    public String getHomePrefKey() {
        if (this.homePrefKey == null && this.extended != null) {
            return this.extended.getHomePrefKey();
        }
        return this.homePrefKey;
    }

    protected void fillPrefsToMigrate(Map<String, String> prefs) {
        if (this.extended != null) {
            this.extended.fillPrefsToMigrate(prefs);
        }
        prefs.putAll(this.prefsToMigrate);
    }
}

