/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.legacy.migration.internal;

import com.genuitec.eclipse.core.GenuitecCoreException;
import com.genuitec.eclipse.core.util.Util;
import com.genuitec.eclipse.core.util.XMLUtils;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Element;

public class EASIEServerDeployment {
    private static final String EL_DEPLOYMENTS = "deployments";
    private static final String EL_DEPLOYMENT = "deployment";
    private static final String ATTR_SERVER_ID = "server-id";
    private static final String ATTR_IS_PACKAGED = "is-packaged";
    private static final String ATTR_PROJECT_NAME = "project-name";
    private static final String ATTR_NO_FILE_COPY = "no-file-copy";
    private static final String ATTR_DEPLOYMENT_PATH = "deployment-path";
    private static final String ATTR_STATE = "state";
    private static final String PROP_NAME = "name";
    private static final String PROP_IS_DEPLOYED = "isDeployed";
    private static final String PROP_SERVER_ID = "serverId";
    private static final String PROP_IS_EXPLODED = "isExploded";
    private static final String PROP_NO_FILE_COPY = "noFileCopy";
    private static final String PROP_DEPLOYMENT_PATH = "deploymentPath";
    private static final String PROP_EAR_PROJ_NAME = "IEARProjectName";
    private static List<EASIEServerDeployment> deployments = new ArrayList<EASIEServerDeployment>();
    private IProject project;
    private boolean noFileCopy;
    private boolean isUndeployed;
    private boolean isExploded;
    private IPath deploymentPath;
    private String serverId;
    private String earDeployment;

    static {
        IPath path = InternalPlatform.getDefault().getMetaArea().getStateLocation("com.genuitec.eclipse.ast.deploy.core");
        File config = path.append("deployments.xml").toFile();
        if (config.exists()) {
            XMLUtils xu = new XMLUtils((Plugin)ServerCorePlugin.getDefault(), "Malformed deployments configuration file. ");
            try {
                Element root = xu.parse(config);
                xu.checkRootElement(root, EL_DEPLOYMENTS);
                for (Element el : xu.children(root)) {
                    if (!el.getNodeName().equals(EL_DEPLOYMENT)) continue;
                    try {
                        EASIEServerDeployment deployment = new EASIEServerDeployment(xu, el);
                        if ((deployment.getDeploymentPath() == null || !deployment.getDeploymentPathAsFile().exists()) && !deployment.noFileCopy() || deployment.isUndeployed()) continue;
                        deployments.add(deployment);
                    }
                    catch (GenuitecCoreException e) {
                        e.log();
                    }
                    catch (Exception e) {
                        new GenuitecCoreException((Plugin)ServerCorePlugin.getDefault(), (Throwable)e).log();
                    }
                }
            }
            catch (Exception e) {
                ServerCorePlugin.getDefault().log("Cannot load EASIE servers deployment", e);
            }
        } else {
            HashMap<String, Map<String, String>> servProj2depl = new HashMap<String, Map<String, String>>();
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.genuitec.eclipse.ast.deploy.core");
            try {
                String[] stringArray = prefs.keys();
                int e = stringArray.length;
                int n = 0;
                while (n < e) {
                    String key = stringArray[n];
                    int firstDot = key.indexOf(46);
                    if (firstDot >= 0) {
                        String serverId = key.substring(0, firstDot);
                        String temp = key.substring(firstDot + 1);
                        if ((firstDot = temp.lastIndexOf(46)) >= 0) {
                            String projectName = temp.substring(0, firstDot);
                            String property = temp.substring(firstDot + 1);
                            EASIEServerDeployment.addProperty(servProj2depl, serverId, projectName, property, prefs.get(key, null));
                        }
                    }
                    ++n;
                }
                for (Map depl : servProj2depl.values()) {
                    try {
                        EASIEServerDeployment deployment = new EASIEServerDeployment(depl);
                        if ((deployment.isEARDeployment() || deployment.getDeploymentPath() == null || !deployment.getDeploymentPathAsFile().exists()) && !deployment.noFileCopy() || deployment.isUndeployed()) continue;
                        deployments.add(deployment);
                    }
                    catch (Exception e2) {
                        new GenuitecCoreException((Plugin)ServerCorePlugin.getDefault(), (Throwable)e2).log();
                    }
                }
            }
            catch (BackingStoreException e) {
                ServerCorePlugin.getDefault().log("Cannot load EASIE servers deployment", e);
            }
        }
    }

    public EASIEServerDeployment(XMLUtils xu, Element element) throws GenuitecCoreException {
        String name = xu.getAttribute(element, ATTR_PROJECT_NAME);
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        this.noFileCopy = Boolean.parseBoolean(element.getAttribute(ATTR_NO_FILE_COPY));
        this.serverId = xu.getAttribute(element, ATTR_SERVER_ID);
        this.isExploded = !Boolean.parseBoolean(element.getAttribute(ATTR_IS_PACKAGED));
        this.deploymentPath = new Path(xu.getAttribute(element, ATTR_DEPLOYMENT_PATH));
        if (!Util.isNullOrEmpty((String)element.getAttribute(ATTR_STATE))) {
            this.isUndeployed = xu.getAttribute(element, ATTR_STATE).equals("UNDEPLOYED");
        }
    }

    public EASIEServerDeployment(Map<String, String> properties) {
        int firstDot;
        String name = properties.get(PROP_NAME);
        if (name.startsWith("wasid_") && (firstDot = name.indexOf(46)) > 0) {
            name = name.substring(firstDot + 1);
        }
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        this.noFileCopy = Boolean.parseBoolean(properties.get(PROP_NO_FILE_COPY));
        this.serverId = properties.get(PROP_SERVER_ID);
        this.isExploded = Boolean.parseBoolean(properties.get(PROP_IS_EXPLODED));
        this.deploymentPath = new Path(properties.get(PROP_DEPLOYMENT_PATH));
        this.isUndeployed = !Boolean.parseBoolean(properties.get(PROP_IS_DEPLOYED));
        this.earDeployment = properties.get(PROP_EAR_PROJ_NAME);
    }

    public String getServerId() {
        return this.serverId;
    }

    private boolean isUndeployed() {
        return this.isUndeployed;
    }

    private boolean noFileCopy() {
        return this.noFileCopy;
    }

    private File getDeploymentPathAsFile() {
        return this.deploymentPath != null ? this.deploymentPath.toFile() : null;
    }

    private IPath getDeploymentPath() {
        return this.deploymentPath;
    }

    private boolean isEARDeployment() {
        return !Util.isNullOrEmpty((String)this.earDeployment);
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean isPackaged() {
        return !this.isExploded;
    }

    public static List<EASIEServerDeployment> getDeployments(String easieServerId) throws GenuitecCoreException {
        ArrayList<EASIEServerDeployment> result = new ArrayList<EASIEServerDeployment>();
        for (EASIEServerDeployment deployment : deployments) {
            if (!easieServerId.equals(deployment.getServerId())) continue;
            result.add(deployment);
        }
        return result;
    }

    private static void addProperty(Map<String, Map<String, String>> servProj2depl, String serverId, String projectName, String property, String value) {
        Map<String, String> deployment = servProj2depl.get(String.valueOf(serverId) + "." + projectName);
        if (deployment == null) {
            deployment = new HashMap<String, String>();
            deployment.put(PROP_SERVER_ID, serverId);
            deployment.put(PROP_NAME, projectName);
            servProj2depl.put(String.valueOf(serverId) + "." + projectName, deployment);
        }
        deployment.put(property, value);
    }
}

