/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.legacy;

import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.legacy.LegacyGenuitecServer;
import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;

public class ParameterizedArgument {
    public static final int STATIC_IS_FIRST = 0;
    public static final int PARAM_IS_FIRST = 1;
    private String staticPortion;
    private String preferenceKey;
    private boolean staticIsFirst;
    private boolean isPath;

    public ParameterizedArgument(String theStaticPortion, String thePreferenceKey, int theOrder, boolean isPathFlag) {
        this.staticPortion = theStaticPortion != null ? theStaticPortion : "";
        this.preferenceKey = thePreferenceKey != null ? thePreferenceKey : "";
        this.staticIsFirst = theOrder == 0;
        this.isPath = isPathFlag;
    }

    public ParameterizedArgument(String theStaticPortion, String thePreferenceKey, int theOrder) {
        this(theStaticPortion, thePreferenceKey, theOrder, false);
    }

    public String getParameterString(LegacyGenuitecServer server) {
        String thePrefKey = this.preferenceKey;
        if (thePrefKey.length() == 0) {
            return this.staticPortion;
        }
        String preferenceValue = server.getServerAttribute(thePrefKey);
        if (preferenceValue == null) {
            return null;
        }
        if ((preferenceValue = preferenceValue.trim()).length() == 0) {
            return null;
        }
        return this.staticIsFirst ? String.valueOf(this.staticPortion) + preferenceValue : String.valueOf(preferenceValue) + this.staticPortion;
    }

    public boolean isPath() {
        return this.isPath;
    }

    public static String[] convertToStringArray(ParameterizedArgument[] theArguments, LegacyGenuitecServer server) {
        try {
            StringBuffer buf = new StringBuffer(128);
            int i = 0;
            int max = theArguments.length;
            while (i < max) {
                if (theArguments[i] != null) {
                    String paramString = theArguments[i].getParameterString(server);
                    if (theArguments[i].isPath() && paramString != null) {
                        StringTokenizer toker = new StringTokenizer(paramString, ";");
                        while (toker.hasMoreTokens()) {
                            paramString = toker.nextToken();
                            if (paramString.endsWith("*.jar")) {
                                ParameterizedArgument.createJarEntries(paramString, buf);
                                continue;
                            }
                            buf.append('\"');
                            buf.append(paramString);
                            buf.append('\"');
                            buf.append(' ');
                        }
                    } else if (paramString != null) {
                        paramString = paramString.replace('\'', '\"');
                        buf.append(paramString);
                        buf.append(' ');
                    }
                }
                ++i;
            }
            try {
                return DebugPlugin.parseArguments((String)VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(buf.toString().trim(), false));
            }
            catch (Exception e) {
                ServerCorePlugin.getDefault().log("Error while processing program arguments.", e);
                return DebugPlugin.parseArguments((String)buf.toString().trim());
            }
        }
        catch (Exception e) {
            ServerCorePlugin.getDefault().log(e);
            return null;
        }
    }

    protected static void createJarEntries(String paramString, StringBuffer buf) {
        File file = new File(paramString = paramString.replace("*.jar", ""));
        if (file != null && file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File jarFile = fileArray[n2];
                if (jarFile.exists() && jarFile.isFile() && jarFile.getPath().endsWith(".jar")) {
                    buf.append('\"');
                    buf.append(jarFile.toString());
                    buf.append('\"');
                    buf.append(' ');
                }
                ++n2;
            }
        }
    }

    private static String[] processEnspacedArgumentString(String theArgument) {
        if (theArgument == null || theArgument.length() == 0 || theArgument.trim().length() == 0) {
            return new String[0];
        }
        char[] arg = theArgument.trim().toCharArray();
        boolean[] breakAt = new boolean[arg.length];
        int numBreaks = 0;
        boolean insideDblQuote = false;
        boolean insideSglQuote = false;
        int i = 0;
        int max = arg.length;
        while (i < max) {
            if (arg[i] == '\'') {
                insideSglQuote = !insideSglQuote;
            } else if (arg[i] == '\"') {
                insideDblQuote = !insideDblQuote;
                arg[i] = 39;
            } else if (arg[i] == ' ' && !insideSglQuote && !insideDblQuote) {
                breakAt[i] = true;
                ++numBreaks;
            }
            ++i;
        }
        String[] retArray = new String[numBreaks + 1];
        int subStartIndex = 0;
        int subEndIndex = 0;
        int charIndex = 0;
        int retIndex = 0;
        int charMax = breakAt.length;
        while (charIndex < charMax) {
            if (breakAt[charIndex]) {
                subEndIndex = charIndex;
                retArray[retIndex++] = new String(arg, subStartIndex, subEndIndex - subStartIndex);
                subStartIndex = subEndIndex + 1;
            }
            ++charIndex;
        }
        retArray[retArray.length - 1] = new String(arg, subStartIndex, breakAt.length - subStartIndex);
        return retArray;
    }

    public String getStaticPortion() {
        return this.staticPortion;
    }

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public boolean isStaticIsFirst() {
        return this.staticIsFirst;
    }
}

