/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.deployment;

import com.genuitec.eclipse.core.GenuitecCoreException;
import com.genuitec.eclipse.j2eedt.core.IJEEProject;
import com.genuitec.eclipse.j2eedt.core.JEEProjectManager;
import com.genuitec.eclipse.server.core.GenuitecAppServerBehaviour;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.deployment.DeploymentUtils;
import com.genuitec.eclipse.server.core.deployment.IDeploymentProcessorFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyComponent;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyProvider;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IPublishedModuleDeployment;
import org.eclipse.wst.server.core.model.ModulePublishState;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.ModuleFile;
import org.eclipse.wst.web.internal.deployables.FlatComponentDeployable;

public abstract class AbstractDeploymentProcessor {
    protected final IDeploymentProcessorFactory factory;
    protected final IPublishedModuleDeployment deployment;
    protected final IVirtualComponent component;
    protected final MultiStatus status;
    protected final J2EEFlexProjDeployable deployable;
    protected final IJEEProject project;
    protected final GenuitecAppServerBehaviour server;
    protected final List<IVirtualComponent> componentsArchived = new ArrayList<IVirtualComponent>();

    public AbstractDeploymentProcessor(IDeploymentProcessorFactory factory, IPublishedModuleDeployment deployment, MultiStatus status) throws GenuitecCoreException {
        this.factory = factory;
        this.deployment = deployment;
        this.deployable = (J2EEFlexProjDeployable)deployment.getModule().loadAdapter(J2EEFlexProjDeployable.class, null);
        if (this.deployable == null) {
            throw new GenuitecCoreException("Cannot acquire J2EEFlexProjDeployable object for module {0}", (Plugin)ServerCorePlugin.getDefault(), new String[]{deployment.toString()});
        }
        this.project = JEEProjectManager.create((IProject)deployment.getProject());
        this.status = status;
        this.component = this.deployable.getComponent();
        this.server = (GenuitecAppServerBehaviour)deployment.getServer().loadAdapter(ServerBehaviourDelegate.class, null);
    }

    public final void setArchivedComponents(List<IVirtualComponent> componentList) {
        this.componentsArchived.addAll(componentList);
    }

    protected void updateLocationForBrowse() {
        this.deployment.setAttribute("location-browse", DeploymentUtils.getModuleDeploymentPhysicalLocation(this.deployment).toString());
    }

    protected final IVirtualComponent getComponent(IPublishedModuleDeployment deployment) {
        J2EEFlexProjDeployable deployable = (J2EEFlexProjDeployable)deployment.getModule().loadAdapter(J2EEFlexProjDeployable.class, null);
        if (deployable == null) {
            return null;
        }
        return deployable.getComponent();
    }

    public void processDeployment(SubMonitor monitor) {
        try {
            this.internalProcess(monitor);
            this.deployment.setModulePublishState(ModulePublishState.PUBLISH_STATE_NONE);
            this.deployment.setModuleStatus(null);
        }
        catch (Exception e) {
            MultiStatus status = new MultiStatus(this.server.getServer().getName(), 0, new IStatus[]{new Status(4, this.server.getServer().getName(), e.getMessage(), (Throwable)e)}, "Deployment failed", null);
            this.deployment.setModulePublishState(ModulePublishState.PUBLISH_STATE_FULL);
            this.deployment.setModuleStatus((IStatus)status);
            ServerCorePlugin.getDefault().log((IStatus)status);
        }
    }

    protected void setCustomFlatteningProperty(String key, String value) {
        this.deployable.setCustomFlatteningProperty(key, value);
        this.deployment.clearCache();
    }

    protected boolean acceptChild(IPublishedModuleDeployment childDeployment, SubMonitor monitor) {
        IVirtualComponent component;
        FlatComponentDeployable deployable = (FlatComponentDeployable)childDeployment.getModule().loadAdapter(FlatComponentDeployable.class, (IProgressMonitor)monitor);
        IVirtualComponent iVirtualComponent = component = deployable != null ? deployable.getComponent() : null;
        if (component instanceof IClasspathDependencyComponent || component instanceof VirtualArchiveComponent) {
            try {
                File f = (File)component.getAdapter(File.class);
                Path path = new Path(this.deployable.getPath(childDeployment.getModule()));
                this.handleJarModule(childDeployment, (IModuleFile)new ModuleFile(f, path.lastSegment(), path.removeLastSegments(1)), monitor);
                childDeployment.setLocation(path.toString());
                childDeployment.storeDeployMode();
                childDeployment.setModulePublishState(ModulePublishState.PUBLISH_STATE_NONE);
                childDeployment.setModuleStatus(null);
            }
            catch (GenuitecCoreException ex) {
                childDeployment.setModulePublishState(ModulePublishState.PUBLISH_STATE_FULL);
                MultiStatus status = new MultiStatus(this.server.getServer().getName(), 0, new IStatus[]{ex.getStatus()}, "Deployment failed", null);
                childDeployment.setModuleStatus((IStatus)status);
            }
            catch (Exception e) {
                childDeployment.setModulePublishState(ModulePublishState.PUBLISH_STATE_FULL);
                MultiStatus status = new MultiStatus(this.server.getServer().getName(), 0, new IStatus[]{new Status(4, this.server.getServer().getName(), e.getMessage(), (Throwable)e)}, "Deployment failed", null);
                childDeployment.setModuleStatus((IStatus)status);
            }
            return false;
        }
        if (component != null && !(component instanceof IClasspathDependencyProvider)) {
            childDeployment.setModuleStatus((IStatus)new Status(4, this.server.getServer().getServerType().getId(), "Unsupported module"));
            childDeployment.setModulePublishState(ModulePublishState.PUBLISH_STATE_FULL);
            return false;
        }
        return true;
    }

    protected abstract void internalProcess(SubMonitor var1) throws Exception;

    protected abstract void handleJarModule(IPublishedModuleDeployment var1, IModuleFile var2, SubMonitor var3) throws GenuitecCoreException;
}

