/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.console;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;

public class TailLogMonitor
implements IStreamMonitor {
    private static final int SLEEP = 50;
    private File logFile;
    private boolean shouldContinue = true;
    private static final int WRITE_COUNT = 20;
    private ListenerList fListeners = new ListenerList();
    private Thread fThread;

    public TailLogMonitor(File logFile) {
        this.logFile = logFile;
    }

    public void addListener(IStreamListener listener) {
        this.fListeners.add((Object)listener);
    }

    public String getContents() {
        return "";
    }

    public void removeListener(IStreamListener listener) {
        this.fListeners.remove((Object)listener);
    }

    private void read() {
        long fileLength = this.logFile.exists() ? this.logFile.length() : 0L;
        while (!this.logFile.exists() && this.shouldContinue) {
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.shouldContinue) {
            return;
        }
        RandomAccessFile raFile = this.openFileAtTail(this.logFile, fileLength);
        while (this.shouldContinue) {
            try {
                long currentLength = this.logFile.length();
                if (currentLength < fileLength) {
                    this.closeFile(raFile);
                    raFile = this.openFileAtStart(this.logFile);
                }
                fileLength = currentLength;
                this.readFileAndWrite(raFile);
            }
            catch (IOException iOException) {}
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.closeFile(raFile);
    }

    private void closeFile(RandomAccessFile raFile) {
        try {
            raFile.close();
        }
        catch (IOException iOException) {}
    }

    private int readFileAndWrite(RandomAccessFile raFile) throws IOException {
        int writes = 0;
        byte[] read = this.readFromFile(raFile);
        while (read != null && writes < 20) {
            if (read.length > 0) {
                this.fireStreamAppended(new String(read));
            }
            ++writes;
            read = this.readFromFile(raFile);
        }
        return writes;
    }

    private byte[] readFromFile(RandomAccessFile raFile) {
        long readAmount;
        block3: {
            try {
                long currentPos = raFile.getFilePointer();
                long remaining = raFile.length() - currentPos;
                readAmount = Math.min(remaining, 16384L);
                if (remaining >= 0L) break block3;
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        byte[] buffer = new byte[(int)readAmount];
        raFile.read(buffer);
        return buffer;
    }

    private RandomAccessFile openFileAtTail(File logFile, long length) {
        try {
            RandomAccessFile raFile = new RandomAccessFile(logFile, "r");
            if (length <= raFile.length()) {
                raFile.seek(length);
            } else {
                raFile.seek(raFile.length());
            }
            return raFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    private RandomAccessFile openFileAtStart(File logFile) {
        try {
            RandomAccessFile raFile = new RandomAccessFile(logFile, "r");
            return raFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    protected void startMonitoring() {
        if (this.fThread == null) {
            this.fThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    TailLogMonitor.this.read();
                }
            }, "Tail log monitor thread");
            this.fThread.setDaemon(true);
            this.fThread.setPriority(1);
            this.fThread.start();
        }
    }

    protected void close() {
        if (this.fThread != null) {
            Thread thread = this.fThread;
            this.shouldContinue = false;
            this.fThread = null;
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.fListeners = new ListenerList();
        }
    }

    private void fireStreamAppended(String text) {
        this.getNotifier().notifyAppend(text);
    }

    private ContentNotifier getNotifier() {
        return new ContentNotifier();
    }

    class ContentNotifier
    implements ISafeRunnable {
        private IStreamListener fListener;
        private String fText;

        ContentNotifier() {
        }

        public void handleException(Throwable exception) {
            DebugPlugin.log((Throwable)exception);
        }

        public void run() throws Exception {
            this.fListener.streamAppended(this.fText, (IStreamMonitor)TailLogMonitor.this);
        }

        public void notifyAppend(String text) {
            if (text == null) {
                return;
            }
            this.fText = text;
            Object[] copiedListeners = TailLogMonitor.this.fListeners.getListeners();
            int i = 0;
            while (i < copiedListeners.length) {
                this.fListener = (IStreamListener)copiedListeners[i];
                SafeRunner.run((ISafeRunnable)this);
                ++i;
            }
            this.fListener = null;
            this.fText = null;
        }
    }
}

