/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core;

import com.genuitec.eclipse.core.util.Util;
import com.genuitec.eclipse.server.core.CustomConsoleDelegation;
import com.genuitec.eclipse.server.core.IGenuitecServer;
import com.genuitec.eclipse.server.core.IGenuitecServerLaunchConfig;
import com.genuitec.eclipse.server.core.IGenuitecServerLaunchConfigProvider;
import com.genuitec.eclipse.server.core.IPingThread;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.internal.EnvVarsMerger;
import com.genuitec.eclipse.server.core.internal.LaunchConfigCustomizersManager;
import com.genuitec.eclipse.server.core.internal.ProgramArgumentMerger;
import com.genuitec.eclipse.server.core.internal.VMArgumentMerger;
import com.genuitec.eclipse.server.core.legacy.JavaVMUtility;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.SocketUtil;

public abstract class GenuitecServerBehaviour
extends ServerBehaviourDelegate
implements IGenuitecServerLaunchConfigProvider {
    private transient ServerProcessListener processListener = new ServerProcessListener();
    private transient IPingThread ping = null;
    protected IGenuitecServerLaunchConfig startConfig;
    protected IGenuitecServerLaunchConfig stopConfig;

    protected void initialize(IProgressMonitor monitor) {
        super.initialize(monitor);
        this.startConfig = this.createServerLaunchConfig(false);
        this.stopConfig = this.createServerLaunchConfig(true);
    }

    protected abstract IGenuitecServerLaunchConfig createServerLaunchConfig(boolean var1);

    @Override
    public final IGenuitecServerLaunchConfig getServerLaunchConfig(boolean isShutdown) {
        return isShutdown ? this.stopConfig : this.startConfig;
    }

    @Override
    public final IGenuitecServerLaunchConfig getServerLaunchConfig(ILaunchConfiguration launchConfig) {
        try {
            return LaunchConfigCustomizersManager.customizeConfig(this.getGenuitecServer(), this.getServerLaunchConfig(launchConfig.getAttribute("IGenuitecServerLaunchConfigProvider.ATTR_SERVER_SHUTDOWN", false)));
        }
        catch (CoreException e) {
            ServerCorePlugin.getDefault().log(e);
            return null;
        }
    }

    protected IPath getTempDirectory() {
        return super.getTempDirectory(false);
    }

    public String toString() {
        return String.valueOf(this.getClass().toString()) + "[" + this.getServer().getId() + "]";
    }

    public IGenuitecServer getGenuitecServer() {
        return (IGenuitecServer)this.getServer().loadAdapter(IGenuitecServer.class, null);
    }

    protected void validateSetup() throws CoreException {
        IStatus[] statuses = this.getGenuitecServer().validate();
        if (statuses != null && Util.findMostSevere((IStatus[])statuses).getSeverity() >= 4) {
            throw new CoreException((IStatus)new MultiStatus("com.genuitec.eclipse.server.core", 0, statuses, "Error in server connector configuration", null));
        }
    }

    public IStatus canRestart(String mode) {
        return this.canStart(mode);
    }

    public void stop(boolean force) {
        if (force) {
            this.terminate();
            return;
        }
        int state = this.getServer().getServerState();
        if (state == 4 || state == 3) {
            return;
        }
        if (state == 1) {
            this.terminate();
            return;
        }
        try {
            this.internalStop();
        }
        catch (CoreException e) {
            ServerCorePlugin.getDefault().log("Error stopping {0} server process", e, new String[]{this.getServer().getName()});
            this.terminate();
        }
    }

    protected IPingThread createPingThread() {
        this.setServerState(2);
        return new IPingThread(){

            @Override
            public void stop() {
            }
        };
    }

    protected void setupLaunch(ILaunch launch, String launchMode, IProgressMonitor monitor) throws CoreException {
        if (launch.getLaunchConfiguration().getAttribute("IGenuitecServerLaunchConfigProvider.ATTR_SERVER_SHUTDOWN", false)) {
            return;
        }
        this.validateSetup();
        ArrayList<ServerPort> usedPorts = new ArrayList<ServerPort>();
        ServerPort[] ports = this.getServer().getServerPorts(null);
        if (ports != null) {
            ServerPort[] serverPortArray = ports;
            int n = ports.length;
            int n2 = 0;
            while (n2 < n) {
                ServerPort sp = serverPortArray[n2];
                if (sp.getPort() < 0) {
                    throw new CoreException(ServerCorePlugin.createErrorStatus("The server cannot be started because one or more of the ports are invalid. Open the server editor and correct the invalid ports.", new Object[0]));
                }
                if (SocketUtil.isPortInUse((int)sp.getPort(), (int)5)) {
                    usedPorts.add(sp);
                }
                ++n2;
            }
        }
        if (usedPorts.size() == 1) {
            ServerPort port = (ServerPort)usedPorts.get(0);
            throw new CoreException(ServerCorePlugin.createErrorStatus("Port {0} required by {1} is already in use. The server may already be running in another process, or a system process may be using the port. To start this server you will need to stop the other process or change the port number(s).", port.getPort(), this.getServer().getName()));
        }
        if (usedPorts.size() > 1) {
            String portStr = "";
            boolean first = true;
            for (ServerPort sp : usedPorts) {
                if (!first) {
                    portStr = String.valueOf(portStr) + ", ";
                }
                first = false;
                portStr = String.valueOf(portStr) + Integer.toString(sp.getPort());
            }
            throw new CoreException(ServerCorePlugin.createErrorStatus("Several ports ({0}) required by {1} are already in use. The server may already be running in another process, or a system process may be using the port. To start this server you will need to stop the other process or change the port number(s).", portStr, this.getServer().getName()));
        }
    }

    protected String getModeForVMRunner(String mode) {
        return mode;
    }

    public void launchAboutToRun(ILaunch launch, String launchMode, IProgressMonitor monitor) throws CoreException {
        if (launch.getLaunchConfiguration().getAttribute("IGenuitecServerLaunchConfigProvider.ATTR_SERVER_SHUTDOWN", false)) {
            this.setServerState(3);
        } else {
            this.setServerRestartState(false);
            this.setServerState(1);
            this.setMode(launchMode);
            try {
                this.ping = this.createPingThread();
            }
            catch (Exception exception) {
                ServerCorePlugin.getDefault().log("Can't ping for {0} startup.", new String[]{this.getServer().getName()});
            }
        }
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        super.setupLaunchConfiguration(workingCopy, monitor);
        IGenuitecServerLaunchConfig launchConfig = this.getServerLaunchConfig((ILaunchConfiguration)workingCopy);
        CustomConsoleDelegation.setupLaunchConfiguration(this.getServer(), workingCopy);
        String savedProgArgs = workingCopy.getAttribute("IGenuitecServerLaunchConfigProvider.ATTR_DEFAULT_PROG_ARGS", null);
        String curProgArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
        String newProgArgs = JavaVMUtility.stringArrayToString((String[])launchConfig.getLaunchProgramArguments());
        if (savedProgArgs == null || curProgArgs == null || savedProgArgs.equals(curProgArgs)) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, newProgArgs);
        } else if (!savedProgArgs.equals(newProgArgs)) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, new ProgramArgumentMerger(savedProgArgs, curProgArgs, newProgArgs).merge());
        }
        workingCopy.setAttribute("IGenuitecServerLaunchConfigProvider.ATTR_DEFAULT_PROG_ARGS", newProgArgs);
        String savedVMArgs = workingCopy.getAttribute("IGenuitecServerLaunchConfigProvider.ATTR_DEFAULT_VM_ARGS", null);
        String curVMArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
        String newVMArgs = JavaVMUtility.stringArrayToString((String[])launchConfig.getLaunchVMArguments());
        if (savedVMArgs == null || curVMArgs == null || savedVMArgs.equals(curVMArgs)) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, newVMArgs);
        } else if (!savedVMArgs.equals(newVMArgs)) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, new VMArgumentMerger(savedVMArgs, curVMArgs, newVMArgs).merge());
        }
        workingCopy.setAttribute("IGenuitecServerLaunchConfigProvider.ATTR_DEFAULT_VM_ARGS", newVMArgs);
        IVMInstall vmInstall = launchConfig.getLaunchVMInstall();
        if (vmInstall != null) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, JavaRuntime.newJREContainerPath((IVMInstall)vmInstall).toPortableString());
        }
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "com.genuitec.server.classpathProvider");
        Map savedEnvVars = workingCopy.getAttribute("IGenuitecServerLaunchConfigProvider.ATTR_DEFAULT_ENV_VARS", null);
        Map curEnvVars = workingCopy.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
        Map<String, String> newEnvVars = launchConfig.getEnvironmentVars();
        if (savedEnvVars != null || newEnvVars != null) {
            workingCopy.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new EnvVarsMerger(savedEnvVars, curEnvVars, newEnvVars).merge());
        }
        workingCopy.setAttribute("IGenuitecServerLaunchConfigProvider.ATTR_DEFAULT_ENV_VARS", newEnvVars);
        if (!workingCopy.hasAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES)) {
            workingCopy.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, !launchConfig.shouldReplaceSystemEnvVars());
        }
    }

    protected ILaunch internalStop() throws CoreException {
        ILaunchConfigurationType launchConfigType = ((ServerType)this.getServer().getServerType()).getLaunchConfigurationType();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        String launchName = launchManager.generateLaunchConfigurationName(MessageFormat.format("Stopping {0}", this.getServer().getName()));
        ILaunchConfigurationWorkingCopy wc = launchConfigType.newInstance(null, launchName);
        wc.setAttribute("server-id", this.getServer().getId());
        wc.setAttribute("IGenuitecServerLaunchConfigProvider.ATTR_SERVER_SHUTDOWN", true);
        this.setupLaunchConfiguration(wc, (IProgressMonitor)new NullProgressMonitor());
        ILaunch launch = wc.launch("run", (IProgressMonitor)new NullProgressMonitor());
        if (launch != null) {
            JavaVMUtility.showInDebugger((ILaunch)launch);
        }
        return launch;
    }

    protected void terminate() {
        if (this.getServer().getServerState() == 4) {
            return;
        }
        try {
            this.setServerState(3);
            ILaunch launch = this.getServer().getLaunch();
            if (launch != null) {
                launch.terminate();
                this.startupLaunchFinished();
            }
        }
        catch (Exception e) {
            ServerCorePlugin.getDefault().log("Error killing {0} server process", e, new String[]{this.getServer().getName()});
        }
    }

    protected synchronized void startupLaunchFinished() {
        if (this.ping != null) {
            this.ping.stop();
            this.ping = null;
        }
        this.setServerState(4);
    }

    protected synchronized void shutdownLaunchFinished() {
        new Job("Stop server"){
            int count;
            {
                this.count = 0;
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (this.count++ >= 20) {
                    if (GenuitecServerBehaviour.this.getServer().getServerState() == 3) {
                        GenuitecServerBehaviour.this.setServerState(2);
                    }
                } else if (GenuitecServerBehaviour.this.getServer().getServerState() != 4) {
                    this.schedule(1000L);
                }
                return Status.OK_STATUS;
            }
        }.schedule(1000L);
    }

    public void setServerProcess(IProcess process, ILaunchConfiguration config) {
        try {
            if (config.getAttribute("IGenuitecServerLaunchConfigProvider.ATTR_SERVER_SHUTDOWN", false)) {
                this.processListener.setShutdownProcess(process);
                return;
            }
        }
        catch (CoreException e) {
            ServerCorePlugin.getDefault().log(e);
        }
        this.processListener.setServerProcess(process);
    }

    private class ServerProcessListener
    implements IDebugEventSetListener {
        private IProcess serverProcess;
        private IProcess shutdownProcess;

        private ServerProcessListener() {
        }

        public void handleDebugEvents(DebugEvent[] events) {
            if (events != null) {
                int size = events.length;
                int i = 0;
                while (i < size) {
                    if (events[i].getKind() == 8) {
                        if (this.serverProcess != null && this.serverProcess.equals(events[i].getSource())) {
                            this.serverProcess = null;
                            this.deregisterIfNeeded();
                            GenuitecServerBehaviour.this.startupLaunchFinished();
                        } else if (this.shutdownProcess != null && this.shutdownProcess.equals(events[i].getSource())) {
                            this.shutdownProcess = null;
                            this.deregisterIfNeeded();
                            GenuitecServerBehaviour.this.shutdownLaunchFinished();
                        }
                    }
                    ++i;
                }
            }
        }

        private void deregisterIfNeeded() {
            if (this.serverProcess == null && this.shutdownProcess == null) {
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)GenuitecServerBehaviour.this.processListener);
            }
        }

        public void setServerProcess(IProcess process) {
            this.serverProcess = process;
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }

        public void setShutdownProcess(IProcess process) {
            this.shutdownProcess = process;
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }
    }
}

