/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core;

import com.genuitec.eclipse.j2eedt.core.IEARProject;
import com.genuitec.eclipse.j2eedt.core.IJEEProject;
import com.genuitec.eclipse.j2eedt.core.IJEEProjectModule;
import com.genuitec.eclipse.j2eedt.core.IWebProject;
import com.genuitec.eclipse.j2eedt.core.JEEProjectManager;
import com.genuitec.eclipse.j2eedt.core.version.JEEProjectType;
import com.genuitec.eclipse.runtime.wtp.GenuitecRuntimeDelegate;
import com.genuitec.eclipse.server.core.GenuitecAppServerBehaviour;
import com.genuitec.eclipse.server.core.GenuitecServer;
import com.genuitec.eclipse.server.core.IExtURLProvider;
import com.genuitec.eclipse.server.core.IGenuitecAppServer;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.internal.J2EEUtil;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleDeployment;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.DeployMode;
import org.eclipse.wst.server.core.model.IModuleDeploymentDelegate;
import org.eclipse.wst.server.core.model.IPublishedModuleDeployment;

public abstract class GenuitecAppServer
extends GenuitecServer
implements IModuleDeploymentDelegate,
IGenuitecAppServer,
IExtURLProvider {
    private static final String[] RUNTIME_ATTRIBUTES = new String[]{"server-location", "java-location"};
    protected static final int ERR_CODE_OK_FOR_GET_ROOTS = 22;
    private IRuntimeLifecycleListener runtimeLifecycleListener;
    private PropertyChangeListener runtimeWCListener;
    private IRuntimeWorkingCopy observedRuntime;

    @Override
    protected void initialize() {
        super.initialize();
        this.runtimeLifecycleListener = new IRuntimeLifecycleListener(){

            public void runtimeRemoved(IRuntime runtime) {
            }

            public void runtimeChanged(IRuntime runtime) {
                if (runtime.equals(GenuitecAppServer.this.getServer().getRuntime())) {
                    GenuitecAppServer.this.refreshRuntimeProps();
                }
            }

            public void runtimeAdded(IRuntime runtime) {
            }
        };
        this.runtimeWCListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GenuitecAppServer.this.refreshRuntimeProps();
            }
        };
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)this.runtimeLifecycleListener);
        this.updateRuntimeListenerRegistration();
    }

    @Override
    protected void serverAttributeChanged(String attribute, String oldValue, String newValue) {
        if (attribute.equals("runtime-obj")) {
            this.updateRuntimeListenerRegistration();
        }
    }

    private void updateRuntimeListenerRegistration() {
        IRuntimeWorkingCopy oldRuntime = this.observedRuntime;
        if (this.getServer().getRuntime() != null && this.getServer().getRuntime().isWorkingCopy()) {
            this.observedRuntime = (IRuntimeWorkingCopy)this.getServer().getRuntime();
            this.observedRuntime.addPropertyChangeListener(this.runtimeWCListener);
        } else {
            this.observedRuntime = null;
        }
        if (this.observedRuntime != oldRuntime && oldRuntime != null) {
            oldRuntime.removePropertyChangeListener(this.runtimeWCListener);
        }
        this.refreshRuntimeProps();
    }

    private void refreshRuntimeProps() {
        String[] stringArray = this.getRuntimeAttributes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            this.getServerAttribute(attr);
            ++n2;
        }
    }

    @Override
    public void dispose() {
        if (this.runtimeLifecycleListener != null) {
            ServerCore.removeRuntimeLifecycleListener((IRuntimeLifecycleListener)this.runtimeLifecycleListener);
        }
        if (this.observedRuntime != null) {
            this.observedRuntime.removePropertyChangeListener(this.runtimeWCListener);
        }
        super.dispose();
    }

    protected String[] getRuntimeAttributes() {
        return RUNTIME_ATTRIBUTES;
    }

    @Override
    public String getServerAttribute(String attr) {
        if (attr.equals("server-location")) {
            IRuntime runtime = this.getServer().getRuntime();
            if (runtime != null) {
                String curLoc;
                String string = curLoc = runtime.getLocation() != null ? runtime.getLocation().toOSString() : null;
                if (this.getServerWorkingCopy() != null) {
                    this.setAttribute("server-location", curLoc);
                }
                return curLoc;
            }
        } else if (attr.equals("java-location")) {
            IVMInstall install;
            GenuitecRuntimeDelegate runtime = this.getGenuitecRuntime();
            IVMInstall iVMInstall = install = runtime != null ? runtime.getVMInstall() : null;
            if (install != null) {
                String curLoc;
                String string = curLoc = install.getInstallLocation() != null ? install.getInstallLocation().toString() : null;
                if (this.getServerWorkingCopy() != null) {
                    this.setAttribute("java-location", curLoc);
                }
                return curLoc;
            }
        }
        return super.getServerAttribute(attr);
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        if (this.getServer().getRuntime() == null) {
            return ServerCorePlugin.createErrorStatus("Server does not have a runtime assigned", new Object[0]);
        }
        HashSet<IModuleType> types = new HashSet<IModuleType>(Arrays.asList(this.getServer().getRuntime().getRuntimeType().getModuleTypes()));
        IStatus res = Status.OK_STATUS;
        if (add != null) {
            int size = add.length;
            int i = 0;
            while (i < size) {
                IModule module = add[i];
                if (!types.contains(module.getModuleType())) {
                    return ServerCorePlugin.createErrorStatus("{0} {1} is not supported", module.getModuleType().getName(), module.getModuleType().getVersion());
                }
                IStatus status = this.verifyModuleFacets(module);
                if (status.getSeverity() >= 4) {
                    return ServerCorePlugin.createErrorStatus(22, status.getMessage(), new Object[0]);
                }
                if (status.getSeverity() > res.getSeverity()) {
                    res = status;
                }
                ++i;
            }
        }
        return res;
    }

    private IStatus verifyModuleFacets(IModule module) {
        IStatus status;
        if (module.getProject() != null && (status = FacetUtil.verifyFacets((IProject)module.getProject(), (IServer)this.getServer())) != null && !status.isOK()) {
            return status;
        }
        IStatus res = Status.OK_STATUS;
        IModule[] iModuleArray = this.getChildModules(new IModule[]{module});
        int n = iModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModule child = iModuleArray[n2];
            IStatus status2 = this.verifyModuleFacets(child);
            if (status2.getSeverity() >= 4) {
                return status2;
            }
            if (status2.getSeverity() > res.getSeverity()) {
                res = status2;
            }
            ++n2;
        }
        return res;
    }

    public IModule[] getChildModules(IModule[] modulePath) {
        if (modulePath == null || modulePath.length == 0) {
            return null;
        }
        IModule module = modulePath[modulePath.length - 1];
        IModuleType moduleType = module.getModuleType();
        if (moduleType != null) {
            IEnterpriseApplication earModule;
            if ("jst.web".equals(moduleType.getId())) {
                IWebModule webModule = (IWebModule)module.loadAdapter(IWebModule.class, null);
                if (webModule != null) {
                    IModule[] modules = webModule.getModules();
                    return modules;
                }
            } else if ("jst.ear".equals(moduleType.getId()) && (earModule = (IEnterpriseApplication)module.loadAdapter(IEnterpriseApplication.class, null)) != null) {
                IModule[] modules = earModule.getModules();
                return modules;
            }
        }
        return new IModule[0];
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        ArrayList<IModule> result = new ArrayList<IModule>();
        IJEEProject project = JEEProjectManager.create((IProject)module.getProject());
        if (project != null) {
            this.addProject(result, project);
        } else {
            result.addAll(Arrays.asList(J2EEUtil.getWebModules((IModule)module, null)));
            result.addAll(Arrays.asList(J2EEUtil.getEnterpriseApplications((IModule)module, null)));
        }
        return result.toArray(new IModule[result.size()]);
    }

    private void addProject(ArrayList<IModule> result, IJEEProject project) {
        IStatus status;
        JEEProjectType type = project.getType();
        if (!(type != JEEProjectType.WEB && type != JEEProjectType.EAR && type != JEEProjectType.EJB || (status = this.canModifyModules(new IModule[]{project.getModule()}, null)) == null || status.getSeverity() >= 4 && status.getCode() != 22)) {
            result.add(project.getModule());
        }
        List parents = project.getParentProjects();
        for (IJEEProject parent : parents) {
            result.add(parent.getModule());
            this.addProject(result, parent);
        }
    }

    public GenuitecRuntimeDelegate getGenuitecRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (GenuitecRuntimeDelegate)this.getServer().getRuntime().loadAdapter(GenuitecRuntimeDelegate.class, null);
    }

    public GenuitecAppServerBehaviour getGenuitecServerDelegate() {
        return (GenuitecAppServerBehaviour)this.getServer().loadAdapter(GenuitecAppServerBehaviour.class, null);
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
    }

    public void setDefaults(IProgressMonitor monitor) {
        super.setDefaults(monitor);
        this.setAttribute("auto-publish-setting", 2);
        this.setAttribute("auto-publish-time", 1);
    }

    public String toString() {
        return "Genuitec server [" + this.getServer().getName() + "]";
    }

    public void importRuntimeConfiguration(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        super.importRuntimeConfiguration(runtime, monitor);
    }

    public void saveConfiguration(IProgressMonitor monitor) throws CoreException {
        super.saveConfiguration(monitor);
    }

    public void configurationChanged() {
        super.configurationChanged();
    }

    @Override
    public URL getModuleRootURL(IModule[] modulePath) {
        if (modulePath.length == 1 && modulePath[0].getModuleType().getId().equals("jst.web")) {
            return this.getModuleRootURL(modulePath[0]);
        }
        if (modulePath.length == 2 && modulePath[0].getModuleType().getId().equals("jst.ear") && modulePath[1].getModuleType().getId().equals("jst.web")) {
            String url = this.getServerRootURL();
            if (url == null) {
                return null;
            }
            IEARProject ear = JEEProjectManager.createEARProject((IProject)modulePath[0].getProject());
            IWebProject web = JEEProjectManager.createWebProject((IProject)modulePath[1].getProject());
            if (ear == null || web == null) {
                return null;
            }
            IJEEProjectModule module = ear.getProjectModule((IJEEProject)web);
            if (module == null) {
                return null;
            }
            try {
                String contextRoot = module.getProperty("CONTEXT_ROOT");
                if (contextRoot != null) {
                    if (!(url = String.valueOf(url) + contextRoot).endsWith("/")) {
                        url = String.valueOf(url) + "/";
                    }
                    return new URL(url);
                }
            }
            catch (MalformedURLException e) {
                ServerCorePlugin.getDefault().log(e);
            }
        }
        return null;
    }

    public URL getModuleRootURL(IModule module) {
        String url = this.getServerRootURL();
        if (url == null) {
            return null;
        }
        IWebProject web = JEEProjectManager.createWebProject((IProject)module.getProject());
        if (web == null) {
            return null;
        }
        String contextRoot = web.getContextRoot();
        if (contextRoot != null) {
            try {
                url = String.valueOf(url) + contextRoot;
                if (!url.endsWith("/")) {
                    url = String.valueOf(url) + "/";
                }
                return new URL(url);
            }
            catch (MalformedURLException e) {
                ServerCorePlugin.getDefault().log(e);
            }
        }
        return null;
    }

    private String getServerRootURL() {
        ServerPort[] ports = this.getServerPorts();
        if (ports == null) {
            return null;
        }
        ServerPort[] serverPortArray = ports;
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            String[] contentTypes;
            ServerPort port = serverPortArray[n2];
            if ("http".equalsIgnoreCase(port.getProtocol()) && (contentTypes = port.getContentTypes()) != null) {
                String[] stringArray = contentTypes;
                int n3 = contentTypes.length;
                int n4 = 0;
                while (n4 < n3) {
                    String contentType = stringArray[n4];
                    if ("web".equalsIgnoreCase(contentType)) {
                        String url = "http://" + this.getServer().getHost();
                        int portnr = ServerUtil.getMonitoredPort((IServer)this.getServer(), (int)port.getPort(), (String)"web");
                        if (portnr != 80) {
                            url = String.valueOf(url) + ":" + portnr;
                        }
                        return url;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public DeployMode calculateDeployMode(IModuleDeployment deployment) {
        IJEEProjectModule module;
        if (deployment.getParentDeployment().getDeployMode() == DeployMode.DEFAULT) {
            return DeployMode.DEFAULT;
        }
        if (deployment.getParentDeployment().getDeployMode() != DeployMode.EXPLODED) {
            return DeployMode.PACKAGED;
        }
        IJEEProject jp = JEEProjectManager.create((IProject)deployment.getProject());
        if (jp == null) {
            return DeployMode.PACKAGED;
        }
        JEEProjectType type = jp.getType();
        IJEEProject parent = JEEProjectManager.create((IProject)deployment.getParentDeployment().getProject());
        boolean isMergedUtilityModule = parent instanceof IWebProject && ((IWebProject)parent).isMergeUtilityModules() && (module = parent.getProjectModule(jp)) != null && module.deployMerged();
        boolean isExploded = parent instanceof IEARProject && (type == JEEProjectType.EJB || type == JEEProjectType.WEB || type == JEEProjectType.JCA || type == JEEProjectType.APP_CLIENT || type == JEEProjectType.UTILITY && this.getLocation(deployment, isMergedUtilityModule).segmentCount() == 0) || isMergedUtilityModule;
        return isExploded ? DeployMode.EXPLODED : DeployMode.PACKAGED;
    }

    public boolean supports(DeployMode mode) {
        return mode == DeployMode.EXPLODED || mode == DeployMode.PACKAGED;
    }

    protected IPath getLocation(IModuleDeployment deployment, boolean isMergedUtilityModule) {
        if (deployment instanceof IPublishedModuleDeployment && ((IPublishedModuleDeployment)deployment).getLocation() != null) {
            return new Path(((IPublishedModuleDeployment)deployment).getLocation());
        }
        if (isMergedUtilityModule) {
            return IClasspathDependencyConstants.WEB_INF_CLASSES_PATH;
        }
        J2EEFlexProjDeployable dpl = (J2EEFlexProjDeployable)deployment.getParentDeployment().getModule().getAdapter(J2EEFlexProjDeployable.class);
        return new Path(dpl.getURI(deployment.getModule()));
    }
}

